//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXIcon.cpp
 * @brief		ACRNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXIcon_CPP_

//======================================================================
// include
#include "WXIcon.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CIcon::CIcon(void)
: m_hIcon(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 -----------------------------------------------------------------------
 * @param [in]	hIcon = ֘AtACRnh
*//***********************************************************************/
CIcon::CIcon(HICON hIcon)
: m_hIcon(nullptr)
{
	Attach(hIcon);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CIcon::~CIcon(void)
{
	Destroy();
}

/**********************************************************************//**
 *
 * ֘At
 *
 -----------------------------------------------------------------------
 * @param [in]	hIcon = ֘AtACRnh
 * @return	
*//***********************************************************************/
BOOL CIcon::Attach(HICON hIcon)
{
	if( m_hIcon != nullptr || hIcon == nullptr ) return FALSE;
	m_hIcon = hIcon;
	return TRUE;
}

/**********************************************************************//**
 *
 * ֘At̉
 *
 -----------------------------------------------------------------------
 * @return	ȑÕACRnh
*//***********************************************************************/
HICON CIcon::Detach(void)
{
	HICON hPre = m_hIcon;
	m_hIcon = nullptr;
	return hPre;
}

/**********************************************************************//**
 *
 * 폜
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CIcon::Destroy(void)
{
	return ::DestroyIcon(Detach());
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	hInst		= CX^Xnh
 * @param [in]	nWidth		= (pixel)
 * @param [in]	nHeight		= (pixel)
 * @param [in]	byPlanes	= XOR rbg}XÑJ[v[
 * @param [in]	byBItsPixel	= XOR rbg}XÑsNZ̃rbg
 * @param [in]	lpbANDbits	= AND rbg}XÑrbgf[^
 * @param [in]	lpbXORbits	= XOR rbg}XÑrbgf[^
 * @return	
*//***********************************************************************/
BOOL CIcon::Create(HINSTANCE hInst, int nWidth, int nHeight, BYTE byPlanes, BYTE byBitsPixel, const BYTE* lpbANDbits, const BYTE* lpbXORbits)
{
	HICON hIcon = ::CreateIcon(hInst, nWidth, nHeight, byPlanes, byBitsPixel, lpbANDbits, lpbXORbits);
	return TryAttach(hIcon);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	pResBits	= \[Xrbg
 * @param [in]	dwResSize	= rbgobt@̃TCY
 * @param [in]	dwVer		= tH[}bg̃o[W
 * @return	
*//***********************************************************************/
BOOL CIcon::CreateFromResource(PBYTE pResBits, DWORD dwResSize, DWORD dwVer)
{
	HICON hIcon = ::CreateIconFromResource(pResBits, dwResSize, TRUE, dwVer);
	return TryAttach(hIcon);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	pResBits	= \[Xrbg
 * @param [in]	dwResSize	= rbgobt@̃TCY
 * @param [in]	w			= ]̕
 * @param [in]	h			= ]̍
 * @param [in]	uFlags		= tO(LR_***)
 * @param [in]	dwVer		= tH[}bg̃o[W
 * @return	
*//***********************************************************************/
BOOL CIcon::CreateFromResourceEx(PBYTE pResBits, DWORD dwResSize, int w, int h, UINT uFlags, DWORD dwVer)
{
	HICON hIcon = ::CreateIconFromResourceEx(pResBits, dwResSize, TRUE, dwVer, w, h, uFlags);
	return TryAttach(hIcon);
}

/**********************************************************************//**
 *
 * 쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	pIconInfo	= ACR
 * @return	
*//***********************************************************************/
BOOL CIcon::CreateIndirect(PICONINFO pIconInfo)
{
	HICON hIcon = ::CreateIconIndirect(pIconInfo);
	return TryAttach(hIcon);
}

/**********************************************************************//**
 *
 * ACR̃Rs[쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	hIcon	= Rs[쐬ACRnh
 * @return	
*//***********************************************************************/
BOOL CIcon::Copy(HICON hIcon)
{
	HICON hCopy = ::CopyIcon(hIcon);
	return TryAttach(hCopy);
}

/**********************************************************************//**
 *
 * ACR̕
 *
 -----------------------------------------------------------------------
 * @param [in]	hIcon	= 쐬ACRnh
 * @return	
*//***********************************************************************/
BOOL CIcon::Duplicate(HICON hIcon)
{
	HICON hCopy = ::DuplicateIcon(nullptr, hIcon);
	return TryAttach(hCopy);
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	hInst		= CX^Xnh
 * @param [in]	lpIconName	= 
 * @return	
*//***********************************************************************/
BOOL CIcon::LoadIconA(HINSTANCE hInst, LPCSTR  lpIconName)
{
	HICON hIcon = ::LoadIconA(hInst, lpIconName);
	return TryAttach(hIcon);
}
/// CIcon::LoadIconA Q
BOOL CIcon::LoadIconW(HINSTANCE hInst, LPCWSTR lpIconName)
{
	HICON hIcon = ::LoadIconW(hInst, lpIconName);
	return TryAttach(hIcon);
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	hInst	= CX^Xnh
 * @param [in]	lpPath	= t@CpX
 * @param [in]	lpIcon	= ACRԍ
 * @return	
*//***********************************************************************/
BOOL CIcon::ExtractIconA(HINSTANCE hInst, LPCSTR  lpExeFileName, UINT uIndex)
{
	HICON hIcon = ::ExtractIconA(hInst, lpExeFileName, uIndex);
	return TryAttach(hIcon);
}
/// CIcon::ExtractIconA Q
BOOL CIcon::ExtractIconW(HINSTANCE hInst, LPCWSTR lpExeFileName, UINT uIndex)
{
	HICON hIcon = ::ExtractIconW(hInst, lpExeFileName, uIndex);
	return TryAttach(hIcon);
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	hInst	= CX^Xnh
 * @param [in]	lpPath	= ACRt@CpX
 * @param [in]	lpIcon	= ACRԍ
 * @return	
*//***********************************************************************/
BOOL CIcon::ExtractAssociatedIconA(HINSTANCE hInst, LPSTR  lpPath, LPWORD lpIcon)
{
	HICON hIcon = ::ExtractAssociatedIconA(hInst, lpPath, lpIcon);
	return TryAttach(hIcon);
}
/// CIcon::ExtractAssociatedIconA Q
BOOL CIcon::ExtractAssociatedIconW(HINSTANCE hInst, LPWSTR lpPath, LPWORD lpIcon)
{
	HICON hIcon = ::ExtractAssociatedIconW(hInst, lpPath, lpIcon);
	return TryAttach(hIcon);
}

/**********************************************************************//**
 *
 * ACR̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pIconInfo	= ACR
 * @return	
*//***********************************************************************/
BOOL CIcon::GetInfo(PICONINFO pIconInfo)
{
	return ::GetIconInfo(m_hIcon, pIconInfo);
}

/**********************************************************************//**
 *
 * `
 *
 -----------------------------------------------------------------------
 * @param [in]	hDC	= foCXReLXg
 * @param [in]	x	= `xʒu
 * @param [in]	y	= `yʒu
 * @return	
*//***********************************************************************/
BOOL CIcon::Draw(HDC hDC, int x, int y)
{
	return ::DrawIcon(hDC, x, y, m_hIcon);
}

/**********************************************************************//**
 *
 * `
 *
 -----------------------------------------------------------------------
 * @param [in]	hDC		= foCXReLXg
 * @param [in]	x		= `xʒu
 * @param [in]	y		= `yʒu
 * @param [in]	w		= 
 * @param [in]	h		= 
 * @param [in]	hBrush	= wiuV
 * @param [in]	diFlags	= tO(DI_***)
 * @return	
*//***********************************************************************/
BOOL CIcon::DrawEx(HDC hDC, int x, int y, int w, int h, HBRUSH hBrush, UINT diFlags)
{
	return ::DrawIconEx(hDC, x, y, m_hIcon, w, h, 0, hBrush, diFlags);
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "iris.h"
#define	TEST_BINTURONG	// MEMO : binturong̃eXg
#ifdef TEST_BINTURONG
#include "../../../../../sample/data/res/icon1.h"
#endif

//======================================================================
// declare
LRESULT CALLBACK WXIconUnitTest_WindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

//======================================================================
// class
class CWXIconUnitTest : public iris::unit::CUnitTest<CWXIconUnitTest>
{
public:
	CIcon m_icon;
};

//======================================================================
// test
IRIS_UNITTEST_FIX(CWXIconUnitTest, WXIconUnitTest)
{
#define WINDOW_STYLE	( WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX )
#define WINDOW_STYLEEX	( WS_EX_OVERLAPPEDWINDOW )
	HWND hWnd = nullptr;
	TCHAR* pName = TEXT("WXIconUnitTest");
	HINSTANCE hInstance = (HINSTANCE)GetModuleHandle(nullptr);
	CWXIconUnitTest* ut = CWXIconUnitTest::GetCurrent();
	CIcon& icon = ut->m_icon;
#ifdef TEST_BINTURONG
	icon.Create(hInstance, icon1_ico_0_width, icon1_ico_0_height, icon1_ico_0_planes
		, icon1_ico_0_bpp, icon1_ico_0_and, icon1_ico_0_xor);
#else
#ifdef IDI_ICON1
	icon.LoadIcon(hInstance, (LPCTSTR)IDI_ICON1);
#endif
#endif

	hWnd = wx::dbg::CreateUnitTestWindow(WINDOW_STYLEEX, pName, pName, WINDOW_STYLE
		, CW_USEDEFAULT, 0, WXIconUnitTest_WindowProc);
	if( hWnd == nullptr )	return;

	SendMessage(hWnd, WM_SETICON, 0, (LPARAM)icon.GetIcon());

	wx::dbg::UnitTestMainLoop(hWnd);

	UnregisterClass(pName, hInstance);
}

/**********************************************************************//**
 *
 * eXgpEBhEvV[W
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CALLBACK WXIconUnitTest_WindowProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	//bZ[W̏
	switch( uMsg )
	{
	case WM_PAINT:
		{
			PAINTSTRUCT ps;
			HDC hdc = BeginPaint(hWnd, &ps);

			CWXIconUnitTest* ut = CWXIconUnitTest::GetCurrent();
			ut->m_icon.Draw(hdc, 0, 0);

			EndPaint(hWnd, &ps);
		}
		break;
	default:
		return ::iris::wx::dbg::UnitTest_WindowProc( hWnd, uMsg, wParam, lParam );
	}
	return 0L;
}

#endif
