//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindWindows.h
 * @brief		FindWindows t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXFindWindowss_H_
#define _IRIS_WXFindWindowss_H_

//======================================================================
// include
#include "WXEnumWindows.h"

namespace iris {
namespace wx
{

//======================================================================
// function
BOOL	EnumFindWindows (HWND hWndParent, WNDENUMPROC lpEnumFunc, LPCTSTR lpszClassName, LPCTSTR lpszWindowName, LPARAM lParam);
BOOL	EnumFindWindowsA(HWND hWndParent, WNDENUMPROC lpEnumFunc, LPCSTR  lpszClassName, LPCSTR  lpszWindowName, LPARAM lParam);
BOOL	EnumFindWindowsW(HWND hWndParent, WNDENUMPROC lpEnumFunc, LPCWSTR lpszClassName, LPCWSTR lpszWindowName, LPARAM lParam);

//======================================================================
// class
/// FindWindows NX
class CFindWindows : public CEnumWindows
{
public:
	// RXgN^
	CFindWindows(void);
	// fXgN^
	~CFindWindows(void);

public:
	// XV
	virtual void	Update(void);
};

/// [U[g FindWindows NX
template<class _TC=CFindWindows>
class CFindWindowsEx : public CFindWindows
{
	typedef _TC	TARGET;
public:
	// XV
	virtual void	Update(void)
	{
		m_Map.clear();
		EnumFindWindows(m_hParent, TARGET::_EnumChildWindowsProc, nullptr, nullptr, reinterpret_cast<LPARAM>(this));
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
