//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXError.h
 * @brief		error t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXError_H_
#define _IRIS_WXError_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// G[萔NX
class CLocalLastError : public IIrisObject
{
	DWORD	m_LastError;	//!< LastError l
public:
	// RXgN^
	CLocalLastError(void)
	{
		m_LastError = ::GetLastError();
	}
	// fXgN^
	~CLocalLastError(void)
	{
		::SetLastError(m_LastError);
	}
public:
	operator DWORD (void) { return m_LastError; }
};

/// G[擾NX
class CErrorString : public IIrisObject
{
private:
	void*	m_pString;	//!< 

public:
	// RXgN^
	CErrorString(void) : m_pString(nullptr) {}
	// fXgN^
	~CErrorString(void) { Release(); }
public:
	LPCTSTR		GetErrorString (void)	{ return static_cast<LPCTSTR>(m_pString); }
	LPCSTR		GetErrorStringA(void)	{ return static_cast<LPCSTR >(m_pString); }
	LPCWSTR		GetErrorStringW(void)	{ return static_cast<LPCWSTR>(m_pString); }
	operator	LPCSTR (void)			{ return GetErrorStringA(); }
	operator	LPCWSTR (void)			{ return GetErrorStringW(); }

public:
	// 
	void		Release(void)	{ LocalFree(m_pString); m_pString = nullptr; }
public:
	// G[萔G[̎擾
	LPCTSTR		GetErrorString (DWORD error)
	{
#ifdef UNICODE
		return GetErrorStringW(error);
#else
		return GetErrorStringA(error);
#endif
	}
	// G[萔G[̎擾
	LPCSTR		GetErrorStringA(DWORD error)
	{
		Release();
		FormatMessageA(
			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
			nullptr,
			error,
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ftHg [U[ 
			(LPSTR)&m_pString,
			0,
			nullptr );
		return GetErrorStringA();
	}

	// G[萔G[̎擾
	LPCWSTR		GetErrorStringW(DWORD error)
	{
		Release();
		FormatMessageW(
			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
			nullptr,
			error,
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // ftHg [U[ 
			(LPWSTR)&m_pString,
			0,
			nullptr );
		return GetErrorStringW();
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
