//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXEnumWindows.cpp
 * @brief		EnumWindows t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXEnumWindows_CPP_

//======================================================================
// include
#include "WXEnumWindows.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CEnumWindows::CEnumWindows(void)
: m_hParent(nullptr)
, m_dwFlags(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CEnumWindows::~CEnumWindows(void)
{
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	hWnd		= eEBhEnh(nullptr)
 * @param [in]	dwFindFlags	= tO
*//***********************************************************************/
void CEnumWindows::Initialize(HWND hWnd, DWORD dwFindFlags)
{
	m_hParent = hWnd;
	m_dwFlags = dwFindFlags;
	m_Map.clear();
}

/**********************************************************************//**
 *
 * XV
 *
*//***********************************************************************/
void CEnumWindows::Update(void)
{
	m_Map.clear();
	if( m_hParent == nullptr )
		::EnumWindows(_EnumWindowsProc, reinterpret_cast<LPARAM>(this));
	else
		::EnumChildWindows(m_hParent, _EnumChildWindowsProc, reinterpret_cast<LPARAM>(this));
}

/**********************************************************************//**
 *
 * LȏԂǂ
 *
 -----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CEnumWindows::IsValid(void)
{
	if( m_hParent != nullptr )
	{
		if( !::IsWindow(m_hParent) ) return false;
	}
	for( MAP::iterator it=m_Map.begin(), end=m_Map.end(); it != end; ++it )
	{
		if( !::IsWindow(it->second) )
		{
			return false;
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * Rg[ID EBhEnȟ
 *
 -----------------------------------------------------------------------
 * @param [in]	ctrlID	= Rg[ID
*//***********************************************************************/
CEnumWindows::MAP::iterator CEnumWindows::Find(CONTROLID ctrlID)
{
	MAP::iterator it = m_Map.find(ctrlID);
	MAP::iterator hit = it;
	size_t cnt = m_Map.count(ctrlID);
	if( cnt != 0 )
	{
		IRIS_ASSERT( it->first == ctrlID );

		for( size_t i=0; i < cnt; ++i )
		{
			HWND hWnd = it->second;
			if( !::IsWindow(hWnd) )
			{
				Update();
				return Find(ctrlID);
			}
			++it;
		}
	}
	return hit;
}

/**********************************************************************//**
 *
 * Rg[ID EBhEnȟāAqbg̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	ctrlID	= Rg[ID
*//***********************************************************************/
size_t CEnumWindows::Count(CONTROLID ctrlID)
{
	return m_Map.count(ctrlID);
}

/**********************************************************************//**
 *
 * Rg[ID EBhEnh擾
 * (B̃nhF߂Ȃ)
 *
 -----------------------------------------------------------------------
 * @param [in]	ctrlID	= Rg[ID
*//***********************************************************************/
HWND CEnumWindows::GetWindow(CONTROLID ctrlID)
{
	if( m_Map.count(ctrlID) != 1 ) return nullptr;
	MAP::iterator it = m_Map.find(ctrlID);
	IRIS_ASSERT( it != m_Map.end() );
	IRIS_ASSERT( it->first == ctrlID );
	HWND hWnd = it->second;
	if( !::IsWindow(hWnd) )
	{
		Update();
		return GetWindow(ctrlID);
	}
	return hWnd;
}

/**********************************************************************//**
 *
 * 񋓃R[obN֐
 *
 -----------------------------------------------------------------------
 * @param [in]	hWnd	= qbgEBhEnh
 * @param [in]	lParam	= CEnumWindows*
 * @retval	TRUE	= s
 * @retval	FALSE	= I
*//***********************************************************************/
BOOL CALLBACK CEnumWindows::_EnumWindowsProc(HWND hWnd, LPARAM lParam)
{
	IRIS_ASSERT( lParam != 0 );
	CEnumWindows* p = reinterpret_cast<CEnumWindows*>(lParam);
	p->m_Map.insert(PAIR(::GetDlgCtrlID(hWnd), hWnd));
	if( p->m_dwFlags & FIND_RECURSION )
	{
		// qEBhE
		::EnumChildWindows(hWnd, _EnumChildWindowsProc, lParam);
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * 񋓃R[obN֐
 *
 -----------------------------------------------------------------------
 * @param [in]	hWnd	= qbgEBhEnh
 * @param [in]	lParam	= CEnumWindows*
 * @retval	TRUE	= s
 * @retval	FALSE	= I
*//***********************************************************************/
BOOL CALLBACK CEnumWindows::_EnumChildWindowsProc(HWND hWnd, LPARAM lParam)
{
	IRIS_ASSERT( lParam != 0 );
	CEnumWindows* p = reinterpret_cast<CEnumWindows*>(lParam);
	if( !(p->m_dwFlags & FIND_RECURSION) )
	{
		if( p->m_hParent != ::GetParent(hWnd) ) return TRUE;
	}
	p->m_Map.insert(PAIR(::GetDlgCtrlID(hWnd), hWnd));
	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris

