//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXConsole.h
 * @brief		R\[NX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXConsole_H_
#define _IRIS_WXConsole_H_

//======================================================================
// include
#include "fnd/utility/FndRefCounter.h"
#include <map>

namespace iris {
namespace wx 
{

//======================================================================
// typedef
#if	IRIS_MSC_AT_LESS(1500)
typedef LPVOID	PCONSOLE_READCONSOLE_CONTROL;
#endif

//======================================================================
// function
// R\[EBhẼEBhEnh擾
HWND	GetConsoleWindow(void);

//======================================================================
// class
//! R\[NX
class CConsole : protected fnd::CRefCounter
{
public:
	typedef std::map<int,HANDLE>	PAGE;
	typedef std::pair<int,HANDLE>	PAGEPAIR;
	enum { PAGE_DEFAULT = -1, };	//!< // ftHgy[WID
private:
	HANDLE	m_hConsole;
	HANDLE	m_hCurrent;
	int		m_PageNo;
	FILE*	m_stdout;
	FILE*	m_stdin;
	FILE*	m_stderr;
	// y[W
	PAGE	m_Page;
	bool	m_bExist;
public:
	// RXgN^
	CConsole(void);
	// fXgN^
	virtual ~CConsole(void);
public:
	// J
	virtual bool	Open(bool std=true);
	// 
	virtual void	Close(void);
public:
	// o
	void	PrintA(LPCSTR  format, ... );
	void	PrintW(LPCWSTR format, ... );
	void	Print (LPCTSTR format, ... );
	void	PrintA(LPCSTR  format, va_list va );
	void	PrintW(LPCWSTR format, va_list va );
	void	Print (LPCTSTR format, va_list va );

public:
	// y[Wǉ
	bool	AddPage(int page, DWORD dwAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpAttributes);
	// y[W폜
	bool	DelPage(int page);
	// y[WύX
	bool	SetPage(int page=PAGE_DEFAULT);
	/// ݂̃y[Wԍ擾
	int		GetPageNo(void)	{ return m_PageNo; }

protected:
	// R\[̃nh擾
	HANDLE	GetConsoleHandle(void)	{ return m_hConsole; }

	// nh擾
	HANDLE	GetHandle(int page=PAGE_DEFAULT);

public:

	// set, get
	// 
	HANDLE	GetCurrentHandle(void)	{ return m_hCurrent; }
    // nh̎擾
	HANDLE	operator()(void)		{ return GetCurrentHandle(); }

public:

	// EBhEnh̎擾
	HWND	GetHWND(void);
	// eEBhEnh̐ݒ
	HWND	SetParent(HWND hWndNewParent);

public:
	// wrap
	DWORD	GetConsoleTitleA(LPSTR  lpTitle, DWORD dwSize);
	DWORD	GetConsoleTitleW(LPWSTR lpTitle, DWORD dwSize);

	BOOL	SetConsoleTitleA(LPCSTR  lpTitle);
	BOOL	SetConsoleTitleW(LPCWSTR lpTitle);

	BOOL	FlushInputBuffer(void);
	BOOL	GetNumberOfInputEvents(LPDWORD lpNumberOfEvents);
	BOOL	SetCtrlHandler(PHANDLER_ROUTINE Handler, BOOL Add);
	BOOL	AddCtrlHandler(PHANDLER_ROUTINE Handler);
	BOOL	DelCtrlHandler(PHANDLER_ROUTINE Handler);

	UINT	GetCP(void);
	BOOL	SetCP(UINT CodePageID);

	BOOL	ReadConsoleA(LPVOID lpBuf, DWORD dwRead, LPDWORD lpRead, PCONSOLE_READCONSOLE_CONTROL lpInputControl=nullptr);
	BOOL	ReadConsoleW(LPVOID lpBuf, DWORD dwRead, LPDWORD lpRead, PCONSOLE_READCONSOLE_CONTROL lpInputControl=nullptr);

	BOOL	ReadConsoleInputA(PINPUT_RECORD lpBuf, DWORD dwLength, LPDWORD lpRead);
	BOOL	ReadConsoleInputW(PINPUT_RECORD lpBuf, DWORD dwLength, LPDWORD lpRead);

	BOOL	ReadConsoleOutputA(PCHAR_INFO lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion);
	BOOL	ReadConsoleOutputW(PCHAR_INFO lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion);

	BOOL	WriteConsoleA(const void* lpBuf, DWORD dwWrite, LPDWORD lpWritten, LPVOID lpReserved=nullptr);
	BOOL	WriteConsoleW(const void* lpBuf, DWORD dwWrite, LPDWORD lpWritten, LPVOID lpReserved=nullptr);

	BOOL	WriteConsoleInputA(const INPUT_RECORD* lpBuf, DWORD dwWrite, LPDWORD lpWritten);
	BOOL	WriteConsoleInputW(const INPUT_RECORD* lpBuf, DWORD dwWrite, LPDWORD lpWritten);

	BOOL	WriteConsoleOutputA(const CHAR_INFO* lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion);
	BOOL	WriteConsoleOutputW(const CHAR_INFO* lpBuf, COORD dwSize, COORD dwCoord, PSMALL_RECT lpRegion);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
