//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXWindowProc.h
 * @brief		EBhEvV[Wx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXWindowProc_H_
#define _IRIS_WXWindowProc_H_

//======================================================================
// include
#include "fnd/container/FndObserver.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
class CWndProcSubject;
class CWndProcObserver;

//======================================================================
// class
//! EBhEvV[WĎNX
class CWndProcSubject : public fnd::CSubject<CWndProcObserver>
{
public:
	// RXgN^
	CWndProcSubject(void);
	// fXgN^
	virtual ~CWndProcSubject(void);
public:
	// Cxg
	// evV[W󂯂bZ[WqɑM
	virtual	LRESULT	SendParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
};
//! EBhEvV[WĎNX
class CWndProcObserver : public fnd::CObserver<CWndProcObserver>
{
public:
	// RXgN^
	CWndProcObserver(void);
	// fXgN^
	virtual ~CWndProcObserver(void);
public:
	// EBhEnh̎擾
	virtual HWND	GetHWND(void)	{ return nullptr; }
	// Cxg
	// evV[W󂯂bZ[WM
	virtual	LRESULT	RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
