//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXWindow.cpp
 * @brief		EBhEx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXWindow_CPP_

//======================================================================
// include
#include "WXWindow.h"
#include "../base/WXError.h"
#include "iris_debug.h"

#include "../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// variable
CWindow::CWndMap	CWindow::s_WndMap;
CWindow*			CWindow::s_pWindow = nullptr;

//======================================================================
// function
/**********************************************************************//**
 *
 * NCAg̈悩XN[̈ɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	lprc	= o͗̈	
*//***********************************************************************/
BOOL ClientToScreenRect(HWND hWnd, LPRECT lprc)
{
	if( lprc == nullptr ) return FALSE;
	BOOL ret = ClientToScreen(hWnd, (LPPOINT)lprc);
	ret &= ClientToScreen(hWnd, ((LPPOINT)lprc) + 1);
	return ret;
}

/**********************************************************************//**
 *
 * XN[̈悩NCAg̈ɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	lprc	= o͗̈	
*//***********************************************************************/
BOOL ScreenToClientRect(HWND hWnd, LPRECT lprc)
{
	if( lprc == nullptr ) return FALSE;
	BOOL ret = ScreenToClient(hWnd, (LPPOINT)lprc);
	ret &= ScreenToClient(hWnd, ((LPPOINT)lprc) + 1);
	return ret;
}

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CWindow::CWindow(void)
: m_hWnd(nullptr)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CWindow::CWindow(HWND hWnd)
{
	Attach(hWnd);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CWindow::~CWindow(void)
{
	Detach();
}

/**********************************************************************//**
 *
 * EBhEXgɒǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @return	true:, false:s
*//***********************************************************************/
bool CWindow::Attach(HWND hWnd)
{
	if( hWnd == nullptr && m_hWnd != nullptr ) return false;
	if( Find(hWnd) != nullptr ) return false;
	s_WndMap.insert( CWndPair( hWnd, this ) );
	m_hWnd = hWnd;
	return true;
}

/**********************************************************************//**
 *
 * EBhEXgO
 *
 ----------------------------------------------------------------------
 * @return	֘AtĂEBhEnh
*//***********************************************************************/
HWND CWindow::Detach(void)
{
	HWND hWnd = m_hWnd;
	if( hWnd != nullptr )
	{
		CWndMap::iterator it = s_WndMap.find( hWnd );
		if( it != s_WndMap.end() && it->first == hWnd )
			s_WndMap.erase( it );
	}
	m_hWnd = nullptr;
	return hWnd;
}

/**********************************************************************//**
 *
 * EBhE
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd  =	 EBhEnh
 * @return	EBhENX|C^
*//***********************************************************************/
CWindow* CWindow::Find(HWND hWnd)
{
	CWndMap::const_iterator it = s_WndMap.find( hWnd );
	if( it == s_WndMap.end() ) return nullptr;
	if( it->first != hWnd )	return nullptr;
	return it->second;
}

/**********************************************************************//**
 *
 * EBhEvV[W
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CALLBACK CWindow::_DefWindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	CWindow *pWindow = Find( hWnd );
	switch( uMsg )
	{
	case WM_CREATE:
	case WM_INITDIALOG:
		if( pWindow == nullptr )
		{
			pWindow = s_pWindow;
			s_pWindow = nullptr;
		}
		break;
	case WM_DESTROY:
		if( pWindow != nullptr )
		{
			pWindow->Detach();
		}
		break;
	}

	if( pWindow != nullptr )
	{
		LRESULT ret = pWindow->WndProc( hWnd, uMsg, wParam, lParam );
		pWindow->m_Subject.SendParentMessage( hWnd, uMsg, wParam, lParam );
		return ret;
	}
	return ::DefWindowProc( hWnd, uMsg, wParam, lParam );
}

/**********************************************************************//**
 *
 * EBhENX̓o^
 *
 ----------------------------------------------------------------------
 * @param	uStyle			= EBhENX̃X^C
 * @param	hInstance		= CX^Xnh
 * @param	wndproc			= EBhEvV[W
 * @param	hIcon			= ACR̃nh
 * @param	hCursor			= J[\̃nh
 * @param	hbrBackground	= wiF̃nh
 * @param	pClassName		= EBhENX̖O
 * @param	pMenuName		= NX̃j[̖O
 * @param	hIconSm			= X[ACR̃nh
 * @return	ATOMl
*//***********************************************************************/
ATOM CWindow::RegisterClassExA(UINT uStyle, HINSTANCE hInstance
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCSTR pClassName
							   , LPCSTR pMenuName, HICON hIconSm
							   , WNDPROC wndproc )
{
	WNDCLASSEXA wcex = {0};// WNDCLASSEX\
	wcex.cbSize			= sizeof( wcex );	// WNDCLASSEX\̂̃TCY
	wcex.style			= uStyle;			// EBhENX̃X^C
	wcex.lpfnWndProc	= wndproc;			// EBhEvV[W
	wcex.cbClsExtra		= 0;				// gp̃p[^
	wcex.cbWndExtra		= 0;				// gp̃p[^
	wcex.hInstance		= hInstance;		// CX^Xnh
	wcex.hIcon			= hIcon;			// ACR̃nh
	wcex.hCursor		= hCursor;			// J[\̃nh
	wcex.hbrBackground	= hbrBackground;	// wiF̃nh
	wcex.lpszMenuName	= pMenuName;		// NX̃j[̖O
	wcex.lpszClassName	= pClassName;		// EBhENX̖O
	wcex.hIconSm		= hIconSm;			// X[ACR̃nh
	return ::RegisterClassExA( &wcex );
}

/**********************************************************************//**
 *
 * EBhENX̓o^
 *
 ----------------------------------------------------------------------
 * @param	uStyle			= EBhENX̃X^C
 * @param	hInstance		= CX^Xnh
 * @param	wndproc			= EBhEvV[W
 * @param	hIcon			= ACR̃nh
 * @param	hCursor			= J[\̃nh
 * @param	hbrBackground	= wiF̃nh
 * @param	pClassName		= EBhENX̖O
 * @param	pMenuName		= NX̃j[̖O
 * @param	hIconSm			= X[ACR̃nh
 * @return	ATOMl
*//***********************************************************************/
ATOM CWindow::RegisterClassExW(UINT uStyle, HINSTANCE hInstance
							   , HICON hIcon, HCURSOR hCursor
							   , HBRUSH hbrBackground, LPCWSTR pClassName
							   , LPCWSTR pMenuName, HICON hIconSm
							   , WNDPROC wndproc )
{
	WNDCLASSEXW wcex = {0};// WNDCLASSEX\
	wcex.cbSize			= sizeof( wcex );	// WNDCLASSEX\̂̃TCY
	wcex.style			= uStyle;			// EBhENX̃X^C
	wcex.lpfnWndProc	= wndproc;			// EBhEvV[W
	wcex.cbClsExtra		= 0;				// gp̃p[^
	wcex.cbWndExtra		= 0;				// gp̃p[^
	wcex.hInstance		= hInstance;		// CX^Xnh
	wcex.hIcon			= hIcon;			// ACR̃nh
	wcex.hCursor		= hCursor;			// J[\̃nh
	wcex.hbrBackground	= hbrBackground;	// wiF̃nh
	wcex.lpszMenuName	= pMenuName;		// NX̃j[̖O
	wcex.lpszClassName	= pClassName;		// EBhENX̖O
	wcex.hIconSm		= hIconSm;			// X[ACR̃nh
	return ::RegisterClassExW( &wcex );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszClassName	= EBhENX̖O
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CWindow::Create(LPCTSTR lpszClassName
					, LPCTSTR lpszWindowName, DWORD dwStyle
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam)
{
	// EBhE̍쐬
	return CreateEx(0L
		, lpszClassName
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	lpszClassName	= EBhENX̖O
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CWindow::CreateEx(DWORD dwExStyle, LPCTSTR lpszClassName
					   , LPCTSTR lpszWindowName, DWORD dwStyle
					   , const RECT &rRect
					   , HWND hWndParent, UINT nID
					   , HINSTANCE hInstance
					   , void *pParam )
{
	return CreateWindowEx(dwExStyle
		, lpszClassName
		, lpszWindowName
		, dwStyle
		, rRect.left
		, rRect.top
		, rRect.right - rRect.left
		, rRect.bottom - rRect.top
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle	= gEBhEX^C
 * @param [in]	pClassName	= EBhENX̖O
 * @param [in]	pWindowName	= EBhE̖O
 * @param [in]	dwStyle		= EBhEX^C
 * @param [in]	nX			= EBhExW
 * @param [in]	nY			= EBhEyW
 * @param [in]	nWidth		= EBhE̕
 * @param [in]	nHeight		= EBhE̍
 * @param [in]	hWndParent	= ẽEBhEnh
 * @param [in]	hMenu		= j[nh
 * @param [in]	hInstance	= CX^Xnh
 * @param [in]	pParam		= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CWindow::CreateWindowExA(DWORD dwExStyle, LPCSTR pClassName
							  , LPCSTR pWindowName, DWORD dwStyle
							  , int nX, int nY, int nWidth, int nHeight
							  , HWND hWndParent, HMENU hMenu
							  , HINSTANCE hInstance, void *pParam )
{
	HWND hWnd = nullptr;
	if( m_hWnd != nullptr ) return nullptr;
	s_pWindow = this;
	// EBhE̍쐬
	hWnd = ::CreateWindowExA(
		dwExStyle,
		pClassName,
		pWindowName,
		dwStyle,
		nX,
		nY,
		nWidth,
		nHeight,
		hWndParent,
		hMenu,
		hInstance,
		pParam );
	s_pWindow = nullptr;
	if( hWnd == nullptr ) 
	{
#ifdef _IRIS_DEBUG
		DWORD error = GetLastError();
		if( error != 0 )
		{
			CErrorString err_str;
			IRIS_WARNING(err_str.GetErrorStringA(error));
		}
		IRIS_WARNING("CreateWindowEx failed.");
#endif
		return nullptr;
	}
	Attach( hWnd );
	return hWnd;
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle	= gEBhEX^C
 * @param [in]	pClassName	= EBhENX̖O
 * @param [in]	pWindowName	= EBhE̖O
 * @param [in]	dwStyle		= EBhEX^C
 * @param [in]	nX			= EBhExW
 * @param [in]	nY			= EBhEyW
 * @param [in]	nWidth		= EBhE̕
 * @param [in]	nHeight		= EBhE̍
 * @param [in]	hWndParent	= ẽEBhEnh
 * @param [in]	hMenu		= j[nh
 * @param [in]	hInstance	= CX^Xnh
 * @param [in]	pParam		= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CWindow::CreateWindowExW(DWORD dwExStyle, LPCWSTR pClassName
							  , LPCWSTR pWindowName, DWORD dwStyle
							  , int nX, int nY, int nWidth, int nHeight
							  , HWND hWndParent, HMENU hMenu
							  , HINSTANCE hInstance, void *pParam )
{
	HWND hWnd = nullptr;
	if( m_hWnd != nullptr ) return nullptr;
	s_pWindow = this;
	// EBhE̍쐬
	hWnd = ::CreateWindowExW(
		dwExStyle,
		pClassName,
		pWindowName,
		dwStyle,
		nX,
		nY,
		nWidth,
		nHeight,
		hWndParent,
		hMenu,
		hInstance,
		pParam );
	s_pWindow = nullptr;
	if( hWnd == nullptr ) 
	{
#ifdef _IRIS_DEBUG
		DWORD error = GetLastError();
		if( error != 0 )
		{
			CErrorString err_str;
			IRIS_WARNING(err_str.GetErrorStringA(error));
		}
		IRIS_WARNING("CreateWindowEx failed.");
#endif
		return nullptr;
	}
	Attach( hWnd );
	return hWnd;
}

/**********************************************************************//**
 *
 * MINMAXINFO̎擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpmm	= o͍\
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CWindow::GetMinMaxInfo(LPMINMAXINFO lpmm)
{
	return (SendMessage(WM_GETMINMAXINFO, 0, (LPARAM)lpmm) == 0) ? TRUE : FALSE;
}
#endif

/**********************************************************************//**
 *
 * FlashWindowEx
 *
 ----------------------------------------------------------------------
 * @param [in]	dwTimeout	= _ŊԊu
 * @param [in]	dwFlags		= FLASHW_***
 * @param [in]	uCount		= _ŉ
 * @return	
*//***********************************************************************/
#if	!defined(IRIS_WIN32_WCE)
BOOL CWindow::FlashWindowEx(DWORD dwTimeout, DWORD dwFlags, UINT uCount)
{
	FLASHWINFO fwi;
	fwi.cbSize	= sizeof(fwi);
	fwi.hwnd	= m_hWnd;
	fwi.dwFlags	= dwFlags;
	fwi.uCount	= uCount;
	fwi.dwTimeout = dwTimeout;
	return ::FlashWindowEx(&fwi);
}
#endif

/**********************************************************************//**
 *
 * SetClientSize
 *
 ----------------------------------------------------------------------
 * @param [in]	w			= 
 * @param [in]	h			= 
 * @param [in]	bRepaint	= ĕ`tO
 * @return	
*//***********************************************************************/
BOOL CWindow::SetClientSize(int w, int h, BOOL bRepaint)
{
	HWND hWnd = GetParent();
	RECT src, rc = { 0, 0, w, h };
	GetWindowRect( &src );
	LPPOINT pt = (LPPOINT)&src;
	::AdjustWindowRect(&rc, GetWindowLong(GWL_STYLE), GetMenu() == nullptr ? FALSE : TRUE );
	if( hWnd != nullptr ) ::ScreenToClient(hWnd, pt);
	return MoveWindow(pt->x, pt->y, rc.right-rc.left, rc.bottom-rc.top, bRepaint);
}

/**********************************************************************//**
 *
 * EBhËeEBhẼNCAgWnŎ擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lprc	= ̈
 * @return	
*//***********************************************************************/
BOOL CWindow::GetClientRectFromParent(LPRECT lprc)
{
	HWND hWnd = GetParent();
	if( !GetWindowRect( lprc ) ) return FALSE;
	return ScreenToClientRect(hWnd, lprc);
}

/**********************************************************************//**
 *
 * SetWindowSize
 *
 ----------------------------------------------------------------------
 * @param [in]	w			= 
 * @param [in]	h			= 
 * @param [in]	bRepaint	= ĕ`tO
 * @return	
*//***********************************************************************/
BOOL CWindow::SetWindowSize(int w, int h, BOOL bRepaint)
{
	HWND hWnd = GetParent();
	RECT src = {0};
	GetWindowRect( &src );
	LPPOINT pt = (LPPOINT)&src;
	if( hWnd != nullptr ) ::ScreenToClient(hWnd, pt);
	return MoveWindow(pt->x, pt->y, w, h, bRepaint);
}

/**********************************************************************//**
 *
 * SetWindowPos
 *
 ----------------------------------------------------------------------
 * @param [in]	hWndInsertAfter	= HWND_*** or EBhEnh
 * @param [in]	nX				= XW
 * @param [in]	nY				= YW
 * @param [in]	nFlags			= SWP_***
 * @return	
*//***********************************************************************/
BOOL CWindow::SetWindowPos(HWND hWndInsertAfter, int nX, int nY, int nFlags)
{
	RECT src = {0};
	GetWindowRect( &src );
	return SetWindowPos( hWndInsertAfter, nX, nY, src.right-src.left, src.bottom-src.top, nFlags );
}

/**********************************************************************//**
 *
 * EBhE̕擾
 *
 ----------------------------------------------------------------------
 * @return	EBhE̕
*//***********************************************************************/
LONG CWindow::GetWindowWidth(void)
{
	RECT rc;
	GetWindowRect(&rc);
	return rc.right - rc.left;
}

/**********************************************************************//**
 *
 * EBhE̍擾
 *
 ----------------------------------------------------------------------
 * @return	EBhE̍
*//***********************************************************************/
LONG CWindow::GetWindowHeight(void)
{
	RECT rc;
	GetWindowRect(&rc);
	return rc.bottom - rc.top;
}

/**********************************************************************//**
 *
 * GetScrollInfo
 *
 ----------------------------------------------------------------------
 * @param [in]	nBar	= XN[o[̃^Cv
 * @param [out]	lps		= o
 * @param [in]	nMask	= }XN
 * @return	
*//***********************************************************************/
BOOL CWindow::GetScrollInfo(int nBar, LPSCROLLINFO lpsi, int nMask)
{
	lpsi->cbSize = sizeof(SCROLLINFO);
	lpsi->fMask = nMask;
	return GetScrollInfo(nBar,lpsi);
}

/**********************************************************************//**
 *
 * GetScrollInfo
 *
 ----------------------------------------------------------------------
 * @param [in]	nBar	= XN[o[̃^Cv
 * @return	XN[o[̍őXN[ʒu
*//***********************************************************************/
int CWindow::GetScrollLimit(int nBar)
{
	int nMin = 0, nMax = 0;
	SCROLLINFO info = {0};
	GetScrollRange( nBar, &nMin, &nMax );
	if( GetScrollInfo( nBar, &info, SIF_PAGE ) != FALSE )
	{
		nMax -= __max( info.nPage - 1, 0 );
	}
	return nMax;
}

/**********************************************************************//**
 *
 * CX^Xnh̎擾
 *
 ----------------------------------------------------------------------
 * @return	CX^Xnh
*//***********************************************************************/
HINSTANCE CWindow::GetInstanceHandle(void)
{
	return (HINSTANCE)(LONG_PTR)GetWindowLong(GWL_HINSTANCE);
}

/**********************************************************************//**
 *
 * XN[o[̕\
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CWindow::IsHScrollVisible(void)
{
	if( GetWindowLong(GWL_STYLE) & WS_HSCROLL ) return TRUE;
	return FALSE;
}

/**********************************************************************//**
 *
 * XN[o[̕\
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CWindow::IsVScrollVisible(void)
{
	if( GetWindowLong(GWL_STYLE) & WS_VSCROLL ) return TRUE;
	return FALSE;
}

/**********************************************************************//**
 *
 * ^CgeLXg̎擾
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CWindow::GetWindowTextA(std::string&  str)
{
	int len = GetWindowTextLengthA();
	if( len <= 0 ) return FALSE;
	++len;
	LPSTR pStr = new char [len];
	GetWindowTextA(pStr, len);
	str = pStr;
	delete [] pStr;
	return TRUE;
}

/**********************************************************************//**
 *
 * ^CgeLXg̎擾
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CWindow::GetWindowTextW(std::wstring& str)
{
	int len = GetWindowTextLengthW();
	if( len <= 0 ) return FALSE;
	++len;
	LPWSTR pStr = new WCHAR [len];
	GetWindowTextW(pStr, len);
	str = pStr;
	delete [] pStr;
	return TRUE;
}

/**********************************************************************//**
 *
 * G[\
 *
 ----------------------------------------------------------------------
 * @param [in]	text	= \eLXg
 * @param [in]	cap		= LvV
 * @param [in]	uType	= MessageBox̃^Cv
 * @return	
*//***********************************************************************/
UINT CWindow::Error(LPCTSTR text, LPCTSTR cap, UINT uType )
{
#ifdef _IRIS_DEBUG
	std::_tstring t;
	DWORD error = GetLastError();
	if( error != 0 )
	{
		CErrorString err_msg;
		TCHAR err_str[32];
		wsprintf(err_str, IRIS_TEXT("%x : "), error);
		err_msg.GetErrorString(error);
		if( text != nullptr )
		{
			t =	 text;
			t += IRIS_TEXT("\n");
			t += err_str;
			t += err_msg;
		}
		else
		{
			t = err_str;
			t += err_msg;
		}
		dprintf((LPCTSTR)err_msg);
	}
	return MessageBox(t.c_str(), cap, uType);
#else
	return MessageBox(text, cap, uType);
#endif
}

}	// end of namespace wx
}	// end of namespace iris
