//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDXApplication.h
 * @brief		DirectX@AvP[Vx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXDXApplication_H_
#define _IRIS_WXDXApplication_H_

//======================================================================
// include
#include "WXApplication.h"
#include "../../d3dx/gx/DXDevice.h"
#include "fnd/system/FndTimer.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// DirectX AvP[VNX
class CDXApplication : public CApplication
{
protected:
	dx::CDXDevice	m_Device;	//!< foCXNX
	fnd::ITimer*	m_pTimer;		//!< fpsp
public:
	// RXgN^
	CDXApplication(LPCTSTR AppName, fnd::ITimer* pTimer);
	// fXgN^
	~CDXApplication(void);
	
public:
	// XV
	virtual void	Transaction(void);
	// XV
	virtual void	Update(float time);
	// `
	virtual void	Draw(void);

public:
	// Cxgnh
	__IrisAppEventFunc(Create);
	__IrisAppEventFunc(Paint);
	__IrisAppEventFunc(SetFocus);
	__IrisAppEventFunc(KillFocus);
	__IrisAppEventFunc(Enable);
	__IrisAppEventFunc(Size);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
