//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		FBXAttribute.h
 * @brief		FBX SDK attributeNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_FBXAttribute_H_
#define INCG_IRIS_FBXAttribute_H_

//======================================================================
// include
#ifdef _IRIS_SUPPORT_FBX
#include "FBXNode.h"
#endif

#ifdef _IRIS_SUPPORT_FBX

namespace iris {
namespace gx {
namespace fbx
{

//======================================================================
// class
/**
 * @ingroup	FBX
 * @brief	FBX SDK Attribute
 * @tparam	Attribute Object
*/
template<class _Kfbx>
class IFBXAttribute : public IFBXObjectBase<_Kfbx>
{
	typedef IFBXAttribute<_Kfbx>	_Myt;
	typedef IFBXObjectBase<_Kfbx>	_Mybase;
public:
	/// RXgN^
	IFBXAttribute(void)	{}
	/// RXgN^
	IFBXAttribute(kfbx_ptr ptr) : _Mybase(ptr)	{}
	/// RXgN^
	IFBXAttribute(_Myt& obj) : _Mybase(obj.m_pKfbx)	{}

public:
	/**
	 * @brief	m[h̎擾
	 * @return	m[h
	*/
	KFbxNode*	GetNode(void)
	{
		if( m_pKfbx == nullptr ) return nullptr;
		return m_pKfbx->GetNode();
	}
	KFbxNode const*	GetNode(void) const
	{
		if( m_pKfbx == nullptr ) return nullptr;
		return m_pKfbx->GetNode();
	}
	/**
	 * @brief	em[h̎擾
	 * @return	em[h
	*/
	KFbxNode*	GetParentNode(void)
	{
		KFbxNode* node = GetNode();
		if( node == nullptr ) return nullptr;
		return node->GetParent();
	}
	KFbxNode const*	GetParentNode(void) const
	{
		KFbxNode* node = GetNode();
		if( node == nullptr ) return nullptr;
		return node->GetParent();
	}
	/**
	 * @brief	ȇ擾
	 * @return	ȇIuWFNg
	*/
	KFbxNodeAttribute*	GetParentAttribute(void)
	{
		KFbxNode* parent = GetParentNode();
		if( parent == nullptr ) return nullptr;
		return parent->GetNodeAttribute();
	}
	KFbxNodeAttribute const*	GetParentAttribute(void) const
	{
		KFbxNode* parent = GetParentNode();
		if( parent == nullptr ) return nullptr;
		return parent->GetNodeAttribute();
	}

public:
	/**
	 * @brief	O[o}gbNX̎擾
	 * @return	}gbNX
	*/
	KFbxXMatrix GetGlobalPosition(KTime& rTime, KFbxXMatrix* pParent=nullptr) const
	{
		return fbx::GetGlobalPosition(GetNode(), rTime, pParent);
	}
	/**
	 * @brief	O[o}gbNX̎擾
	 * @return	}gbNX
	*/
	KFbxXMatrix GetGlobalPosition(KTime& rTime, KFbxPose* pPose, KFbxXMatrix* pParent=nullptr) const
	{
		return fbx::GetGlobalPosition(GetNode(), rTime, pPose, pParent);
	}
	/**
	 * @brief	WIg}gbNX̎擾
	 * @return	}gbNX
	*/
	KFbxXMatrix GetGeometricMatrix(void) const
	{
		return fbx::GetGeometricMatrix(GetNode());
	}
};


}	// end of namespace fbx
}	// end of namespace gx
}	// end of namespace iris

#endif

#endif
