//ステージの設定
//	グローバル名前空間にmainManagerがすでに存在する状況下で呼ばれる。
//	最初の行で新たなインスタンスを生成し、最後のreturnでそれを返す。

stage = new GameStage();

//関数のオーバーライド
stage.runStage = function(){
	//元々定義されていた、疑似スーパークラス(prototype)の関数を呼び出す。
	GameStage.prototype.runStage.apply(this, []);
	this.authform = createDOMObject("form", "authform", "MainArea");
	this.authform.style.zIndex = 4;
	this.authform.style.position = "absolute";
	this.authform.style.top = "300px";
	this.authform.style.left = "80px";
	this.authform.onsubmit = function () { this.submitAuth; return false;};
	this.authform.innerHTML = "ユーザー名:<input id='authUserName' type='text' name='userName' style='z-index:6' size='50'/>";
	this.authform.innerHTML += "<input id='authSubmitButton' type='button' value='ログイン'>";
	this.authSubmitButton = document.getElementById("authSubmitButton");
	this.authSubmitButton.onclick = this.submitAuth;
	this.background = createImage("title.jpg");
	this.manager.setBackgroundMusic("005.mp3");
};
stage.submitAuth = function(){
	mainManager.userManager.loginAs(mainManager.runningStage.authform.userName.value);
	return false; //常に送信しない。
};

stage.stopStage = function(){
	destroyDOMObjectByID("authform");
	//元々定義されていた、疑似スーパークラス(prototype)の関数を呼び出す。
	GameStage.prototype.stopStage.apply();
};

stage;
