<?php
//FOR DEBUG
mysqli_report(MYSQLI_REPORT_ERROR);

require("header.php");

$db = new mysqli('localhost', DATABASE_USER, DATABASE_PWD, DATABASE_NAME);
if (mysqli_connect_error()) {
	responseError();
}
// 文字化け防止
$db->set_charset("utf8");
//action解釈
if(isset($_GET['action'])){
	$action = $_GET['action'];
	if(strcmp($action, 'rebuild') == 0){
		//すでにあるテーブルの削除
		//authUserTable
		$stmt = $db->prepare("drop table authUserTable");
		$stmt->execute();
		//エラーチェック省略
		$stmt->close();
		//stageObjectTable
		$stmt = $db->prepare("drop table stageObjectTable");
		$stmt->execute();
		//エラーチェック省略
		$stmt->close();
		//再生成
		//authUserTable
		$stmt = $db->prepare("
create table authUserTable (
	id int auto_increment,
	name text character set utf8,
	lastResponseTimestamp bigint,
	userStageName char(64),
	userCharacterBaseClass char(64),
	index(id)
)");
		$stmt->execute();
		//エラーチェック省略
		$stmt->close();
		//stageObjectTable
		$stmt = $db->prepare("
create table stageObjectTable (
	id int auto_increment,
	locationX double,
	locationY double,
	velocityX double,
	velocityY double,
	stageName char(64),
	className char(64),
	objectAttribute text character set utf8,
	constructorArgs text character set utf8,
	ownerUserID int,
	modifiedTimestamp bigint,
	addedTimestamp bigint,
	index(id)
)");
		$stmt->execute();
		//エラーチェック省略
		$stmt->close();
	}
} else{
	//action未指定のときはデフォルト動作
	//timestamp
	echo("[" . getTimeStampMs() . ",");
	//userList
	$stmt = $db->prepare("select id, name, lastResponseTimestamp, userStageName from authUserTable");
	$stmt->execute();
	$stmt->store_result();
	if($stmt->errno != 0){
		exit("error1");
	}
	$stmt->bind_result($uid, $uname, $rts, $stgname);
	echo ("[");
	while($stmt->fetch()){
		echo("\"" . $rts . ": " . $uid . ": " . $uname . " in " . $stgname . "\",");
	}
	echo ("],");
	$stmt->close();
	//objectlist
	$stmt = $db->prepare("select id,stageName,ownerUserID,className,modifiedTimestamp from stageObjectTable");
	$stmt->execute();
	$stmt->store_result();
	if($stmt->errno != 0){
		exit("error2");
	}
	$stmt->bind_result($id, $stgname, $uid, $cname, $mts);
	echo ("[");
	while($stmt->fetch()){
		echo("\"" . $id . "@" . $stgname . " of UID=" . $uid . " (" . $cname . ") " . $mts . "\",");
	}
	echo ("],");
	$stmt->close();
	//end
	echo("]");
	
	//一定時間更新されていないオブジェクトの削除マーキング処理
	$stmt = $db->prepare(QUERY_CHECK_AND_SET_DELETED_OBJECT);
	$limittime = getTimeStampMs() - OBJECT_ALIVE_TIME_MS;
	$stmt->bind_param(QUERY_CHECK_AND_SET_DELETED_OBJECT_TYPES, getTimeStampMs(), $limittime);
	$stmt->execute();
	//エラーチェック省略
	$stmt->close();
	
	//一定時間更新されていないユーザーの削除処理
	$stmt = $db->prepare(QUERY_DELETE_OFFLINE_USER);
	$limittime = getTimeStampMs() - USER_DELETE_TIME_MS;
	$stmt->bind_param(QUERY_DELETE_OFFLINE_USER_TYPES, $limittime);
	$stmt->execute();
	//エラーチェック省略
	$stmt->close();
	
	//一定時間更新されていないオブジェクトの削除処理
	$stmt = $db->prepare(QUERY_DELETE_OFFLINE_OBJECT);
	$limittime = getTimeStampMs() - OBJECT_DELETE_TIME_MS;
	$stmt->bind_param(QUERY_DELETE_OFFLINE_OBJECT_TYPES, $limittime);
	$stmt->execute();
	//エラーチェック省略
	$stmt->close();
}

//
// response
//
//[
//	[timestamp],
//	
//]
function responseError()
{
	exit("[0];");
}

?>