var UserStateWidgetClass = function(manager, args)
{
	UserStateWidgetClass.base.apply(this, arguments);
	this.manager = manager;
	this.wCanvas = null;
	this.gContext = null;
	
}.extend(WidgetClass, {
	attach: function(){
		this.wCanvas = createCanvas("UserStateWidgetCanvas", 240, 80, 395, 5, 8, this.manager.mainArea);
		this.gContext = this.wCanvas.getContext('2d');
		this.gContext.globalAlpha = 1;
		this.gContext.fillStyle = "rgba(255,240,200,0.25)";
		this.gContext.strokeStyle = "rgba(128, 128, 128, 0.5)";
		this.gContext.font = "normal 20px sans-serif";
	},
	detach: function(){
		this.wCanvas = null;
		this.gContext = null;
		destroyDOMObjectByID("UserStateWidgetCanvas");
	},
	tick : function(){
		return true;
	},
	
	draw : function(){
		if(this.manager.runningStage && this.manager.runningStage.userControlledCharacter){
			this.gContext.fillStyle = "rgba(255,255,255,0.25)";
			this.gContext.clearRect(this.gContext, 0, 0, this.wCanvas.width, this.wCanvas.height);
			strokeRect(this.gContext, 0, 0, this.wCanvas.width, this.wCanvas.height);
			fillRect(this.gContext, 0, 0, this.wCanvas.width, this.wCanvas.height);
			drawText(this.gContext, this.manager.userManager.getUserNameByUID(this.manager.userID), 4, 4);
			drawText(this.gContext, "HP :", 24, 24);
			this.gContext.fillStyle = "rgba(255,200,200,1)";
			fillRect(this.gContext, 70, 32, (this.wCanvas.width - 100) * (this.manager.runningStage.userControlledCharacter.HP / this.manager.runningStage.userControlledCharacter.max_HP), 10);
			strokeRect(this.gContext, 70, 32, this.wCanvas.width - 100, 10);
		}
	},
});