VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "TestIo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Sub Class_Initialize()
    setup "testOutputDimension": testOutputDimension
    setup "testByteOrder": testByteOrder
    setup "testPoint": testPoint
    setup "testLineString": testLineString
    setup "testPolygon": testPolygon
    setup "testMultiPoint": testMultiPoint
    setup "testMultiLineString": testMultiLineString
    setup "testMultiPolygon": testMultiPolygon
    'setup "testCollection": testCollection ' TODO:
    'setup "testWktInvalid": testWktInvalid
    'setup "testWkbInvalid": testWkbInvalid
    'setup "testHexInvalid": testHexInvalid
    report
End Sub

Function check(wkt, ndrHexIn, xdrHexIn)
    Dim wktReader
    Set wktReader = geos.wktReader.new_WktReader()
    Dim geom1
    Set geom1 = wktReader.read(wkt)
    
    Dim wkbReader
    Set wkbReader = geos.wkbReader.new_WkbReader()
    Dim geom2
    Set geom2 = wkbReader.readHEX(ndrHexIn)
    Dim geom3
    Set geom3 = wkbReader.readHEX(xdrHexIn)
    
    assertEqual True, geom1.equals(geom2), "geom1.equals(geom2)"
    assertEqual True, geom1.equals(geom3), "geom1.equals(geom3)"
    assertEqual True, geom2.equals(geom3), "geom2.equals(geom3)"
    
    Dim wkbWriter
    Set wkbWriter = geos.wkbWriter.new_WkbWriter()
    wkbWriter.setByteOrder geos.GEOS_WKB_NDR
    Dim ndrHexOut
    ndrHexOut = wkbWriter.writeHEX(geom1)
    assertEqual ndrHexIn, ndrHexOut, "ndrHexIn, ndrHexOut"
    
    Dim ndrBinOut
    ndrBinOut = wkbWriter.write(geom1)
    Dim ndrIdx, ndrBinOutStr
    ndrBinOutStr = ""
    For ndrIdx = LBound(ndrBinOut) To UBound(ndrBinOut)
        ndrBinOutStr = ndrBinOutStr & hex(ndrBinOut(ndrIdx) \ 16) & hex(ndrBinOut(ndrIdx) Mod 16)
    Next
    assertEqual ndrHexIn, ndrBinOutStr, "ndrHexIn, ndrBinOutStr"
    
    wkbWriter.setByteOrder geos.GEOS_WKB_XDR
    Dim xdrHexOut
    xdrHexOut = wkbWriter.writeHEX(geom1)
    assertEqual xdrHexIn, xdrHexOut, "xdrHexIn, xdrHexOut"
    
    Dim xdrBinOut
    xdrBinOut = wkbWriter.write(geom1)
    Dim xdrIdx, xdrBinOutStr
    xdrBinOutStr = ""
    For xdrIdx = LBound(xdrBinOut) To UBound(xdrBinOut)
        xdrBinOutStr = xdrBinOutStr & hex(xdrBinOut(xdrIdx) \ 16) & hex(xdrBinOut(xdrIdx) Mod 16)
    Next
    assertEqual xdrHexIn, xdrBinOutStr, "xdrHexIn, xdrBinOutStr"
    
    Set check = geom1
End Function

Sub testOutputDimension()
    Dim writer
    Set writer = geos.wkbWriter.new_WkbWriter()
    assertEqual 2, writer.getOutputDimension, "writer.getOutputDimension"
    
    writer.setOutputDimension 3
    assertEqual 3, writer.getOutputDimension, "writer.getOutputDimension"
End Sub

Sub testByteOrder()
    Dim writer
    Set writer = geos.wkbWriter.new_WkbWriter()
    assertEqual geos.GEOS_WKB_NDR, writer.getByteOrder, "writer.getByteOrder"
    
    writer.setByteOrder geos.GEOS_WKB_XDR
    assertEqual geos.GEOS_WKB_XDR, writer.getByteOrder, "writer.getByteOrder"
    
    writer.setByteOrder geos.GEOS_WKB_NDR
    assertEqual geos.GEOS_WKB_NDR, writer.getByteOrder, "writer.getByteOrder"
End Sub

Sub testPoint()
    Dim wkt, ndr, xdr
    wkt = "POINT(0 0)"
    ndr = "010100000000000000000000000000000000000000"
    xdr = "000000000100000000000000000000000000000000"
    
    Dim geom
    Set geom = check(wkt, ndr, xdr)
    assertEqual "IPoint", TypeName(geom), "TypeName(geom)"
    assertEqual "Point", geom.geomType, "geom.geomType"
    assertEqual geos.GEOS_POINT, geom.typeId, "geom.typeId"
End Sub

Sub testLineString()
    Dim wkt, ndr, xdr
    wkt = "LINESTRING(1 2, 3 4)"
    ndr = "010200000002000000000000000000F03F000000000000004000000000000008400000000000001040"
    xdr = "0000000002000000023FF0000000000000400000000000000040080000000000004010000000000000"
    
    Dim geom
    Set geom = check(wkt, ndr, xdr)
    assertEqual "ILineString", TypeName(geom), "TypeName(geom)"
    assertEqual "LineString", geom.geomType, "geom.geomType"
    assertEqual geos.GEOS_LINESTRING, geom.typeId, "geom.typeId"
End Sub

Sub testPolygon()
    Dim wkt, ndr, xdr
    wkt = "POLYGON((0 0, 10 0, 10 10, 0 10, 0 0),(2 2, 2 6, 6 4, 2 2))"
    ndr = "0103000000020000000500000000000000000000000000000000000000000000000000244000000000000000000000000000002440000000000000244000000000000000000000000000002440000000000000000000000000000000000400000000000000000000400000000000000040000000000000004000000000000018400000000000001840000000000000104000000000000000400000000000000040"
    xdr = "0000000003000000020000000500000000000000000000000000000000402400000000000000000000000000004024000000000000402400000000000000000000000000004024000000000000000000000000000000000000000000000000000440000000000000004000000000000000400000000000000040180000000000004018000000000000401000000000000040000000000000004000000000000000"
    
    Dim geom
    Set geom = check(wkt, ndr, xdr)
    assertEqual "IPolygon", TypeName(geom), "TypeName(geom)"
    assertEqual "Polygon", geom.geomType, "geom.geomType"
    assertEqual geos.GEOS_POLYGON, geom.typeId, "geom.typeId"
End Sub

Sub testMultiPoint()
    Dim wkt, ndr, xdr
    wkt = "MULTIPOINT(0 0, 10 0, 10 10, 0 10, 0 0)"
    ndr = "010400000005000000010100000000000000000000000000000000000000010100000000000000000024400000000000000000010100000000000000000024400000000000002440010100000000000000000000000000000000002440010100000000000000000000000000000000000000"
    xdr = "000000000400000005000000000100000000000000000000000000000000000000000140240000000000000000000000000000000000000140240000000000004024000000000000000000000100000000000000004024000000000000000000000100000000000000000000000000000000"
    
    Dim geom
    Set geom = check(wkt, ndr, xdr)
    assertEqual "IMultiPoint", TypeName(geom), "TypeName(geom)"
    assertEqual "MultiPoint", geom.geomType, "geom.geomType"
    assertEqual geos.GEOS_MULTIPOINT, geom.typeId, "geom.typeId"
End Sub

Sub testMultiLineString()
    Dim wkt, ndr, xdr
    wkt = "MULTILINESTRING((0 0, 10 0, 10 10, 0 10, 10 20),(2 2, 2 6, 6 4, 20 2))"
    ndr = "010500000002000000010200000005000000000000000000000000000000000000000000000000002440000000000000000000000000000024400000000000002440000000000000000000000000000024400000000000002440000000000000344001020000000400000000000000000000400000000000000040000000000000004000000000000018400000000000001840000000000000104000000000000034400000000000000040"
    xdr = "000000000500000002000000000200000005000000000000000000000000000000004024000000000000000000000000000040240000000000004024000000000000000000000000000040240000000000004024000000000000403400000000000000000000020000000440000000000000004000000000000000400000000000000040180000000000004018000000000000401000000000000040340000000000004000000000000000"
    
    Dim geom
    Set geom = check(wkt, ndr, xdr)
    assertEqual "IMultiLineString", TypeName(geom), "TypeName(geom)"
    assertEqual "MultiLineString", geom.geomType, "geom.geomType"
    assertEqual geos.GEOS_MULTILINESTRING, geom.typeId, "geom.typeId"
End Sub

Sub testMultiPolygon()
    Dim wkt, ndr, xdr
    wkt = "MULTIPOLYGON(((0 0, 10 0, 10 10, 0 10, 0 0),(2 2, 2 6, 6 4, 2 2)),((60 60, 60 50, 70 40, 60 60)))"
    ndr = "0106000000020000000103000000020000000500000000000000000000000000000000000000000000000000244000000000000000000000000000002440000000000000244000000000000000000000000000002440000000000000000000000000000000000400000000000000000000400000000000000040000000000000004000000000000018400000000000001840000000000000104000000000000000400000000000000040010300000001000000040000000000000000004E400000000000004E400000000000004E400000000000004940000000000080514000000000000044400000000000004E400000000000004E40"
    xdr = "000000000600000002000000000300000002000000050000000000000000000000000000000040240000000000000000000000000000402400000000000040240000000000000000000000000000402400000000000000000000000000000000000000000000000000044000000000000000400000000000000040000000000000004018000000000000401800000000000040100000000000004000000000000000400000000000000000000000030000000100000004404E000000000000404E000000000000404E000000000000404900000000000040518000000000004044000000000000404E000000000000404E000000000000"
    
    Dim geom
    Set geom = check(wkt, ndr, xdr)
    assertEqual "IMultiPolygon", TypeName(geom), "TypeName(geom)"
    assertEqual "MultiPolygon", geom.geomType, "geom.geomType"
    assertEqual geos.GEOS_MULTIPOLYGON, geom.typeId, "geom.typeId"
End Sub

Sub testCollection()
    Dim wkt, ndr, xdr
    wkt = "GEOMETRYCOLLECTION(POINT(0 0),LINESTRING(1 2,3 4),POLYGON((0 0,10 0,10 10,0 10,0 0),(2 2,2 6,6 4,2 2)),MULTIPOINT(0 0,10 0,10 10,0 10,0 0),MULTILINESTRING((0 0,10 0,10 10,0 10,10 20),(2 2,2 6,6 4,20 2)),MULTIPOLYGON(((0 0,10 0,10 10,0 10,0 0),(2 2,2 6,6 4,2 2)),((60 60,60 50,70 40,60 60))))"
    ndr = "010700000006000000010100000000000000000000000000000000000000010200000002000000000000000000F03F00000000000000400000000000000840000000000000104001030000000200000005000000000000000000000000000000000000000000000000002440000000000000000000000000000024400000000000002440000000000000000000000000000024400000000000000000000000000000000004000000000000000000004000000000000000400000000000000040000000000000184000000000000018400000000000001040000000000000004000000000000000400104000000050000000101000000000000000000000000000000000000000101000000000000000000244000000000000000000101000000000000000000244000000000000024400101000000000000000000000000000000000024400101000000000000000000000000000000000000000105000000020000000102000000050000000000000000000000000000000000000000000000000024400000000000000000000000000000244000000000000024400000000000000000000000000000244000000000000024400000000000003440010200000004000000000000000000004000000000000000400000000000000040000000000000184000000000000018400000000000001040000" _
    + "000000000344000000000000000400106000000020000000103000000020000000500000000000000000000000000000000000000000000000000244000000000000000000000000000002440000000000000244000000000000000000000000000002440000000000000000000000000000000000400000000000000000000400000000000000040000000000000004000000000000018400000000000001840000000000000104000000000000000400000000000000040010300000001000000040000000000000000004E400000000000004E400000000000004E400000000000004940000000000080514000000000000044400000000000004E400000000000004E40"
    xdr = "0000000007000000060000000001000000000000000000000000000000000000000002000000023FF000000000000040000000000000004008000000000000401000000000000000000000030000000200000005000000000000000000000000000000004024000000000000000000000000000040240000000000004024000000000000000000000000000040240000000000000000000000000000000000000000000000000004400000000000000040000000000000004000000000000000401800000000000040180000000000004010000000000000400000000000000040000000000000000000000004000000050000000001000000000000000000000000000000000000000001402400000000000000000000000000000000000001402400000000000040240000000000000000000001000000000000000040240000000000000000000001000000000000000000000000000000000000000005000000020000000002000000050000000000000000000000000000000040240000000000000000000000000000402400000000000040240000000000000000000000000000402400000000000040240000000000004034000000000000000000000200000004400000000000000040000000000000004000000000000000401800000000000040180000000000004010000000000000403" _
    + "40000000000004000000000000000000000000600000002000000000300000002000000050000000000000000000000000000000040240000000000000000000000000000402400000000000040240000000000000000000000000000402400000000000000000000000000000000000000000000000000044000000000000000400000000000000040000000000000004018000000000000401800000000000040100000000000004000000000000000400000000000000000000000030000000100000004404E000000000000404E000000000000404E000000000000404900000000000040518000000000004044000000000000404E000000000000404E000000000000"
    
    Dim geom
    Set geom = check(wkt, ndr, xdr)
    assertEqual "IGeometryCollection", TypeName(geom), "TypeName(geom)"
    assertEqual "GeometryCollection", geom.geomType, "geom.geomType"
    assertEqual geos.GEOS_GEOMETRYCOLLECTION, geom.typeId, "geom.typeId"
End Sub

Sub testWktInvalid()
    Dim reader
    Set reader = geos.wktReader.new_WktReader()
    Dim geom
    Set geom = reader.read("invalid")
End Sub

Sub testWkbInvalid()
    Dim reader
    Set reader = geos.wkbReader.new_WkbReader()
    Dim geom
    Set geom = reader.read("invalid")
End Sub

Sub testHexInvalid()
    Dim reader
    Set reader = geos.wkbReader.new_WkbReader()
    Dim geom
    Set geom = reader.readHEX("invalid")
End Sub

