#!/usr/bin/ruby -Ku
# coding: utf-8
# $Id: yaml_reader.rb,v 1.3 2009/08/20 12:41:31 nishimoto Exp $
# (c) Takuya NISHIMOTO 

require 'yaml'
require 'erb'

class YAMLReader
  def initialize(file_array)
    @config_array = []
    file_array.each do |file|
      str = translate(File.open(file).read)
      @config_array << YAML.load(str)
    end
  end
  
  def find_by_key(obj, key)
    begin
      key.split(/\./).each do |k|
        return nil unless obj.key?(k)
        obj = obj[k]
      end
    rescue
      return nil
    end    
    obj
  end
  
  def param(key)
    @config_array.each do |config|
      obj = find_by_key(config, key)
      return obj unless obj.nil?
    end
    return nil
  end
  
  def p(key)
    param(key)
  end

  private
  def translate(src)
    ERB.new(src, nil, '-').result(binding)
  end
end
