#!/usr/bin/ruby -Ku
# coding: utf-8
# $Id: generator.rb,v 1.5 2009/08/20 12:41:31 nishimoto Exp $
# (c) Takuya NISHIMOTO 

require 'erb'

class Generator
  attr_accessor :dry_run
  def translate(src)
    ERB.new(src, nil, '-').result(binding)
  end

  # skel_dir/sub_dir/file.txt -> target_dir/sub_dir/file
  def generate(skel_dir, file, target_dir, sub_dir, mode = nil)
    unless @dry_run
      begin
        str = File.open("#{skel_dir}/#{sub_dir}/#{file}.txt").read
        File.open("#{target_dir}/#{sub_dir}/#{file}", "w") do |f|
          f.write translate(str)
        end
      rescue => error
        puts error.message
        exit
      end
      if mode
        FileUtils.chmod(mode, File.join(target_dir, sub_dir, file))
      end
    end
    puts "#{target_dir}/#{sub_dir}/#{file} generated."
  end
end
