/**
 * $Id: ISubModule.java,v 1.2 2009/01/18 06:17:17 nishimoto Exp $
 */
package galatea.submodule;

import galatea.dialog.ISystemEventLogger;
import galatea.dialog.RuntimeError;
import galatea.io.ISenderToDevice;
import galatea.outitem.OutItem;

public interface ISubModule {

	public ISubModule setSender(ISenderToDevice sender);

	public ISubModule setReceiver(IReceiverFromSubModule receiver);

	public ISubModule setLogger(ISystemEventLogger logger);
	
	/**
	 * (for Chain of Responsibility pattern)
	 * @return if true : processed by this module.
	 * if false : delegated to others.
	 */
	public boolean receiveFromDevice(String str);

	/**
	 * (for Chain of Responsibility pattern)
	 * @return if true : processed by this module.
	 * if false : delegated to others.
	 */
	public boolean filterOutputNative(String str);

	public void doTimerTask() throws RuntimeError;

	public String getName();

	/**
	 * set submodule name (used for logging)
	 * @param name
	 */
	public void setName(String name);

	/**
	 * (for Chain of Responsibility pattern)
	 * @return if true : processed by this module.
	 * if false : delegated to others.
	 */
	public boolean startOutput(OutItem item); 
	
	/**
	 * (for Chain of Responsibility pattern)
	 * @return if true : processed by this module.
	 * if false : delegated to others.
	 */
	public boolean stopOutput(OutItem item);

	public void setTargetRunLevel(int i);

}