/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlChoice</b> is generated from vxml20.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="choice">
 *       <optional>
 *         <attribute name="fetchhint">
 *           <choice>
 *             <value type="NMTOKEN">prefetch</value>
 *             <value type="NMTOKEN">safe</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="fetchtimeout">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="maxage">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="maxstale">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="accept">
 *           <choice>
 *             <value type="NMTOKEN">exact</value>
 *             <value type="NMTOKEN">approximate</value>
 *           </choice>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="dtmf">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="event">
 *           <data type="NMTOKEN"/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="fetchaudio">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="next">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="expr">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <optional>
 *         <attribute name="image">
 *           <text/>
 *         </attribute>
 *       </optional>
 *       <mixed>
 *         <zeroOrMore>
 *           <choice>
 *             <zeroOrMore>
 *               <ref name="grammar"/>
 *             </zeroOrMore>
 *             <ref name="audio"/>
 *             <ref name="prosody"/>
 *             <ref name="voice"/>
 *             <ref name="emotion"/>
 *             <ref name="REGWORD"/>
 *             <ref name="CONTEXT"/>
 *             <ref name="VOICE"/>
 *             <ref name="break"/>
 *             <ref name="phoneme"/>
 *             <ref name="say-as"/>
 *             <ref name="paragraph"/>
 *             <ref name="sentence"/>
 *             <ref name="s"/>
 *             <ref name="LANG"/>
 *             <ref name="PITCH"/>
 *             <ref name="PRON"/>
 *             <ref name="RATE"/>
 *             <ref name="VOLUME"/>
 *             <ref name="enumerate"/>
 *             <ref name="value"/>
 *             <ref name="emphasis"/>
 *             <ref name="mark"/>
 *             <ref name="p"/>
 *             <ref name="BOOKMARK"/>
 *             <ref name="PARTOFSP"/>
 *             <ref name="SILENCE"/>
 *             <ref name="SPEECH"/>
 *             <ref name="EMPH"/>
 *             <ref name="RESET"/>
 *             <ref name="SPELL"/>
 *           </choice>
 *         </zeroOrMore>
 *       </mixed>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="choice"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="fetchhint"&gt;
 *           &lt;choice&gt;
 *             &lt;value type="NMTOKEN"&gt;prefetch&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;safe&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="fetchtimeout"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="maxage"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="maxstale"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="accept"&gt;
 *           &lt;choice&gt;
 *             &lt;value type="NMTOKEN"&gt;exact&lt;/value&gt;
 *             &lt;value type="NMTOKEN"&gt;approximate&lt;/value&gt;
 *           &lt;/choice&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="dtmf"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="event"&gt;
 *           &lt;data type="NMTOKEN"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="fetchaudio"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="next"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="expr"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="image"&gt;
 *           &lt;text/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;mixed&gt;
 *         &lt;zeroOrMore&gt;
 *           &lt;choice&gt;
 *             &lt;zeroOrMore&gt;
 *               &lt;ref name="grammar"/&gt;
 *             &lt;/zeroOrMore&gt;
 *             &lt;ref name="audio"/&gt;
 *             &lt;ref name="prosody"/&gt;
 *             &lt;ref name="voice"/&gt;
 *             &lt;ref name="emotion"/&gt;
 *             &lt;ref name="REGWORD"/&gt;
 *             &lt;ref name="CONTEXT"/&gt;
 *             &lt;ref name="VOICE"/&gt;
 *             &lt;ref name="break"/&gt;
 *             &lt;ref name="phoneme"/&gt;
 *             &lt;ref name="say-as"/&gt;
 *             &lt;ref name="paragraph"/&gt;
 *             &lt;ref name="sentence"/&gt;
 *             &lt;ref name="s"/&gt;
 *             &lt;ref name="LANG"/&gt;
 *             &lt;ref name="PITCH"/&gt;
 *             &lt;ref name="PRON"/&gt;
 *             &lt;ref name="RATE"/&gt;
 *             &lt;ref name="VOLUME"/&gt;
 *             &lt;ref name="enumerate"/&gt;
 *             &lt;ref name="value"/&gt;
 *             &lt;ref name="emphasis"/&gt;
 *             &lt;ref name="mark"/&gt;
 *             &lt;ref name="p"/&gt;
 *             &lt;ref name="BOOKMARK"/&gt;
 *             &lt;ref name="PARTOFSP"/&gt;
 *             &lt;ref name="SILENCE"/&gt;
 *             &lt;ref name="SPEECH"/&gt;
 *             &lt;ref name="EMPH"/&gt;
 *             &lt;ref name="RESET"/&gt;
 *             &lt;ref name="SPELL"/&gt;
 *           &lt;/choice&gt;
 *         &lt;/zeroOrMore&gt;
 *       &lt;/mixed&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version vxml20.rng (Thu Oct 02 00:02:04 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class VxmlChoice implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlMenuMixed, IVxmlMenuMixedChoice {
    public static final String FETCHHINT_PREFETCH = "prefetch";
    public static final String FETCHHINT_SAFE = "safe";
    public static final String ACCEPT_EXACT = "exact";
    public static final String ACCEPT_APPROXIMATE = "approximate";

    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String fetchhint_;
    private String fetchtimeout_;
    private String maxage_;
    private String maxstale_;
    private String accept_;
    private String dtmf_;
    private String event_;
    private String fetchaudio_;
    private String next_;
    private String expr_;
    private String image_;
    // List<IVxmlChoiceMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private Element xmlElement;
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlChoice</code>.
     *
     */
    public VxmlChoice() {
    }

    /**
     * Creates a <code>VxmlChoice</code>.
     *
     * @param source
     */
    public VxmlChoice(VxmlChoice source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlChoice(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlChoice(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlChoice</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlChoice(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the VxmlChoice <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlChoice source) {
        int size;
        fetchhint_ = source.fetchhint_;
        fetchtimeout_ = source.fetchtimeout_;
        maxage_ = source.maxage_;
        maxstale_ = source.maxstale_;
        accept_ = source.accept_;
        dtmf_ = source.dtmf_;
        event_ = source.event_;
        fetchaudio_ = source.fetchaudio_;
        next_ = source.next_;
        expr_ = source.expr_;
        image_ = source.image_;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlChoiceMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        fetchhint_ = URelaxer.getAttributePropertyAsString(element, "fetchhint");
        fetchtimeout_ = URelaxer.getAttributePropertyAsString(element, "fetchtimeout");
        maxage_ = URelaxer.getAttributePropertyAsString(element, "maxage");
        maxstale_ = URelaxer.getAttributePropertyAsString(element, "maxstale");
        accept_ = URelaxer.getAttributePropertyAsString(element, "accept");
        dtmf_ = URelaxer.getAttributePropertyAsString(element, "dtmf");
        event_ = URelaxer.getAttributePropertyAsString(element, "event");
        fetchaudio_ = URelaxer.getAttributePropertyAsString(element, "fetchaudio");
        next_ = URelaxer.getAttributePropertyAsString(element, "next");
        expr_ = URelaxer.getAttributePropertyAsString(element, "expr");
        image_ = URelaxer.getAttributePropertyAsString(element, "image");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (VxmlGrammar.isMatch(stack)) {
                addContent(new VxmlGrammar(stack));
            } else if (VxmlProsody.isMatch(stack)) {
                addContent(new VxmlProsody(stack));
            } else if (VxmlAudio.isMatch(stack)) {
                addContent(new VxmlAudio(stack));
            } else if (VxmlVoice.isMatch(stack)) {
                addContent(new VxmlVoice(stack));
            } else if (VxmlEmotion.isMatch(stack)) {
                addContent(new VxmlEmotion(stack));
            } else if (VxmlREGWORD.isMatch(stack)) {
                addContent(new VxmlREGWORD(stack));
            } else if (VxmlCONTEXT.isMatch(stack)) {
                addContent(new VxmlCONTEXT(stack));
            } else if (VxmlJVOICE.isMatch(stack)) {
                addContent(new VxmlJVOICE(stack));
            } else if (VxmlBreak.isMatch(stack)) {
                addContent(new VxmlBreak(stack));
            } else if (VxmlPhoneme.isMatch(stack)) {
                addContent(new VxmlPhoneme(stack));
            } else if (VxmlSayAs.isMatch(stack)) {
                addContent(new VxmlSayAs(stack));
            } else if (VxmlLANG.isMatch(stack)) {
                addContent(new VxmlLANG(stack));
            } else if (VxmlPITCH.isMatch(stack)) {
                addContent(new VxmlPITCH(stack));
            } else if (VxmlPRON.isMatch(stack)) {
                addContent(new VxmlPRON(stack));
            } else if (VxmlEmphasis.isMatch(stack)) {
                addContent(new VxmlEmphasis(stack));
            } else if (VxmlParagraph.isMatch(stack)) {
                addContent(new VxmlParagraph(stack));
            } else if (VxmlSentence.isMatch(stack)) {
                addContent(new VxmlSentence(stack));
            } else if (VxmlS.isMatch(stack)) {
                addContent(new VxmlS(stack));
            } else if (VxmlRATE.isMatch(stack)) {
                addContent(new VxmlRATE(stack));
            } else if (VxmlVOLUME.isMatch(stack)) {
                addContent(new VxmlVOLUME(stack));
            } else if (VxmlValue.isMatch(stack)) {
                addContent(new VxmlValue(stack));
            } else if (VxmlMark.isMatch(stack)) {
                addContent(new VxmlMark(stack));
            } else if (VxmlP.isMatch(stack)) {
                addContent(new VxmlP(stack));
            } else if (VxmlBOOKMARK.isMatch(stack)) {
                addContent(new VxmlBOOKMARK(stack));
            } else if (VxmlPARTOFSP.isMatch(stack)) {
                addContent(new VxmlPARTOFSP(stack));
            } else if (VxmlSILENCE.isMatch(stack)) {
                addContent(new VxmlSILENCE(stack));
            } else if (VxmlEnumerate.isMatch(stack)) {
                addContent(new VxmlEnumerate(stack));
            } else if (VxmlSPEECH.isMatch(stack)) {
                addContent(new VxmlSPEECH(stack));
            } else if (VxmlEMPH.isMatch(stack)) {
                addContent(new VxmlEMPH(stack));
            } else if (VxmlRESET.isMatch(stack)) {
                addContent(new VxmlRESET(stack));
            } else if (VxmlSPELL.isMatch(stack)) {
                addContent(new VxmlSPELL(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlChoice((VxmlChoice)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "choice");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.fetchhint_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchhint", this.fetchhint_);
        }
        if (this.fetchtimeout_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchtimeout", this.fetchtimeout_);
        }
        if (this.maxage_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxage", this.maxage_);
        }
        if (this.maxstale_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxstale", this.maxstale_);
        }
        if (this.accept_ != null) {
            URelaxer.setAttributePropertyByString(element, "accept", this.accept_);
        }
        if (this.dtmf_ != null) {
            URelaxer.setAttributePropertyByString(element, "dtmf", this.dtmf_);
        }
        if (this.event_ != null) {
            URelaxer.setAttributePropertyByString(element, "event", this.event_);
        }
        if (this.fetchaudio_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchaudio", this.fetchaudio_);
        }
        if (this.next_ != null) {
            URelaxer.setAttributePropertyByString(element, "next", this.next_);
        }
        if (this.expr_ != null) {
            URelaxer.setAttributePropertyByString(element, "expr", this.expr_);
        }
        if (this.image_ != null) {
            URelaxer.setAttributePropertyByString(element, "image", this.image_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContent(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContent(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void setContentByString(String value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>String</code>.
     *
     * @param value
     */
    public void addContentByString(String value) {
        addContent(new RString(value));
    }

    /**
     * Sets a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void setContent(org.w3c.dom.Node value) {
        setContent(new RString(value));
    }

    /**
     * Adds a mixed content by <code>org.w3c.dom.Node</code>.
     *
     * @param value
     */
    public void addContent(org.w3c.dom.Node value) {
        addContent(new RString(value));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>fetchhint</b>.
     *
     * @return String
     */
    public String getFetchhint() {
        return (fetchhint_);
    }

    /**
     * Sets the String property <b>fetchhint</b>.
     *
     * @param fetchhint
     */
    public void setFetchhint(String fetchhint) {
        this.fetchhint_ = fetchhint;
    }

    /**
     * Gets the String property <b>fetchtimeout</b>.
     *
     * @return String
     */
    public String getFetchtimeout() {
        return (fetchtimeout_);
    }

    /**
     * Sets the String property <b>fetchtimeout</b>.
     *
     * @param fetchtimeout
     */
    public void setFetchtimeout(String fetchtimeout) {
        this.fetchtimeout_ = fetchtimeout;
    }

    /**
     * Gets the String property <b>maxage</b>.
     *
     * @return String
     */
    public String getMaxage() {
        return (maxage_);
    }

    /**
     * Sets the String property <b>maxage</b>.
     *
     * @param maxage
     */
    public void setMaxage(String maxage) {
        this.maxage_ = maxage;
    }

    /**
     * Gets the String property <b>maxstale</b>.
     *
     * @return String
     */
    public String getMaxstale() {
        return (maxstale_);
    }

    /**
     * Sets the String property <b>maxstale</b>.
     *
     * @param maxstale
     */
    public void setMaxstale(String maxstale) {
        this.maxstale_ = maxstale;
    }

    /**
     * Gets the String property <b>accept</b>.
     *
     * @return String
     */
    public String getAccept() {
        return (accept_);
    }

    /**
     * Sets the String property <b>accept</b>.
     *
     * @param accept
     */
    public void setAccept(String accept) {
        this.accept_ = accept;
    }

    /**
     * Gets the String property <b>dtmf</b>.
     *
     * @return String
     */
    public String getDtmf() {
        return (dtmf_);
    }

    /**
     * Sets the String property <b>dtmf</b>.
     *
     * @param dtmf
     */
    public void setDtmf(String dtmf) {
        this.dtmf_ = dtmf;
    }

    /**
     * Gets the String property <b>event</b>.
     *
     * @return String
     */
    public String getEvent() {
        return (event_);
    }

    /**
     * Sets the String property <b>event</b>.
     *
     * @param event
     */
    public void setEvent(String event) {
        this.event_ = event;
    }

    /**
     * Gets the String property <b>fetchaudio</b>.
     *
     * @return String
     */
    public String getFetchaudio() {
        return (fetchaudio_);
    }

    /**
     * Sets the String property <b>fetchaudio</b>.
     *
     * @param fetchaudio
     */
    public void setFetchaudio(String fetchaudio) {
        this.fetchaudio_ = fetchaudio;
    }

    /**
     * Gets the String property <b>next</b>.
     *
     * @return String
     */
    public String getNext() {
        return (next_);
    }

    /**
     * Sets the String property <b>next</b>.
     *
     * @param next
     */
    public void setNext(String next) {
        this.next_ = next;
    }

    /**
     * Gets the String property <b>expr</b>.
     *
     * @return String
     */
    public String getExpr() {
        return (expr_);
    }

    /**
     * Sets the String property <b>expr</b>.
     *
     * @param expr
     */
    public void setExpr(String expr) {
        this.expr_ = expr;
    }

    /**
     * Gets the String property <b>image</b>.
     *
     * @return String
     */
    public String getImage() {
        return (image_);
    }

    /**
     * Sets the String property <b>image</b>.
     *
     * @param image
     */
    public void setImage(String image) {
        this.image_ = image;
    }

    /**
     * Gets the IVxmlChoiceMixed property <b>content</b>.
     *
     * @return IVxmlChoiceMixed[]
     */
    public IVxmlChoiceMixed[] getContent() {
        IVxmlChoiceMixed[] array = new IVxmlChoiceMixed[content_.size()];
        return ((IVxmlChoiceMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlChoiceMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlChoiceMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlChoiceMixed property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IVxmlChoiceMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlChoiceMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlChoiceMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlChoiceMixed property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IVxmlChoiceMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlChoiceMixed property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlChoiceMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlChoiceMixed
     */
    public IVxmlChoiceMixed getContent(int index) {
        return ((IVxmlChoiceMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlChoiceMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IVxmlChoiceMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlChoiceMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IVxmlChoiceMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlChoiceMixed property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlChoiceMixed property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IVxmlChoiceMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlChoiceMixed property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "choice", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (fetchhint_ != null) {
            buffer.append(" ");
            buffer.append("fetchhint");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.append("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.append(" ");
            buffer.append("fetchtimeout");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.append("\"");
        }
        if (maxage_ != null) {
            buffer.append(" ");
            buffer.append("maxage");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.append("\"");
        }
        if (maxstale_ != null) {
            buffer.append(" ");
            buffer.append("maxstale");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.append("\"");
        }
        if (accept_ != null) {
            buffer.append(" ");
            buffer.append("accept");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getAccept())));
            buffer.append("\"");
        }
        if (dtmf_ != null) {
            buffer.append(" ");
            buffer.append("dtmf");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDtmf())));
            buffer.append("\"");
        }
        if (event_ != null) {
            buffer.append(" ");
            buffer.append("event");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.append("\"");
        }
        if (fetchaudio_ != null) {
            buffer.append(" ");
            buffer.append("fetchaudio");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchaudio())));
            buffer.append("\"");
        }
        if (next_ != null) {
            buffer.append(" ");
            buffer.append("next");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getNext())));
            buffer.append("\"");
        }
        if (expr_ != null) {
            buffer.append(" ");
            buffer.append("expr");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.append("\"");
        }
        if (image_ != null) {
            buffer.append(" ");
            buffer.append("image");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getImage())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "choice", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "choice", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (fetchhint_ != null) {
            buffer.write(" ");
            buffer.write("fetchhint");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.write("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.write(" ");
            buffer.write("fetchtimeout");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.write("\"");
        }
        if (maxage_ != null) {
            buffer.write(" ");
            buffer.write("maxage");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.write("\"");
        }
        if (maxstale_ != null) {
            buffer.write(" ");
            buffer.write("maxstale");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.write("\"");
        }
        if (accept_ != null) {
            buffer.write(" ");
            buffer.write("accept");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getAccept())));
            buffer.write("\"");
        }
        if (dtmf_ != null) {
            buffer.write(" ");
            buffer.write("dtmf");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getDtmf())));
            buffer.write("\"");
        }
        if (event_ != null) {
            buffer.write(" ");
            buffer.write("event");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.write("\"");
        }
        if (fetchaudio_ != null) {
            buffer.write(" ");
            buffer.write("fetchaudio");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchaudio())));
            buffer.write("\"");
        }
        if (next_ != null) {
            buffer.write(" ");
            buffer.write("next");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getNext())));
            buffer.write("\"");
        }
        if (expr_ != null) {
            buffer.write(" ");
            buffer.write("expr");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.write("\"");
        }
        if (image_ != null) {
            buffer.write(" ");
            buffer.write("image");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getImage())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "choice", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "choice", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (fetchhint_ != null) {
            buffer.print(" ");
            buffer.print("fetchhint");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.print("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.print(" ");
            buffer.print("fetchtimeout");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.print("\"");
        }
        if (maxage_ != null) {
            buffer.print(" ");
            buffer.print("maxage");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.print("\"");
        }
        if (maxstale_ != null) {
            buffer.print(" ");
            buffer.print("maxstale");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.print("\"");
        }
        if (accept_ != null) {
            buffer.print(" ");
            buffer.print("accept");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getAccept())));
            buffer.print("\"");
        }
        if (dtmf_ != null) {
            buffer.print(" ");
            buffer.print("dtmf");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDtmf())));
            buffer.print("\"");
        }
        if (event_ != null) {
            buffer.print(" ");
            buffer.print("event");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.print("\"");
        }
        if (fetchaudio_ != null) {
            buffer.print(" ");
            buffer.print("fetchaudio");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchaudio())));
            buffer.print("\"");
        }
        if (next_ != null) {
            buffer.print(" ");
            buffer.print("next");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getNext())));
            buffer.print("\"");
        }
        if (expr_ != null) {
            buffer.print(" ");
            buffer.print("expr");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.print("\"");
        }
        if (image_ != null) {
            buffer.print(" ");
            buffer.print("image");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getImage())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "choice", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchhintAsString() {
        return (URelaxer.getString(getFetchhint()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchtimeoutAsString() {
        return (URelaxer.getString(getFetchtimeout()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaxageAsString() {
        return (URelaxer.getString(getMaxage()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaxstaleAsString() {
        return (URelaxer.getString(getMaxstale()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getAcceptAsString() {
        return (URelaxer.getString(getAccept()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDtmfAsString() {
        return (URelaxer.getString(getDtmf()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getEventAsString() {
        return (URelaxer.getString(getEvent()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchaudioAsString() {
        return (URelaxer.getString(getFetchaudio()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNextAsString() {
        return (URelaxer.getString(getNext()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getExprAsString() {
        return (URelaxer.getString(getExpr()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getImageAsString() {
        return (URelaxer.getString(getImage()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchhintByString(String string) {
        setFetchhint(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchtimeoutByString(String string) {
        setFetchtimeout(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaxageByString(String string) {
        setMaxage(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaxstaleByString(String string) {
        setMaxstale(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setAcceptByString(String string) {
        setAccept(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDtmfByString(String string) {
        setDtmf(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setEventByString(String string) {
        setEvent(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchaudioByString(String string) {
        setFetchaudio(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNextByString(String string) {
        setNext(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setExprByString(String string) {
        setExpr(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setImageByString(String string) {
        setImage(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlChoice</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "choice")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (RString.isMatch(target)) {
            $match$ = true;
        }
        while (true) {
            if (VxmlGrammar.isMatchHungry(target)) {
                $match$ = true;
                while (VxmlGrammar.isMatchHungry(target)) {
                }
            } else if (VxmlProsody.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlAudio.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmotion.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlREGWORD.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCONTEXT.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlJVOICE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBreak.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPhoneme.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSayAs.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlLANG.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPITCH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPRON.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmphasis.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlParagraph.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSentence.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlS.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRATE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVOLUME.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlMark.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBOOKMARK.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPARTOFSP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSILENCE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEnumerate.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPEECH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEMPH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRESET.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPELL.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlChoice</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlChoice</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
