/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package galatea.relaxer.pdoc;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PdocAdd</b> is generated from pdoc.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="add">
 *       <optional>
 *         <attribute name="cond">
 *           <data type="token"/>
 *         </attribute>
 *       </optional>
 *       <oneOrMore>
 *         <choice>
 *           <ref name="log"/>
 *           <ref name="native"/>
 *   	  <ref name="grammarout"/>
 * 	  <ref name="audio"/>
 *           <ref name="voice"/>
 *           <ref name="break"/>
 *         </choice>
 *       </oneOrMore>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="add"&gt;
 *       &lt;optional&gt;
 *         &lt;attribute name="cond"&gt;
 *           &lt;data type="token"/&gt;
 *         &lt;/attribute&gt;
 *       &lt;/optional&gt;
 *       &lt;oneOrMore&gt;
 *         &lt;choice&gt;
 *           &lt;ref name="log"/&gt;
 *           &lt;ref name="native"/&gt;
 *   	  &lt;ref name="grammarout"/&gt;
 * 	  &lt;ref name="audio"/&gt;
 *           &lt;ref name="voice"/&gt;
 *           &lt;ref name="break"/&gt;
 *         &lt;/choice&gt;
 *       &lt;/oneOrMore&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version pdoc.rng (Thu Oct 02 00:02:08 JST 2008)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class PdocAdd implements java.io.Serializable, Cloneable, IPdocCmdContentsChoice {
    private String cond_;
    // List<IPdocAddChoice>
    private java.util.List content_ = new java.util.ArrayList();
    private Element xmlElement;

    /**
     * Creates a <code>PdocAdd</code>.
     *
     */
    public PdocAdd() {
    }

    /**
     * Creates a <code>PdocAdd</code>.
     *
     * @param source
     */
    public PdocAdd(PdocAdd source) {
        setup(source);
    }

    /**
     * Creates a <code>PdocAdd</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PdocAdd(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PdocAdd</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PdocAdd(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PdocAdd</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PdocAdd(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PdocAdd</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocAdd(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PdocAdd</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocAdd(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PdocAdd</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocAdd(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PdocAdd</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocAdd(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PdocAdd</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocAdd(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PdocAdd</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocAdd(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PdocAdd</code> by the PdocAdd <code>source</code>.
     *
     * @param source
     */
    public void setup(PdocAdd source) {
        int size;
        cond_ = source.cond_;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IPdocAddChoice)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>PdocAdd</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PdocAdd</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PdocAdd</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        RStack stack = new RStack(element);
        cond_ = URelaxer.getAttributePropertyAsString(element, "cond");
        content_.clear();
        while (true) {
            if (PdocGrammarout.isMatch(stack)) {
                addContent(new PdocGrammarout(stack));
            } else if (PdocVoice.isMatch(stack)) {
                addContent(new PdocVoice(stack));
            } else if (PdocBreak.isMatch(stack)) {
                addContent(new PdocBreak(stack));
            } else if (PdocLog.isMatch(stack)) {
                addContent(new PdocLog(stack));
            } else if (PdocNative.isMatch(stack)) {
                addContent(new PdocNative(stack));
            } else if (PdocAudio.isMatch(stack)) {
                addContent(new PdocAudio(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new PdocAdd((PdocAdd)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("add");
        int size;
        if (this.cond_ != null) {
            URelaxer.setAttributePropertyByString(element, "cond", this.cond_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocAddChoice value = (IPdocAddChoice)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PdocAdd</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PdocAdd</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocAdd</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocAdd</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocAdd</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocAdd</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>cond</b>.
     *
     * @return String
     */
    public String getCond() {
        return (cond_);
    }

    /**
     * Sets the String property <b>cond</b>.
     *
     * @param cond
     */
    public void setCond(String cond) {
        this.cond_ = cond;
    }

    /**
     * Gets the IPdocAddChoice property <b>content</b>.
     *
     * @return IPdocAddChoice[]
     */
    public IPdocAddChoice[] getContent() {
        IPdocAddChoice[] array = new IPdocAddChoice[content_.size()];
        return ((IPdocAddChoice[])content_.toArray(array));
    }

    /**
     * Sets the IPdocAddChoice property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IPdocAddChoice[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
    }

    /**
     * Sets the IPdocAddChoice property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IPdocAddChoice content) {
        this.content_.clear();
        addContent(content);
    }

    /**
     * Adds the IPdocAddChoice property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IPdocAddChoice content) {
        this.content_.add(content);
    }

    /**
     * Adds the IPdocAddChoice property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IPdocAddChoice[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
    }

    /**
     * Gets number of the IPdocAddChoice property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IPdocAddChoice property <b>content</b> by index.
     *
     * @param index
     * @return IPdocAddChoice
     */
    public IPdocAddChoice getContent(int index) {
        return ((IPdocAddChoice)content_.get(index));
    }

    /**
     * Sets the IPdocAddChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IPdocAddChoice content) {
        this.content_.set(index, content);
    }

    /**
     * Adds the IPdocAddChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IPdocAddChoice content) {
        this.content_.add(index, content);
    }

    /**
     * Remove the IPdocAddChoice property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IPdocAddChoice property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IPdocAddChoice content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IPdocAddChoice property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<add");
        if (cond_ != null) {
            buffer.append(" cond=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocAddChoice value = (IPdocAddChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocAddChoice value = (IPdocAddChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</add>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<add");
        if (cond_ != null) {
            buffer.write(" cond=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocAddChoice value = (IPdocAddChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocAddChoice value = (IPdocAddChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</add>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<add");
        if (cond_ != null) {
            buffer.print(" cond=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getCond())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocAddChoice value = (IPdocAddChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocAddChoice value = (IPdocAddChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</add>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getCondAsString() {
        return (URelaxer.getString(getCond()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setCondByString(String string) {
        setCond(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PdocAdd</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "add")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (PdocGrammarout.isMatchHungry(target)) {
            $match$ = true;
        } else if (PdocVoice.isMatchHungry(target)) {
            $match$ = true;
        } else if (PdocBreak.isMatchHungry(target)) {
            $match$ = true;
        } else if (PdocLog.isMatchHungry(target)) {
            $match$ = true;
        } else if (PdocNative.isMatchHungry(target)) {
            $match$ = true;
        } else if (PdocAudio.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return (false);
        }
        while (true) {
            if (PdocGrammarout.isMatchHungry(target)) {
                $match$ = true;
            } else if (PdocVoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (PdocBreak.isMatchHungry(target)) {
                $match$ = true;
            } else if (PdocLog.isMatchHungry(target)) {
                $match$ = true;
            } else if (PdocNative.isMatchHungry(target)) {
                $match$ = true;
            } else if (PdocAudio.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocAdd</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocAdd</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
