/*
 * Galatea Dialog Studio:
 * (c)2009 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 *
 * $Id: DialogManagerWindow.java,v 1.18 2009/03/07 23:59:38 nishimoto Exp $
 */

package galatea.dialog.window;

import galatea.dialog.ISystemEventLogger;
import galatea.document.DocLoader;
import galatea.httpclient.INetUtilListener;
import galatea.httpclient.NetUtil;
import galatea.logger.ILoggerListener;
import galatea.logger.Logger;
import galatea.util.Property;
import galatea.util.Util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class DialogManagerWindow
	implements ISystemEventLogger, INetUtilListener, ILoggerListener
{
	private final class MenuExitActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			// TODO shutdown hook is not working with Windows
			System.exit(0);
		}
	}

	private final class MenuQuitActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			if (eventListener_ != null) {
				eventListener_.quitAction();
			} else {
				System.out.println(e);
			}
		}
	}

	private final class MainPanelButtonStopActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			pauseModeLabel_.setText("Mode: Pause");
			if (eventListener_ != null) {
				eventListener_.setPauseModeAction(true);
			} else {
				System.out.println(e);
			}
		}
	}

	private final class MainPanelButtonStartActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			pauseModeLabel_.setText("Mode: Run");
			if (eventListener_ != null) {
				eventListener_.setPauseModeAction(false);
			} else {
				System.out.println(e);
			}
		}
	}

	private final class MainPanelValidateActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			String uri = locationTextField_.getText();
			if (uri != null && uri.length() > 0) {
				String doc = DocLoader.convert(uri);
				if (doc != "") {
					// System.err.println("[DM Validate OK] " + uri);
					dispApplog("[DM Validate OK] " + uri);
				} else {
					// System.err.println("[DM Validate ERROR] " + uri);
					dispApplog("[DM Validate ERROR] " + uri);
				}
			}
		}
	}

	private final class MainPanelGoActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			String uri = locationTextField_.getText();
			if (eventListener_ != null) {
				pauseModeLabel_.setText("Mode: Run");
				eventListener_.setPauseModeAction(false);
				eventListener_.setNextDocumentAction(uri);
				eventListener_.terminateDialogAction();
			} else {
				System.out.println(e);
				System.out.println(uri);
			}
		}
	}


	private final class MenuOpenActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			// currDirPath_ = "file:C:/workspace/galatea/../"
			String org = currLocalDirPath_.replaceFirst("file:", "");
			JFileChooser chooser = new JFileChooser(org); 
			chooser.showOpenDialog(null);
			File file = chooser.getSelectedFile();
			if ( file == null ) return;
			String uri = file.getAbsolutePath();
			uri = Util.replaceAll(uri, "\\", "/");
			uri = "file:" + uri;
			if (eventListener_ != null) {
				pauseModeLabel_.setText("Mode: Run");
				eventListener_.setPauseModeAction(false);
				eventListener_.setNextDocumentAction(uri);
				eventListener_.terminateDialogAction();
			} else {
				System.out.println(e);
				System.out.println(uri);
			}
			//
			currLocalDirPath_ = Util.getUriDirectory(uri);
		}
	}

	private JTextArea  applogTextArea_ = null;
	private StringBuffer applogContent_ = null;
	
	private JTextArea  recogTextArea_ = null; 
	private StringBuffer recogContent_ = null;
	
	private JTextArea  stateTextArea_ = null; 
	private StringBuffer stateContent_ = null;
	
	private IDMWindowActionListener eventListener_ = null;
	
	private JLabel pauseModeLabel_ = null;
	private JTextField locationTextField_ = null;
	private JTextArea speakTextArea_ = null;
	
	private String currLocalDirPath_ = "";
	
	private String test1Label_;
	private String test1Command_;
	private String test2Label_;
	private String test2Command_;
	private String test3Label_;
	private String test3Command_;
	
	private String demo1Label_;
	private String demo1File_ ;
	private String demo2Label_;
	private String demo2File_ ;
	private String demo3Label_;
	private String demo3File_ ;
	private String demo4Label_;
	private String demo4File_ ;
	
	private JTextField scriptEvalTextField_;
	private JTextArea scriptEvalResultTextArea_;
	private StringBuffer scriptEvalResultContent_;

	private JTextArea httpLogTextArea_;
	private String httpLogText_ = "";
	private JTextArea viewSrcTextArea_;
	private JTextArea viewGramTextArea_;
	private JTextArea viewTransTextArea_;
	private JTextArea loggerTextArea_;
	private String loggerText_ = "";
	private JTextArea configTextArea_;
	
	private void _send(String str) {
		System.out.println(str);
		System.out.flush();
	}
	
	private void _makeWindow(int width, int height) throws Exception {
		JFrame frame = new JFrame(galatea.dialog.DialogStudioVersion.TSTAMP);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		JMenuBar menuBar = _makeMenuBar();
		frame.setJMenuBar(menuBar);
		
		JPanel mainPanel = new JPanel(new GridBagLayout());
		GridBagConstraints mainPanelConstraints = WindowUtil.initPos();

		// controller panel
		
		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints c = WindowUtil.initPos();
		
		// **-- location bar
		WindowUtil.setPos(c, 0, 2, 1);
		locationTextField_ = new JTextField();
		panel.add(locationTextField_, c);
		
		// --*- button 
		WindowUtil.setPos(c, 2, 1);
		JButton buttonGo = new JButton("Go"); 
		panel.add(buttonGo, c);
		buttonGo.addActionListener( new MainPanelGoActionListener());
		
		// ---* button 
		WindowUtil.setPos(c, 3, 1);
		JButton buttonValidate = new JButton("Validate"); 
		panel.add(buttonValidate, c);
		buttonValidate.addActionListener( new MainPanelValidateActionListener());
		
		// *--- run/pause mode
		WindowUtil.nextRow(c);
		WindowUtil.setPos(c, 0, 1, 1);
		JButton buttonStart = new JButton("Run"); 
		panel.add(buttonStart, c);
		buttonStart.addActionListener( new MainPanelButtonStartActionListener());
		
		// -*--
		WindowUtil.setPos(c, 1, 1, 1);
		JButton buttonStop = new JButton("Pause"); 
		panel.add(buttonStop, c);
		buttonStop.addActionListener( new MainPanelButtonStopActionListener());
		
		// --**
		WindowUtil.setPos(c, 2, 2);
		pauseModeLabel_ = new JLabel("Mode: Run");
		panel.add(pauseModeLabel_, c);
		
		// tabbed pane
		JTabbedPane pane = new JTabbedPane();
		pane.addTab("Main", _makeMainPanel());
		pane.addTab("Config", _makeConfigPanel());
		pane.addTab("Script", _makeDebuggerPanel());
		pane.addTab("Logger", _makeLoggerPanel());
		pane.addTab("Http", _makeHttpPanel());
		pane.addTab("Source", _makeViewSrcPanel());
		pane.addTab("Translated", _makeViewTransPanel());
		pane.addTab("Grammar", _makeViewGramPanel());
		pane.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
		pane.setTabPlacement(SwingConstants.TOP);

		// add to mainPanel
		WindowUtil.setPos(mainPanelConstraints, 0, 4, 1, 0); // full width, strech holizontal
		mainPanel.add(panel, mainPanelConstraints);
		WindowUtil.nextRow(mainPanelConstraints);
		WindowUtil.setPos(mainPanelConstraints, 0, 4, 1, 1); // full width, strech both
		mainPanel.add(pane, mainPanelConstraints);
		
		// add to frame
		frame.getContentPane().add(mainPanel);
		frame.setSize(width, height);
		frame.setVisible(true);
	}

	private JMenuBar _makeMenuBar() {
		// menu bar
		JMenuBar menuBar = new JMenuBar();
		JMenu menuFile = new JMenu("File");
		menuBar.add(menuFile);
		
		// File - Open Local File...
		JMenuItem itemOpen = new JMenuItem("Open Local File...");
		menuFile.add(itemOpen);
		itemOpen.addActionListener( new MenuOpenActionListener());
		
		// File - Quit Current Dialog
		JMenuItem itemQuit = new JMenuItem("Quit Current Dialog");
		menuFile.add(itemQuit);
		itemQuit.addActionListener( new MenuQuitActionListener());
		
		// File - Reset Cookie
		JMenuItem resetCookieItem = new JMenuItem("Reset Cookie");
		menuFile.add(resetCookieItem);
		resetCookieItem.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				NetUtil.resetCookieManager();
			}});
		
		// File - Exit
		JMenuItem itemExit = new JMenuItem("Exit");
		menuFile.add(itemExit);
		itemExit.addActionListener( new MenuExitActionListener());
		
		// Face
		JMenu menuFace = new JMenu("Face");
		menuBar.add(menuFace);
		//
		JMenuItem itemAgentEnable = new JMenuItem("AgentEnable");
		menuFace.add(itemAgentEnable);
		itemAgentEnable.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FSM set AgentEnable = ENABLE");
			}
		});
		JMenuItem itemAgentDisable = new JMenuItem("AgentDisable");
		menuFace.add(itemAgentDisable);
		itemAgentDisable.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FSM set AgentEnable = DISABLE");
			}
		});
		//
		JMenuItem itemAgentAlpha10 = new JMenuItem("Alpha 1.0");
		menuFace.add(itemAgentAlpha10);
		itemAgentAlpha10.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FSM set AgentAlpha = 1.0");
			}
		});
		JMenuItem itemAgentAlpha08 = new JMenuItem("Alpha 0.8");
		menuFace.add(itemAgentAlpha08);
		itemAgentAlpha08.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FSM set AgentAlpha = 0.8");
			}
		});
		JMenuItem itemAgentAlpha05 = new JMenuItem("Alpha 0.5");
		menuFace.add(itemAgentAlpha05);
		itemAgentAlpha05.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FSM set AgentAlpha = 0.5");
			}
		});
		JMenuItem itemAgentAlpha03 = new JMenuItem("Alpha 0.3");
		menuFace.add(itemAgentAlpha03);
		itemAgentAlpha03.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FSM set AgentAlpha = 0.3");
			}
		});
		//
		JMenuItem itemViewMode1 = new JMenuItem("Texture");
		menuFace.add(itemViewMode1);
		itemViewMode1.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FSM set ViewMode = TEXTURE");
			}
		});
		//
		JMenuItem itemViewMode2 = new JMenuItem("Texture with Wireframe");
		menuFace.add(itemViewMode2);
		itemViewMode2.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FSM set ViewMode = TEXTURE_WITH_WIREFRAME");
			}
		});
		//
		JMenuItem itemViewMode3 = new JMenuItem("Wireframe");
		menuFace.add(itemViewMode3);
		itemViewMode3.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FSM set ViewMode = WIREFRAME");
			}
		});
		//
		
		// Mask
		JMenu menuMask = new JMenu("Mask");
		menuBar.add(menuMask);
		//
		JMenuItem itemMask1 = new JMenuItem("man01");
		menuMask.add(itemMask1);
		itemMask1.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @AM-MCL set Mask = man01");
			}
		});
		//
		JMenuItem itemMask2 = new JMenuItem("man02");
		menuMask.add(itemMask2);
		itemMask2.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @AM-MCL set Mask = man02");
			}
		});
		//
		JMenuItem itemMask3 = new JMenuItem("woman01");
		menuMask.add(itemMask3);
		itemMask3.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @AM-MCL set Mask = woman01");
			}
		});
		//
		
		// Auto
		JMenu menuAuto = new JMenu("Auto");
		menuBar.add(menuAuto);
		//
		JMenuItem itemAutoMoveOn = new JMenuItem("AutoMove ON");
		menuAuto.add(itemAutoMoveOn);
		itemAutoMoveOn.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @AM-MCL set AutoMove = 1");
			}
		});
		//
		JMenuItem itemAutoMoveOff = new JMenuItem("AutoMove OFF");
		menuAuto.add(itemAutoMoveOff);
		itemAutoMoveOff.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @AM-MCL set AutoMove = 0");
			}
		});
		//
//		JMenuItem itemAutoGazeOn = new JMenuItem("AutoGaze ON");
//		menuAuto.add(itemAutoGazeOn);
//		itemAutoGazeOn.addActionListener( new ActionListener() {
//			public void actionPerformed(ActionEvent e) {
//				_send("to @AM-MCL set AutoGaze = 1");
//			}
//		});
//		//
//		JMenuItem itemAutoGazeOff = new JMenuItem("AutoGaze OFF");
//		menuAuto.add(itemAutoGazeOff);
//		itemAutoGazeOff.addActionListener( new ActionListener() {
//			public void actionPerformed(ActionEvent e) {
//				_send("to @AM-MCL set AutoGaze = 0");
//			}
//		});
//		//
//		JMenuItem itemEmotionSpeakOn = new JMenuItem("EmotionSpeak ON");
//		menuAuto.add(itemEmotionSpeakOn);
//		itemEmotionSpeakOn.addActionListener( new ActionListener() {
//			public void actionPerformed(ActionEvent e) {
//				_send("to @AM-MCL set AutoEmotionSpeak = 1");
//			}
//		});
//		//
//		JMenuItem itemEmotionSpeakOff = new JMenuItem("EmotionSpeak OFF");
//		menuAuto.add(itemEmotionSpeakOff);
//		itemEmotionSpeakOff.addActionListener( new ActionListener() {
//			public void actionPerformed(ActionEvent e) {
//				_send("to @AM-MCL set AutoEmotionSpeak = 0");
//			}
//		});
//		//
		
		// Expression
		JMenu menuExp = new JMenu("Expression");
		menuBar.add(menuExp);
		//
		JMenuItem itemEmo1 = new JMenuItem("Neutral");
		menuExp.add(itemEmo1);
		itemEmo1.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FS-MCL set Emotion = NEUTRAL");
			}
		});
		//
		JMenuItem itemEmo2 = new JMenuItem("Happy");
		menuExp.add(itemEmo2);
		itemEmo2.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FS-MCL set Emotion = HAPPY 90");
			}
		});
		//
		JMenuItem itemEmo3 = new JMenuItem("Disgusted");
		menuExp.add(itemEmo3);
		itemEmo3.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FS-MCL set Emotion = DISGUSTED 90");
			}
		});
		//
		JMenuItem itemEmo4 = new JMenuItem("Sad");
		menuExp.add(itemEmo4);
		itemEmo4.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FS-MCL set Emotion = SAD 90");
			}
		});
		//
		JMenuItem itemEmo5 = new JMenuItem("Angry");
		menuExp.add(itemEmo5);
		itemEmo5.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FS-MCL set Emotion = ANGRY 90");
			}
		});
		//
		JMenuItem itemEmo6 = new JMenuItem("Surprised");
		menuExp.add(itemEmo6);
		itemEmo6.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FS-MCL set Emotion = SURPRISED 30");
			}
		});
		//
		JMenuItem itemEmo7 = new JMenuItem("Feared");
		menuExp.add(itemEmo7);
		itemEmo7.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				_send("to @FS-MCL set Emotion = FEARED 90");
			}
		});
		//
		
		// Demo
		JMenu menuDemo = new JMenu("Demo");
		menuBar.add(menuDemo);
		//
		
		test1Label_   = Property.getAsStr("DM.Window.Test.1.Label", null);
		test1Command_ = Property.getAsStr("DM.Window.Test.1.Command",  null);
		if (test1Label_ != null && test1Command_ != null) {
			JMenuItem itemTest1 = new JMenuItem(test1Label_);
			menuDemo.add(itemTest1);
			itemTest1.addActionListener( new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					_send(test1Command_);
				}
			});
		}
		
		test2Label_   = Property.getAsStr("DM.Window.Test.2.Label", null);
		test2Command_ = Property.getAsStr("DM.Window.Test.2.Command",  null);
		if (test2Label_ != null && test2Command_ != null) {
			JMenuItem itemTest2 = new JMenuItem(test2Label_);
			menuDemo.add(itemTest2);
			itemTest2.addActionListener( new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					_send(test2Command_);
				}
			});
		}
		
		test3Label_   = Property.getAsStr("DM.Window.Test.3.Label", null);
		test3Command_ = Property.getAsStr("DM.Window.Test.3.Command",  null);
		if (test3Label_ != null && test3Command_ != null) {
			JMenuItem itemTest3 = new JMenuItem(test3Label_);
			menuDemo.add(itemTest3);
			itemTest3.addActionListener( new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					_send(test3Command_);
				}
			});
		}
		
		
		demo1Label_ = Property.getAsStr("DM.Window.Demo.1.Label", null);
		demo1File_  = Property.getAsStr("DM.Window.Demo.1.File",  null);
		if (demo1Label_ != null && demo1File_ != null)  {
			JMenuItem itemDemo1 = new JMenuItem(demo1Label_);
			menuDemo.add(itemDemo1);
			itemDemo1.addActionListener( new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String adrs = Util.resolveAdrs(currLocalDirPath_, demo1File_);
					if (eventListener_ != null) {
						pauseModeLabel_.setText("Mode: Run");
						eventListener_.setPauseModeAction(false);
						eventListener_.setNextDocumentAction(adrs);
						eventListener_.terminateDialogAction();
					} else {
						System.err.println("adrs:" + adrs);
					}
				}
			});
		}
		
		demo2Label_ = Property.getAsStr("DM.Window.Demo.2.Label", null);
		demo2File_  = Property.getAsStr("DM.Window.Demo.2.File",  null);
		if (demo2Label_ != null && demo2File_ != null)  {
			JMenuItem itemDemo2 = new JMenuItem(demo2Label_);
			menuDemo.add(itemDemo2);
			itemDemo2.addActionListener( new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String adrs = Util.resolveAdrs(currLocalDirPath_, demo2File_);
					if (eventListener_ != null) {
						pauseModeLabel_.setText("Mode: Run");
						eventListener_.setPauseModeAction(false);
						eventListener_.setNextDocumentAction(adrs);
						eventListener_.terminateDialogAction();
					} else {
						System.err.println("adrs:" + adrs);
					}
				}
			});
		}
		
		demo3Label_ = Property.getAsStr("DM.Window.Demo.3.Label", null);
		demo3File_  = Property.getAsStr("DM.Window.Demo.3.File",  null);
		if (demo3Label_ != null && demo3File_ != null)  {
			JMenuItem itemDemo3 = new JMenuItem(demo3Label_);
			menuDemo.add(itemDemo3);
			itemDemo3.addActionListener( new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String adrs = Util.resolveAdrs(currLocalDirPath_, demo3File_);
					if (eventListener_ != null) {
						pauseModeLabel_.setText("Mode: Run");
						eventListener_.setPauseModeAction(false);
						eventListener_.setNextDocumentAction(adrs);
						eventListener_.terminateDialogAction();
					} else {
						System.err.println("adrs:" + adrs);
					}
				}
			});
		}
		
		demo4Label_ = Property.getAsStr("DM.Window.Demo.4.Label", null);
		demo4File_  = Property.getAsStr("DM.Window.Demo.4.File",  null);
		if (demo4Label_ != null && demo4File_ != null)  {
			JMenuItem itemDemo4 = new JMenuItem(demo4Label_);
			menuDemo.add(itemDemo4);
			itemDemo4.addActionListener( new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					String adrs = Util.resolveAdrs(currLocalDirPath_, demo4File_);
					if (eventListener_ != null) {
						pauseModeLabel_.setText("Mode: Run");
						eventListener_.setPauseModeAction(false);
						eventListener_.setNextDocumentAction(adrs);
						eventListener_.terminateDialogAction();
					} else {
						System.err.println("adrs:" + adrs);
					}
				}
			});
		}
		return menuBar;
	}
	
	
	private JPanel _makeMainPanel() {
		// panel
		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints c = WindowUtil.initPos();
		
		// speaking
		//_nextRow(c);
		WindowUtil.setPos(c, 0, 4);
		panel.add(new JLabel("Speak"), c);
		
		WindowUtil.nextRow(c);
		WindowUtil.setPos(c, 0, 4, 1, 1);
		speakTextArea_ = new JTextArea();
		speakTextArea_.setEditable(false);
		speakTextArea_.setRows(3);
		speakTextArea_.setLineWrap(true);
		WindowUtil.fixFont(speakTextArea_);
		panel.add(new JScrollPane(speakTextArea_,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
		), c
		);
		
		// applog
		WindowUtil.nextRow(c);
		WindowUtil.setPos(c, 0, 4);
		panel.add(new JLabel("Log"), c);
		
		WindowUtil.nextRow(c);
		WindowUtil.setPos(c, 0, 4, 1, 1);
		applogTextArea_ = new JTextArea();
		applogTextArea_.setEditable(false);
		applogTextArea_.setRows(3);
		applogTextArea_.setLineWrap(true);
		WindowUtil.fixFont(applogTextArea_);
		panel.add(new JScrollPane(applogTextArea_,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
		), c
		);
		
		WindowUtil.nextRow(c);
		WindowUtil.setPos(c, 0, 4);
		panel.add(new JLabel("Input"), c);
		
		WindowUtil.nextRow(c);
		WindowUtil.setPos(c, 0, 4, 1, 2);
		recogTextArea_ = new JTextArea();
		recogTextArea_.setEditable(false);
		recogTextArea_.setRows(3);
		recogTextArea_.setLineWrap(true);
		WindowUtil.fixFont(recogTextArea_);
		panel.add(new JScrollPane(recogTextArea_,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
		), c
		);
		
		WindowUtil.nextRow(c);
		WindowUtil.setPos(c, 0, 4);
		panel.add(new JLabel("State History"), c);
		
		WindowUtil.nextRow(c);
		WindowUtil.setPos(c, 0, 4, 1, 2);
		stateTextArea_ = new JTextArea();
		stateTextArea_.setEditable(false);
		stateTextArea_.setRows(3);
		stateTextArea_.setLineWrap(true);
		WindowUtil.fixFont(stateTextArea_);
		panel.add(new JScrollPane(stateTextArea_,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
		), c
		);
		return panel;
	}
	
	private JPanel _makeDebuggerPanel() {
		// panel
		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints c = WindowUtil.initPos();
		
		// ***-- textfield
		WindowUtil.setPos(c, 0, 3, 1);
		scriptEvalTextField_ = new JTextField();
		panel.add(scriptEvalTextField_, c);
		
		// ---*- button 
		WindowUtil.setPos(c, 3, 1);
		JButton buttonGo = new JButton("Eval"); 
		panel.add(buttonGo, c);
		buttonGo.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String str = scriptEvalTextField_.getText();
				if (eventListener_ != null) {
					scriptEvalResultContent_.append(">" + str + "\n");
					scriptEvalResultTextArea_.setText(
							scriptEvalResultContent_.toString());
					eventListener_.addDebuggerEvalAction(str);
				} else {
					System.out.println(e);
					System.out.println(str);
				}
			}
		});
		
		// ----* button 
		WindowUtil.setPos(c, 4, 1);
		JButton buttonSrc = new JButton("To Source"); 
		panel.add(buttonSrc, c);
		buttonSrc.addActionListener( new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				String str = scriptEvalTextField_.getText();
				str += ".toSource()";
				if (eventListener_ != null) {
					scriptEvalResultContent_.append(">" + str + "\n");
					scriptEvalResultTextArea_.setText(
							scriptEvalResultContent_.toString());
					eventListener_.addDebuggerEvalAction(str);
				} else {
					System.out.println(e);
					System.out.println(str);
				}
			}
		});
		

		WindowUtil.nextRow(c);
		WindowUtil.setPos(c, 0, 5);
		panel.add(new JLabel("Result"), c);
		
		WindowUtil.nextRow(c);
		WindowUtil.setPos(c, 0, 5, 1, 1);
		scriptEvalResultTextArea_ = new JTextArea();
		scriptEvalResultTextArea_.setEditable(false);
		scriptEvalResultTextArea_.setLineWrap(true);
		WindowUtil.fixFont(scriptEvalResultTextArea_);
		panel.add(new JScrollPane(scriptEvalResultTextArea_,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
		), c
		);
		return panel;
	}
		
	public void dispDebuggerEvalResult(String result) {
		scriptEvalResultContent_.append(result + "\n");
		if (scriptEvalResultTextArea_ != null) {
			SwingUtilities.invokeLater(new Runnable() {
				public void run() {
					scriptEvalResultTextArea_.setText(
							scriptEvalResultContent_.toString());
				}
			});
		}
	}
	
	private JPanel _makeLoggerPanel() {
		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints c = WindowUtil.initPos();
		// 
		_addLoggerConfigTable(panel, c);
		// text area
		WindowUtil.setPos(c, 0, 0, 1, 2);
		loggerTextArea_ = new JTextArea();
		loggerTextArea_.setEditable(false);
		loggerTextArea_.setLineWrap(true);
		WindowUtil.fixFont(loggerTextArea_);
		panel.add(new JScrollPane(loggerTextArea_,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
		), c
		);
		return panel;
	}

    private DefaultTableModel loggerConfigTableModel_;

	private void _addLoggerConfigTable(JPanel panel, GridBagConstraints c) {
		// table
		WindowUtil.setPos(c, 0, 0, 1, 1);
	    loggerConfigTableModel_ = new DefaultTableModel() {
	        @Override
	        public Class<?> getColumnClass(int column) {
	            return getValueAt(0, column).getClass();
	        }
	        @Override
	        public boolean isCellEditable(int row, int col) {
	            return col == 2; // column number of checkbok
	        }
	    };
        Timer timer1 = new Timer();
        timer1.schedule(new TimerTask() {
			@Override
			public void run() {
				if (Logger.needUpdate()) {
					Vector<String> columnNamesVector = Logger.getColumnNamesVector();
					Vector<Object> dataVector = Logger.getEnableFlagsDataVector();
					loggerConfigTableModel_.setDataVector(dataVector, columnNamesVector);
					Logger.updateDone();
				}
			}
			}, 0, 1000);
		JTable table = new JTable(loggerConfigTableModel_) {
			@Override
			public Component prepareEditor(TableCellEditor editor, int row, int column) {
				Component cmp = super.prepareEditor(editor, row, column);
				if (convertColumnIndexToModel(column) == 2) {
					JCheckBox c = (JCheckBox) cmp;
					c.addItemListener(new ItemListener() {
						@Override
						public void itemStateChanged(ItemEvent e) {
							AbstractButton select = (AbstractButton)e.getItemSelectable();
							if (e.getStateChange() == ItemEvent.SELECTED
									|| e.getStateChange() == ItemEvent.DESELECTED) {
								SwingUtilities.invokeLater(new Runnable() {
									@Override
									public void run() {
										Logger.updateEnableFlags();
									}
								});
							}
						}
					});
				}
				return cmp;
			}
		};
        table.setAutoCreateRowSorter(true);
        table.setFillsViewportHeight(true);
        table.setShowGrid(false);
        table.setIntercellSpacing(new Dimension());
        table.setRowSelectionAllowed(false);
        table.setColumnSelectionAllowed(false);
        //
		panel.add(new JScrollPane(table,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
		), c
		);
		WindowUtil.nextRow(c);
	}

	private JPanel _makeHttpPanel() {
		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints c = WindowUtil.initPos();
		WindowUtil.setPos(c, 0, 0, 1, 1);
		httpLogTextArea_ = new JTextArea();
		httpLogTextArea_.setEditable(false);
		httpLogTextArea_.setLineWrap(true);
		WindowUtil.fixFont(httpLogTextArea_);
		panel.add(new JScrollPane(httpLogTextArea_,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
		), c
		);
		return panel;
	}
	
	private JPanel _makeViewSrcPanel() {
		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints c = WindowUtil.initPos();
		WindowUtil.setPos(c, 0, 0, 1, 1);
		viewSrcTextArea_ = new JTextArea();
		viewSrcTextArea_.setEditable(false);
		viewSrcTextArea_.setLineWrap(true);
		WindowUtil.fixFont(viewSrcTextArea_);
		panel.add(new JScrollPane(viewSrcTextArea_,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
		), c
		);
		return panel;
	}
	
	private JPanel _makeViewGramPanel() {
		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints c = WindowUtil.initPos();
		WindowUtil.setPos(c, 0, 0, 1, 1);
		viewGramTextArea_ = new JTextArea();
		viewGramTextArea_.setEditable(false);
		viewGramTextArea_.setLineWrap(true);
		WindowUtil.fixFont(viewGramTextArea_);
		panel.add(new JScrollPane(viewGramTextArea_,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
		), c
		);
		return panel;
	}
	
	private JPanel _makeViewTransPanel() {
		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints c = WindowUtil.initPos();
		WindowUtil.setPos(c, 0, 0, 1, 1);
		viewTransTextArea_ = new JTextArea();
		viewTransTextArea_.setEditable(false);
		viewTransTextArea_.setLineWrap(true);
		WindowUtil.fixFont(viewTransTextArea_);
		panel.add(new JScrollPane(viewTransTextArea_,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
		), c
		);
		return panel;
	}

	private JPanel _makeConfigPanel() {
		JPanel panel = new JPanel(new GridBagLayout());
		GridBagConstraints c = WindowUtil.initPos();
		WindowUtil.setPos(c, 0, 0, 1, 1);
		configTextArea_ = new JTextArea();
		configTextArea_.setEditable(false);
		configTextArea_.setLineWrap(true);
		WindowUtil.fixFont(configTextArea_);
		panel.add(new JScrollPane(configTextArea_,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
		), c
		);
		
		String config = Property.getConfigStrings();
		configTextArea_.setText(config);
		
		return panel;
	}
	
	public DialogManagerWindow() {
		applogContent_ = new StringBuffer();
		recogContent_  = new StringBuffer();
		stateContent_ = new StringBuffer();
		scriptEvalResultContent_ = new StringBuffer();
		currLocalDirPath_ = Property.getAsStr("user.dir", "/");
		currLocalDirPath_ += Property.getAsStr("user.dir.suffix", "/files/");
		currLocalDirPath_ = "file:" + Util.replaceAll(currLocalDirPath_, "\\", "/");
		
		if ( Property.getAsBoolean("ShowWindow", true)) {
			try {
				WindowUtil.setLookAndFeel();
				int w = Property.getAsInt("DM.WindowWidth", 640);
				int h = Property.getAsInt("DM.WindowHeight", 480);
				_makeWindow(w, h);
			} catch(Exception e) { 
				System.out.println(e); 
			}
		}
	}
	
	public void documentLocationChanged(String text) {
		if (locationTextField_ != null) {
			locationTextField_.setText(text);
		}
	}
	
	public void outputVoiceStarted(String text) {
		if (speakTextArea_ != null) {
			speakTextArea_.setText(Util.removeTags(text));
		}
	}
	
	public void dispApplog(String text) {
		if (applogContent_ != null) {
			applogContent_.insert(0, text + "\n");
		}
		if (applogTextArea_ != null) {
			applogTextArea_.setText(applogContent_.toString());
		}
	}
	
	public void inputEventReceived(String text) {
		if (recogContent_ != null) {
			recogContent_.insert(0, text + "\n");
		}
		if (recogTextArea_ != null) {
			recogTextArea_.setText(recogContent_.toString());
		}
	}
	
	public void dialogStateChanged(String text) {
		if (stateContent_ != null) {
			stateContent_.insert(0, text + "\n");
		}
		if (stateTextArea_ != null) {
			stateTextArea_.setText(stateContent_.toString());
		}
	}
	
	public void fatalError(String error) {
		if (stateContent_ != null) {
			stateContent_.insert(0, error + "\n");
		}
		if (stateTextArea_ != null) {
			stateTextArea_.setText(stateContent_.toString());
		}
	}

	public void setDialogManagerWindowActionListener(
			IDMWindowActionListener listener) {
		eventListener_ = listener;
	}
	
	public void srcFileUpdated(String text) {
		if (viewSrcTextArea_ != null) {
			viewSrcTextArea_.setText(text);
		}
	}
	
	public void translatedFileUpdated(String text) {
		if (viewTransTextArea_ != null) {
			viewTransTextArea_.setText(text);
		}
	}
	
	public void grammarFileUpdated(String text) {
		if (viewGramTextArea_ != null) {
			viewGramTextArea_.setText(text);
		}
	}
	
	@Override
	public void addNetUtilEvent(String msg) {
		if (httpLogTextArea_ != null) {
			httpLogText_ += msg + "\n";
			httpLogTextArea_.setText(httpLogText_);
		}
	}

	/**
	 * Notice: this method replaces "<br />" to NewLine.
	 */
	@Override
	public void addLoggerEvent(String msg) {
		if (loggerTextArea_ != null) {
			loggerText_ = msg.replaceAll("<br />", "\n") + "\n" + loggerText_;
			loggerTextArea_.setText(loggerText_);
		}
	}

	public static void main(String args[]) throws Exception {
		DialogManagerWindow w = new DialogManagerWindow();
		//w._setLookAndFeel();
		//w._makeWindow(640, 480);
		w.dispApplog("\u65e5\u672c\u8a9e"); // nihongo
		//w.dispApplog("java.io.tmpdir=" + System.getProperty("java.io.tmpdir"));
		//w.dispApplog("os.arch=" + System.getProperty("os.arch"));
		//w.dispApplog("os.name=" + System.getProperty("os.name"));
		//w.dispApplog("user.dir=" + System.getProperty("user.dir"));
		for (int i = 0; ; i++) {
			String s = "test" + i;
			w.dispApplog(s);
			try { 
				Thread.sleep(3000);
			} catch (Exception e) {e.printStackTrace();}
		}
	}

}

