/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 *
 *  $Id: SetNextCommand.java,v 1.2 2009/01/28 13:51:17 nishimoto Exp $
 */

package galatea.command;

import galatea.dialog.RuntimeError;

//import galatea.main.*;

public class SetNextCommand extends Command
{
//	private Debug dbg = new Debug(1);
	
	private String next_;
	
	public SetNextCommand(String next)
	{
		next_ = next;
	}
	
	public SetNextCommand(String next, String cond)
	{
		next_ = next;
		setCondition(cond);
	}
	
	public String getNext()
	{
		return(next_);
	}
	
	
	public String toString()
	{
		String s = "  <next";
		if ( hasCondition() ) {
			s += " cond=\"" + getConditionAsEncodedString() + "\"";
		}
		s += ">";
		s += next_ + "</next>";
		return s;
	}
	
	
	public void execute() throws RuntimeError
	{
		String state = ecmascript_.evaluate(next_);
		
		if ( evaluateCondition() == true ) {
			interpreterContext_.setNextState(state);
		}
	}
	
}
