/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 *
 *  $Id: LogOutItem.java,v 1.2 2009/01/28 13:51:17 nishimoto Exp $
 */

package galatea.outitem;

import galatea.dialog.RuntimeError;

//import galatea.DialogManagerWindow;
//import galatea.io.OutputDevice;
//import galatea.main.*;

public class LogOutItem extends OutItem 
{
//	private Debug dbg = new Debug(1);
	
	private String msg_;
	
	private String with_ = "";
	
	public LogOutItem(String msg)
	{
		this(msg, null);
	}
	
	public LogOutItem(String msg, String with)
	{
		isInstant_ = true;
		msg_ = msg;
		with_ = with;
	}
	
	public void setWith(String s) 
	{
		with_ = s;
	}
	
	public String getWith() 
	{
		return with_;
	}
	
	public void doEvaluate() throws RuntimeError
	{
		String script;
		if ( with_ != null && with_.length() > 0 ) {
			script = "with(" + with_ + "){" + msg_ + "}";
		} else {
			script = msg_;
		}
		arg_ = ecmascript_.evaluate(script);
	}
	
//	public void doOutput(/* OutputDevice d */)
//	{
//		DialogManagerWindow.doDispApplog(arg_);
//	}
	
	public String toString()
	{
		String s = "<log";
		if ( with_ != null && with_.length() > 0 ) {
			s += " with=\"" + with_ + "\"";
		}
		s += ">";
		s += msg_;
		s += "</log>";
		return s;
	}
	
}
