/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishimoto [atmark] m.ieice.org)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: AudioOutItem.java,v 1.2 2009/01/28 13:51:17 nishimoto Exp $
 */

package galatea.outitem;

import galatea.dialog.RuntimeError;



public class AudioOutItem extends OutItem
{
	private String src_;
	
	public AudioOutItem(String src, boolean bargein)
	{
		init(src, bargein);
	}
	
	public AudioOutItem(String src)
	{
		init(src, false);
	}
	
	private void init(String src, boolean bargein) {
		isInstant_ = false;
		bargein_ = bargein;
		src_ = src;
	}
	
	public void doEvaluate() throws RuntimeError
	{
		arg_ = ecmascript_.evaluate(src_); 
	}
	
	public String toString()
	{
		String s = "<audio";
		if ( bargein_ == false ) {
			s += " bargein=\"false\"";
		}
		s += ">";
		s += src_;
		s += "</audio>";
		return s;
	}
}
