/**
 * $Id: KeypadSubModule.java,v 1.3 2009/01/18 13:04:08 nishimoto Exp $
 */
package galatea.io.plugins;

import galatea.dialog.InterpretedEvent;
import galatea.logger.Logger;
import galatea.submodule.AbstractSubModule;
import galatea.util.HashArray;
import galatea.util.Util;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * <form id="myform>
 * <field name="getdigit" type="digits?length=1">
 * 
 * set FieldName = myform.getdigit
 * set FieldType = digits?length=3
 * 
 */
public class KeypadSubModule extends AbstractSubModule
	implements KeyListener {
	
	private Logger dbg = new Logger(this.getClass());
	private KeypadWindow keypadWindow_;
	private int acceptableLength_ = 3;
	private String slot_ = "dummy";
	private long lastInputWhen_;
	private String dialogName_;
	private HashArray slotAliases_ = new HashArray();

	// arg1 arg2
	private Pattern pattern4_ = Pattern.compile("(\\S+) (.*)");
	
	public KeypadSubModule() {
		super();
		setName("KBD");
		keypadWindow_ = new KeypadWindow(this);
	}

	public boolean filterOutputNative(String str) {
		String s;
		if ((s = Util.getFirstGroup("to @KBD set FieldName = (.*)$", str)) != null) {
			setFieldName(s);
			return true;
		} else if ((s = Util.getFirstGroup("to @KBD set FieldType = (.*)$", str)) != null) {
			setFieldType(s);
			return true;
		} else if ((s = Util.getFirstGroup("to @SIM set DialogName = (.*)$", str)) != null) {
			setDialogName(s);
			return true;
		} else if ((s = Util.getFirstGroup("to @SIM set SlotAlias = (.*)$", str)) != null) {
			setSlotAlias(s);
			return true;
		}
		return false;
	}
	
	private void setSlotAlias(String s) {
		if (s.equals("RESET")) {
			slotAliases_ = new HashArray();
		} else {
			Matcher m;
			if ((m = pattern4_.matcher(s)).matches()) {
				slotAliases_.put(m.group(1), m.group(2));
			}
		}
	}

	private void setDialogName(String s) {
		dialogName_ = s;
	}

	public void setFieldName(String s) {
		slot_ = s;
	}
	
	public void setFieldType(String s) {
	}
	
	public void keyTyped(KeyEvent e) {
		dbg.print("keyTyped:" + e.paramString());
		if (e.isActionKey()) {
		} else if (e.getKeyChar() == KeyEvent.VK_ENTER) {
			_checkInput();
		} else if (e.getKeyChar() == KeyEvent.VK_ESCAPE) {
			keypadWindow_.clearInputText();
		} else {
			keypadWindow_.addChar(e.getKeyChar());
		}
	}
	
	public void keyPressed(KeyEvent e) {
		// dbg.print("keyPressed:" + e.paramString());
		lastInputWhen_ = Util.getCurrentTimeInMillis();
	}
	
	public void keyReleased(KeyEvent e) {
	}
	
	private void _checkInput() {
		if (keypadWindow_.getInputLength() == acceptableLength_) {
			String src = "KBD";
			String val = keypadWindow_.getInputText();
			String script = 
				"$utterance='" + val + "';" + slot_ + "='" + val + "';" 
				+ slot_ + "$.justfilled=true;";
			String xmlevent = 
				"<ev src=\"" + src + "\" type=\"INPUT\"><interpreted>"
				// +"<text>" + val + "</text>"
				+"<script>" + script + "</script></interpreted></ev>";
			InterpretedEvent ev = InterpretedEvent.newInstance(xmlevent);
			receiver_.receiveInterpreted(ev);
		}
		keypadWindow_.clearInputText();
	}

	public void doTimerTask() {
		long curr = Util.getCurrentTimeInMillis();
		if (curr - lastInputWhen_ > 1000) {
			_checkInput();
		}
		
	}
}
