/*
 * Galatea Dialog Studio
 * (c)2009 Takuya NISHIMOTO
 * $Id: DeviceManager.java,v 1.13 2009/03/07 14:16:12 nishimoto Exp $
 */
package galatea.io;

import galatea.dialog.IControllerModeManager;
import galatea.dialog.IInterpretedEventListener;
import galatea.dialog.InterpretedEvent;
import galatea.dialog.RuntimeError;
import galatea.dialog.window.DialogManagerWindow;
import galatea.dialog.window.IDMWindowActionListener;
import galatea.httpclient.NetUtil;
import galatea.httpserver.HttpRequestTask;
import galatea.httpserver.HttpServer;
import galatea.httpserver.HttpSession;
import galatea.httpserver.IHttpRequestResponder;
import galatea.httpserver.IHttpResponseHtmlMaker;
import galatea.io.julius.GrammarSubModule;
import galatea.io.julius.JuliusSubModule;
import galatea.io.plugins.AudioPlayerSubModule;
import galatea.io.plugins.GalateaTalkSubModule;
import galatea.io.plugins.KeypadSubModule;
import galatea.io.plugins.MotionSubModule;
import galatea.io.wrapper.SSMSubModule;
import galatea.logger.Logger;
import galatea.outitem.BreakOutItem;
import galatea.outitem.LogOutItem;
import galatea.outitem.NativeOutItem;
import galatea.outitem.OutItem;
import galatea.submodule.IReceiverFromSubModule;
import galatea.submodule.ISubModule;
import galatea.util.Property;

import java.util.ArrayList;

public class DeviceManager
	implements IReceiverFromSubModule, IHttpRequestResponder
	{

	private Logger logger_ = new Logger(this.getClass());
	private AMThread amt_;
	private BreakThread bt_;
	private HttpSenderToDevice httpDevice_;
	private ArrayList<IInterpretedEventListener> interpretedEventListeners_ = new ArrayList<IInterpretedEventListener>();
	private ArrayList<IOutputEventListener> outputEventListeners_ = new ArrayList<IOutputEventListener>();
	private int runLevel_ = 0;
	private int targetRunLevel_ = 1;
	private int runLevelUnchangedCount_ = 0;
	private IControllerModeManager icmode_;
	private ArrayList<HttpRequestTask> httpRequestTasks_ = new ArrayList<HttpRequestTask>();
	private HttpServer httpServer_;
	private HttpSession httpSession_;
	private DialogManagerWindow window_;

	public DeviceManager() {
	}
	
	public void start(IControllerModeManager ic0,
			IOutputEventListener ic1,
			IInterpretedEventListener ic2,
			IHttpResponseHtmlMaker ic3,
			IDMWindowActionListener ic4
			) {
		
		window_ = new DialogManagerWindow();
		window_.setDialogManagerWindowActionListener(ic4);
		NetUtil.addListener(window_);
		Logger.addListener(window_);

		int port = Property.getAsInt("DM.HttpServerPort", 0);
		if (port != 0) {
			httpServer_ = new HttpServer();
			httpSession_ = new HttpSession(ic3, this);
			httpServer_.start(httpSession_, port);
			logger_.print("http server started. port:" + port);
		}
		httpDevice_ = new HttpSenderToDevice(httpSession_);
		
		// bt
		logger_.print("BreakThread starting..");
		bt_ = new BreakThread();
		bt_.addOutputEventListener(ic1);
		bt_.start();
		logger_.print("BreakThread started.");
		
		// amt
		logger_.print("AMThread starting..");
		amt_ = new AMThread();
		
		icmode_ = ic0;
		addOutputEventListener(ic1);
		addInterpretedEventListener(ic2);
		
		// SSM
		ISubModule ssmSubModule_;
		if (Property.getAsBoolean("DM.UseWrapper.SSM", true)) {
			ssmSubModule_ = new SSMSubModule();
		} else {
			ssmSubModule_ = new GalateaTalkSubModule();
		}
		amt_.addSubModule(ssmSubModule_, this, window_);
		
		// SND
		ISubModule sndSubModule_ = new AudioPlayerSubModule();
		amt_.addSubModule(sndSubModule_, this, window_);
		
		// SRM & SIM
		ISubModule srmSubModule_ = new JuliusSubModule();
		amt_.addSubModule(srmSubModule_, this, window_);

		// GRM
		ISubModule grmSubModule_ = new GrammarSubModule();
		amt_.addSubModule(grmSubModule_, this, window_);
		
		// keypad
		if (Property.getAsBoolean("DM.UseKeypadSubModule", false)) {
			ISubModule keypadSubModule_ = new KeypadSubModule();
			amt_.addSubModule(keypadSubModule_, this, window_);
		}
		// motion
		if (Property.getAsBoolean("DM.UseMotionSubModule", false)) {
			ISubModule motionSubModule_ = new MotionSubModule();
			if (httpDevice_ != null) {
				httpDevice_.addSubModule(motionSubModule_, this, window_);
			}
		}
		
		amt_.start();
		logger_.print("AMThread started.");
	}

	public void doTimerTask() throws RuntimeError {
		for (int i = 0, n = getSubModules().size(); i < n; i++) {
			getSubModules().get(i).doTimerTask();
		}
	}

	private void addInterpretedEventListener(IInterpretedEventListener l) {
		interpretedEventListeners_.add(l);
	}

	private void addOutputEventListener(IOutputEventListener l) {
		outputEventListeners_.add(l);
	}
	
	// runLevel
	private int getRunLevel() {
		return runLevel_;
	}

	// runLevel
	private void setRunLevel(int i) {
		runLevel_ = i;
	}
	
	private boolean _isRunLevel2() {
		//dbg.print("runLevel: " + runLevel_ );
		if (getRunLevel() == 2 )
			return true;
		return false;
	}
	
	private void _dispDeviceManagerLog(String str) {
		window_.inputEventReceived(str);
	}

	private void _dispLogOutItem(String str) {
		window_.dispApplog(str);
	}

	private boolean _gotoRunLevel2() {
		setRunLevel(1);
		_dispDeviceManagerLog("RunLevel:1");
		amt_.outputNative("rep Run = DEAD");
		
		// wait for the wakeup of SRM (julius4)
		try { 
			Thread.sleep(2, 0);
		} catch (Exception e) {
			logger_.print(e.toString());
		}
		
		_setTargetRunLevel(2);
		return true;
	}
	

	private void _setTargetRunLevel(int level) {
		runLevelUnchangedCount_ = getSubModules().size();
		targetRunLevel_ = level;
		for (int i = 0, n = getSubModules().size(); i < n; i++) {
			getSubModules().get(i).setTargetRunLevel(level);
		}
	}

	public boolean waitDevicesForReady() {
		logger_.print("wait AMThread isReady...");
		if (_gotoRunLevel2() == false) {
			logger_.print("failed to gotoRunLevel2.");
			return false;
		}
		int count = 0; 
		while(! _isRunLevel2()) {
			count++;
			try { 
				Thread.sleep(3);
				doTimerTask();
			} catch (Exception e) {
				//e.printStackTrace();
				logger_.print("waitDevicesForReady " + e.toString());
			}
			if (count > 10) {
				logger_.print("startup failed.");
				return false;
			}
		}
		logger_.print("starting done.");
		return true;
	}
	
	/**
	 * doOutput, mapping OutItem and SubModule 
	 * @param item
	 * @return false if error
	 */
	public boolean doOutput(OutItem item) {
		if (item instanceof NativeOutItem) {
			NativeOutItem o = (NativeOutItem)item;
			String str = o.getArg();
			amt_.outputNative(str);
			return true;
		} else if (item instanceof BreakOutItem) {
			bt_.outputDeviceStart(item);
			return true;
		} else if (item instanceof LogOutItem) {
			LogOutItem o = (LogOutItem)item;
			_dispLogOutItem(o.getArg());
			return true;
		} else {
			// Chain of Responsibility
			for (int i = 0, n = getSubModules().size(); i < n; i++) {
				if (getSubModules().get(i).startOutput(item)) {
					return true;
				}
			}
		}
		logger_.print("doOutput failed:" + item.toString());
		return false;
	}
	
	
	/**
	 * doStop, mapping OutItem and SubModule 
	 * @param item
	 * @return false if error
	 */
	public boolean doStop(OutItem item) {
		if (item instanceof BreakOutItem) {
			bt_.outputDeviceStop(item);
			return true;
		} else {
			// Chain of Responsibility
			for (int i = 0, n = getSubModules().size(); i < n; i++) {
				if (getSubModules().get(i).stopOutput(item)) {
					return true;
				}
			}
		}
		logger_.print("doStop failed:" + item.toString());
		return false;
	}


	@Override
	public void receiveInterpreted(InterpretedEvent ev) {
		for (int i = 0; i < interpretedEventListeners_.size(); i++) {
			((IInterpretedEventListener)interpretedEventListeners_.get(i))
				.enqueueInterpretedEvent(ev);
		}
	}
	
	public void updateDialogStateChange(String state) {
		window_.dialogStateChanged(state);
	}
	
	@Override
	public void receiveOutputBusy(String device, String message) {
		for (int i = 0; i < outputEventListeners_.size(); i++) {
			outputEventListeners_.get(i).enqueueOutputEvent(
					DeviceEvent.newOutputBusyInstance(device,message));
		}
	}

	@Override
	public void receiveOutputReady(String device, String message) {
		for (int i = 0; i < outputEventListeners_.size(); i++) {
			outputEventListeners_.get(i).enqueueOutputEvent(
				DeviceEvent.newOutputReadyInstance(device,message));
		}
	}

	@Override
	public void receiveRunLevel(int level, ISubModule src) {
		logger_.print("RunLevel:" + level + " sender:" + src.getName());
		if (targetRunLevel_ == level && runLevelUnchangedCount_ > 0) {
			runLevelUnchangedCount_ --;
			if (runLevelUnchangedCount_ == 0) {
				setRunLevel(targetRunLevel_);
				if (level == 2) {
					amt_.outputNative("rep Run = LIVE");
					_dispDeviceManagerLog("RunLevel:2");
				}
			}
		}
	}

	/**
	 * this method is used from HttpServerResponse
	 * @return result (log message)
	 */
	@Override
	public String respondToHttpRequest(String module, String ev, String arg) {
		logger_.ASSERT(module != null, "m != null");
		logger_.ASSERT(ev != null, "e != null");
		if (httpDevice_.checkInput(module, ev)) {
			return module + " " + ev + " accepted";
		} else if (module.equals("browser")) {
			synchronized (this) {
				httpRequestTasks_.add(new HttpRequestTask(ev,arg));
			}
			return "task enqueued";
		}
		return "event ignored";
	}

	public synchronized int sizeExternalTask() {
		return httpRequestTasks_.size();
	}

	public synchronized HttpRequestTask removeExternalTask() {
		return httpRequestTasks_.remove(0);
	}

	public void dispDocInfo(String file, String state, String src, String trans) {
		window_.documentLocationChanged(file);
		window_.dialogStateChanged(state);
		window_.srcFileUpdated(src);
		window_.translatedFileUpdated(trans);
	}

	public void dispDebuggerEvalResult(String result) {
		window_.dispDebuggerEvalResult(result);
	}

	@Override
	public void requestAck() {
		for (int i = 0; i < interpretedEventListeners_.size(); i++) {
			interpretedEventListeners_.get(i).requestAck();
		}
	}

	private ArrayList<ISubModule> getSubModules() {
		return amt_.getSubModules();
	}

	public void setPauseMode(boolean b) {
		logger_.print("setPauseMode " + Boolean.toString(b));
		amt_.setPauseMode(b);
	}

}
