﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using WindowsGame1;
using Microsoft.Xna.Framework.Graphics;
using FrkEffectViewer.GameSystem;

namespace WindowsGame1
{
    class Particle : GameObject3D
    {
        public Vector3 Vec;
        public static Texture2D Tex;
        public float fRot = 0;
        public float fScale;
        public Vector2 UV;
        public Vector2 UVSize;
        public float fAlpha;
        public Particle()
        {

        }
        public Particle(Vector3 pos, Vector3 vec, float scale)
        {
            Random r = Rand.GetRand();
            Qua = Quaternion.CreateFromYawPitchRoll(MathHelper.ToRadians((float)r.NextDouble() * 360.0f),
                MathHelper.ToRadians((float)r.NextDouble() * 360.0f),
                MathHelper.ToRadians((float)r.NextDouble() * 360.0f));
            Pos = pos;
            float spd = (float)r.NextDouble() * 0.1f;
            Vec = vec;// Matrix.CreateFromQuaternion(Qua).Forward * spd;
            nTime = Rand.GetRand().Next(10);
            if (Tex == null)
            {
                Tex = GameMain.Grf.LoadImage("Texture/Bst_Tex");
            }
            fScale = scale;// (float)(r.NextDouble()) * 0.5f + 0.01f;
            UV.X = 0;
            UV.Y = 0;
            UVSize.X = 1.0f;
            UVSize.Y = 1.0f;
            fRot = MathHelper.ToRadians((float)(r.NextDouble()) * 360.0f);
            fAlpha = 0.5f;
        }

        public override bool Main()
        {
            Pos += Vec;
            Vec *= 0.98f;
            fAlpha *= 0.95f;
            if (nTime++ > 60)
            {
                return true;
            }
            return false;
        }
        public unsafe override void Draw()
        {
            VertexPositionColorTexture[] vertices = new VertexPositionColorTexture[4];

            vertices[0].Position = new Vector3(-0.5f, -0.5f, 0);
            vertices[0].TextureCoordinate.X = UV.X;
            vertices[0].TextureCoordinate.Y = UV.Y;
            vertices[1].Position = new Vector3(0.5f, -0.5f, 0);
            vertices[1].TextureCoordinate.X = UV.X + UVSize.X;
            vertices[1].TextureCoordinate.Y = UV.Y;
            vertices[2].Position = new Vector3(-0.5f, 0.5f, 0);
            vertices[2].TextureCoordinate.X = UV.X;
            vertices[2].TextureCoordinate.Y = UV.Y + UVSize.Y;
            vertices[3].Position = new Vector3(0.5f, 0.5f, 0);
            vertices[3].TextureCoordinate.X = UV.X + UVSize.X;
            vertices[3].TextureCoordinate.Y = UV.Y + UVSize.Y;

            for (int i = 0; i < 4; i++)
            {
                vertices[i].Color = new Color(255, 255, 255, 255);
            }


            // エフェクトの使用を開始します
            basicEffect.Begin();

            //基本的なポリラインの描画
            // 描画する頂点データの定義を設定
            GrfDevice.VertexDeclaration = GameManager.GetGameManager().vertexDeclaration;




            //アルファブレンドを有効にする
            GrfDevice.RenderState.AlphaBlendEnable = true;

            //アルファブレンドの合成方法を設定する(注意２)
            GrfDevice.RenderState.SourceBlend = Blend.SourceAlpha;
            GrfDevice.RenderState.DestinationBlend = Blend.One;



            // パスの数だけ繰り替えし描画 (といっても BasicEffect は通常１回)
            for (int i = 0; i < basicEffect.CurrentTechnique.Passes.Count; i++)
            {
                EffectPass pass = basicEffect.CurrentTechnique.Passes[i];
                // パスの開始
                pass.Begin();

                //Zバッファを有効にする
                GrfDevice.RenderState.DepthBufferEnable = true;
                GrfDevice.RenderState.DepthBufferWriteEnable = false;


                if (Tex != null)
                {
                    basicEffect.TextureEnabled = true;
                    basicEffect.Texture = Tex;
                }
                basicEffect.LightingEnabled = false;
                basicEffect.VertexColorEnabled = true;

                // ポリゴンを描画する

                GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice.RenderState.CullMode = CullMode.None;
                GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice.RenderState.DepthBufferEnable = true;
                GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice.RenderState.DepthBufferWriteEnable = false;
                Matrix CamMat = CamManager.GetCamManager().GetNowCamera().GetMatrix();

                // ビュー座標変換行列
                Matrix view = CamMat;

                // 射影変換行列
                Matrix projection = CamManager.GetCamManager().GetNowCamera().GetProj();

                basicEffect.View = view;
                view.Translation = Vector3.Zero;
                Matrix inv = Matrix.Invert(view);
                basicEffect.World = Matrix.CreateRotationZ(fRot) * inv * Matrix.CreateScale(fScale) * Matrix.CreateTranslation(Pos);
                //basicEffect.World = Matrix.CreateRotationZ(fRot) * inv * Matrix.CreateScale(fScale) * Matrix.CreateTranslation(Pos);
                basicEffect.Projection = projection;

                basicEffect.CommitChanges();

                basicEffect.Alpha = fAlpha;

                GrfDevice.DrawUserPrimitives<VertexPositionColorTexture>(
                    PrimitiveType.TriangleStrip,
                    vertices,
                    0,
                    2
                );


                // パスの終了
                pass.End();
            }

            // エフェクトの使用を終了する
            basicEffect.End();
        }
    }
}
