﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsGame1;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace FrkEffectViewer.GameSystem
{
    class CreatePointObj : GameObject3D
    {
        public int MoveType = 0;
        public float MoveSpd = 1.0f;
        float rad = 0.0f;
        public CreatePointObj()
        {
            this.Pos = new Vector3();
            this.Qua = Quaternion.Identity;
        }
        public override bool Main()
        {
            rad += MoveSpd * 0.01f;

            if (MoveType == 0 || MoveType >= 5)
            {
                Qua = Quaternion.Identity;
                if (MoveType >= 5)
                {
                    Pos.Z = MathHelper.Lerp(-5.0f,5.0f,rad % 1.0f);
                }
                else
                {
                    Pos = Vector3.Zero;
                }
                return false;
            }
            
            Vector3 work = Vector3.Zero;
             switch(MoveType)
            {
                case 1:
                    Qua = Quaternion.CreateFromYawPitchRoll(0, rad, 0);
                    work = Matrix.CreateFromQuaternion(Qua).Up;
                    break;
                case 2:
                    Qua = Quaternion.CreateFromYawPitchRoll(rad, 0, 0);
                    work = Matrix.CreateFromQuaternion(Qua).Forward;
                    Qua *= Quaternion.CreateFromYawPitchRoll(MathHelper.ToRadians(-90), 0, 0);
                    break;
                case 3:
                    Qua = Quaternion.CreateFromYawPitchRoll(0, 0, rad);
                    work = Matrix.CreateFromQuaternion(Qua).Up;
                    Qua *= Quaternion.CreateFromYawPitchRoll(MathHelper.ToRadians(-90), 0, 0);
                    break;
                case 4:
                    Qua = Quaternion.CreateFromYawPitchRoll(rad, 0, 0);
                    work = Matrix.CreateFromQuaternion(Qua).Forward;
                    Qua *= Quaternion.CreateFromYawPitchRoll(MathHelper.ToRadians(-90), 0, rad);
                    break;
            }

            Pos = work*3.0f;
            return false;
        }
        public override void Draw()
        {
            VertexPositionColorTexture[] vertices = new VertexPositionColorTexture[6];

            float s = 0.5f;
            Scale = new Vector3(s, s, s);

            vertices[0].Position = new Vector3(0, 0, 0);
            vertices[0].Color = Color.Red;
            vertices[1].Position = new Vector3(Scale.X, 0, 0);
            vertices[1].Color = Color.Red;
            vertices[2].Position = new Vector3(0, 0, 0);
            vertices[2].Color = Color.Green;
            vertices[3].Position = new Vector3(0, Scale.Y, 0);
            vertices[3].Color = Color.Green;
            vertices[4].Position = new Vector3(0, 0, 0);
            vertices[4].Color = Color.Blue;
            vertices[5].Position = new Vector3(0, 0, Scale.Z);
            vertices[5].Color = Color.Blue;



            // エフェクトの使用を開始します
            basicEffect.Begin();

            //基本的なポリラインの描画
            // 描画する頂点データの定義を設定
            GrfDevice.VertexDeclaration = GameManager.GetGameManager().vertexDeclaration;




            //アルファブレンドを有効にする
            GrfDevice.RenderState.AlphaBlendEnable = false;

            // パスの数だけ繰り替えし描画 (といっても BasicEffect は通常１回)
            for (int i = 0; i < basicEffect.CurrentTechnique.Passes.Count; i++)
            {
                EffectPass pass = basicEffect.CurrentTechnique.Passes[i];
                // パスの開始
                pass.Begin();

                //Zバッファを有効にする
                GrfDevice.RenderState.DepthBufferEnable = true;
                GrfDevice.RenderState.DepthBufferWriteEnable = false;

                basicEffect.TextureEnabled = false;
                basicEffect.Texture = null;

                basicEffect.LightingEnabled = false;
                basicEffect.VertexColorEnabled = true;

                // ポリゴンを描画する

                GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice.RenderState.CullMode = CullMode.None;
                GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice.RenderState.DepthBufferEnable = true;
                GameMain.Grf.GetGraphicsDeviceManager().GraphicsDevice.RenderState.DepthBufferWriteEnable = false;
                Matrix CamMat = CamManager.GetCamManager().GetNowCamera().GetMatrix();

                // ビュー座標変換行列
                Matrix view = CamMat;

                // 射影変換行列
                Matrix projection = CamManager.GetCamManager().GetNowCamera().GetProj();

                basicEffect.View = view;
                basicEffect.World = Matrix.CreateFromQuaternion(Qua) * Matrix.CreateTranslation(Pos);
                basicEffect.Projection = projection;

                basicEffect.CommitChanges();

                basicEffect.Alpha = 1.0f;

                GrfDevice.DrawUserPrimitives<VertexPositionColorTexture>(
                    PrimitiveType.LineList,
                    vertices,
                    0,
                    3
                );


                // パスの終了
                pass.End();
            }

            // エフェクトの使用を終了する
            basicEffect.End();
        }
    }
}
