#include "testmod.h"
#include <stdio.h>

// You must set the following AHB address according to your system
// This sample address is for leon3-gr-xc3s-1500-mjpeg
#define HSADDR 0xa0000000
#define HPADDR 0x80000c00
#define IOADDR 0x80000800

static unsigned int indata[80] ={
0x00317d85,0x00317d85,0x00307d85,0x00307d85,0x002f7f84,0x002e7f84,0x002d8083,0x002d8082,
0x002e8182,0x002e8181,0x002e8280,0x002e8280,0x002d827f,0x002c827f,0x002b827f,0x002b8280,
0x002b8283,0x002b8284,0x002b8284,0x002b8284,0x002b8183,0x002b8183,0x002b8082,0x002b8082,
0x002e8082,0x002e8082,0x002e7f81,0x002e7f81,0x002f7e81,0x002f7e81,0x002f7e80,0x002f7f80,
0x002e8082,0x002e8182,0x002e8082,0x002e8082,0x002e7f83,0x002e7f83,0x002e7e84,0x002e7e84,
0x00307d85,0x00317c85,0x00317c86,0x00337b86,0x00347a86,0x00357a86,0x00367a87,0x00367a86,
0x00377c85,0x00387c84,0x00397b84,0x00397b84,0x00387b85,0x00377b85,0x00357b86,0x00347b86,
0x00347b86,0x00347b86,0x00337b86,0x00327b86,0x00327c86,0x00337c86,0x00347d86,0x00347c85,
0x00387b85,0x00357a87,0x00387b8d,0x00397b92,0x00357c96,0x00357c96,0x00357d93,0x00317d8d,
0x00337d87,0x00327c83,0x00337c82,0x00357a86,0x00387a8e,0x003d7996,0x0042789f,0x004578a3
};

struct yrsreg {
  volatile unsigned int fbadd;
  volatile unsigned int sizeinfo;
  volatile unsigned int incadd;
  volatile unsigned int reset;
}

  yccrgbs_connect(){
    struct yrsreg *sreg = (struct yrsreg *) HPADDR;
    volatile unsigned int *dataad = (unsigned int *)HSADDR;
    unsigned int rdata;
    volatile unsigned int *raddr; 
    int i,j;
    unsigned int *allocadd;
    volatile unsigned int *ioaddr = (unsigned int *)IOADDR;
    unsigned int iodata;

    allocadd = (unsigned int *)memalign(1024, 2*640*480);
    if (allocadd == NULL) fail(0);

    sreg->fbadd = (unsigned int) allocadd;
    sreg->sizeinfo = 0x028001e0;
    sreg->incadd = 0x0;
    sreg->reset = 0xffffffff;

    for(i=0;i<80;i++){
      *dataad = indata[i];
    }

    for(i=0; i<300; i++){}

    raddr = allocadd; 
    *(ioaddr + 2) = 0xffffffff;
    *(ioaddr + 3) = 0x00000000;
    *(ioaddr + 1) = 0x0000aaaa; 

   for(i=0;i<40;i++){
      rdata = *raddr;
      iodata = (rdata & 0x0000ffff) | 0x00010000;
      *(ioaddr + 1) = iodata;
      *(ioaddr + 1) = 0x0000aaaa;
      iodata = (rdata & 0xffff0000) >> 16;
      iodata = iodata | 0x00010000;
      //   iodata = rdata;
      *(ioaddr + 1) = iodata;
      *(ioaddr + 1) = 0x0000aaaa;
      raddr++;
    }
  }
