
###############################################################
#
# eX command script, (C) 2007 eASIC Corp.
# Automatically generated by CDB
#
# $Id: etools_fe.pm,v 1.17 2008/04/04 13:37:18 richard Exp $
###############################################################

set my_home $env(EX_HOME)
source ../../../env.tcl
source $my_home/scripts/genDesignDataFile.tcl
source $my_home/scripts/genLibMap.tcl

logging attach console
logging attach file ex.log
logging level set drc.rtlentry.eclkgateimpl INFO
logging setmsgcount --logname=udesign.tclscript       --maxcount=5000
logging setmsgcount --logname=drc.all.gendd.warn      --maxcount=5000
logging setmsgcount --logname=drc.all.portpropagation --maxcount=5000
logging setmsgcount --logname=drc.all.undrivennet     --maxcount=5000

puts "############### Starting project file add ###############"
project new ${design}
if [info exists verilogList] {
	project hdloptions -verilog -v $my_home/data/dw_comp.v
	foreach f $verilogList { eval project file add -rtl_verilog $f }
}
if [info exists vhdlList] {
# HMS - modification to simplify the usage of VHDL libraries
	file delete -force work
	file mkdir work
	foreach f $vhdlList {
	    set libspace [string first " " $f]
	    if {$libspace == -1} {
		eval project file add $f
	    } else {
		set lib [string range $f 0 [expr $libspace - 1]]
		file delete -force $lib
		file mkdir $lib
		eval project file add -libmap $f
	    }
	}

	#automatically handle VHDL packages
#	set revised {}
#	::easic::ex_libmap $vhdlList revised
#	set num [llength $revised]
#	set cnt [expr $num - 1]
#	for {set i 0} {$i < $cnt} {incr i} {
#		set libfs [lindex $revised $i]
#		set lib   [lindex $libfs 0]
#		set fs    [lindex $libfs 1]
#		file delete -force $lib
#		file mkdir $lib
#		eval project file add -libmap $lib $fs
#	}
#	set nonlibfs [lindex $revised $cnt]
#	foreach f $nonlibfs { eval project file add -rtl_vhdl $f }
}

# eASIC Library
if {[file exists $env(ETOOLS_HOME)/ip_lib]} {
    foreach lib [glob -nocomplain $env(ETOOLS_HOME)/ip_lib/*] {
      if {[file isdirectory $lib]} {
          foreach macro [glob -nocomplain $lib/*] {
            #add macro design files
            if {[file exists $macro/src/rtl/verilog]} {
                eval project hdloptions -verilog -y $macro/src/rtl/verilog +libext+.v+
            }
            if {[file exists $macro/src/rtl/vhdl]} {
		#VHDL not supported yet, so this really is a placeholder
# HMS - removed since it caused errors
           #     eval project hdloptions -vhdl -y $macro/src/rtl/vhdl
            }
          } ;#next macro
      }
    } ;#next lib
}

# Include files
if [info exists defineList] {
	foreach def $defineList { eval project hdloptions -verilog +define+${def}+ }
}
if [info exists includeList] {
	foreach inc $includeList { eval project hdloptions -verilog +incdir+${inc}+ }
}

if {$top_hdl == "vhdl"} {
   # attempt to sort VHDL files in the right order
   # caution: this is not guaranteed to always work
   project hdloptions -$top_hdl -sort
}

puts "############### Starting prepare syn    ###############"
project nomdata flat
prepare syn -disable_memory_detect -top $design 
puts "############### Finished prepare syn    ###############\n"

puts "############### Starting export ewizard ###############"
set top [lindex [nomdata proplist FLAT_TOPNAME] 0]
set filename ../../out/${design}.dd
set fileId [open $filename "w"]
generateInterFile $top $fileId
#close $fileId
puts "############### Finished export ewizard ###############\n"

puts "############### Starting report netlist ###############"
report netlist -file ../rpt/ex_premap_netlist.rpt
puts "############### Finished report netlist ###############\n"

puts "############### Starting export verilog ###############"
export verilog ../../out/ex_${design}.v
puts "############### Finished export verilog ###############\n"

puts "############### Starting report clock   ###############"
report clock --format=xml --file=../rpt/ex_clock.xml
puts "############### Finished report clock   ###############\n"

puts "############### Starting report memory  ###############"
#report memory --format=xml -file ../rpt/ex_memory.xml
#report memory -file ../rpt/ex_memory.rpt
puts "############### Finished report memory  ###############\n"

puts "############### Starting report netlist ###############"
report netlist -file ../rpt/ex_netlist.rpt
puts "############### Finished report netlist ###############\n"

puts "############### Starting checks         ###############"
logging attach file --format=xml ../rpt/ex_log.xml
check
logging detach file ../rpt/ex_log.xml
puts "############### Finished checks         ###############\n"

#puts "############### Starting eSyn ###############"
#esyn map
#report netlist -file ../rpt/ex_map_netlist.rpt
#puts "############### Finished eSyn ###############\n"

puts "
===========================
  eX finished
===========================
"

exit
