﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.VisualStudio.TestPlatform.UnitTestFramework;
using UITest = Microsoft.VisualStudio.TestPlatform.UnitTestFramework.AppContainer;
using FooEditor;
using FooEditEngine.Metro;

namespace UnitTest
{
    [TestClass]
    public class AppTest
    {
        [TestMethod]
        public void LineJumpTest()
        {
            LineJumpViewModel vm = new LineJumpViewModel(new LineJumpView());
            vm.ToRow = 2;
            Assert.IsTrue(!vm.JumpCaretCommand());
            vm.ToRow = 0;
            Assert.IsTrue(vm.JumpCaretCommand());
            vm.ToRow = 3;
            Assert.IsTrue(vm.JumpCaretCommand());
        }

        [TestMethod]
        public void FindFlyoutTest()
        {
            FindFlyoutViewModel vm = new FindFlyoutViewModel(new FindFlyoutView());
            vm.FindHistroy = new System.Collections.ObjectModel.ObservableCollection<string>();

            //検索実行時に対象パターンが検索履歴に追加されるかを調べる
            const string Pattern = "foo";
            vm.FindPattern = Pattern;
            vm.FindNextCommand.Execute(null);
            Assert.IsTrue(vm.FindHistroy.Contains(Pattern));

            //全置換え実行時に対象パターンが検索履歴に追加されるかを調べる
            const string Pattern1 = "bar";
            vm.FindPattern = Pattern1;
            vm.ReplacePattern = string.Empty;
            vm.ReplaceAllCommand.Execute(null);
            Assert.IsTrue(vm.FindHistroy.Contains(Pattern));

            //検索履歴から選択したパターンが検索パターンになるかどうか            
            vm.SelectedFindPattern = Pattern;
            Assert.IsTrue(vm.FindPattern == Pattern);
        }
    }

    class LineJumpView : ILineJumpView
    {

        public int CaretPostionRow
        {
            get { return 0; }
        }

        public int AvailableMaxRow
        {
            get { return 2; }
        }

        public void JumpCaret(int row)
        {
            return;
        }
    }

    class FindFlyoutView : IFindView
    {
        public void FindNext(string pattern, bool useregex, System.Text.RegularExpressions.RegexOptions opt)
        {
        }

        public void Replace(string newpattern, bool usegroup)
        {
        }

        public void ReplaceAll(string pattern, string newpattern, bool usegroup, bool useregex, System.Text.RegularExpressions.RegexOptions opt)
        {
        }

        public void Reset()
        {
        }
    }
}
