﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using System.Windows.Input;

namespace FooEditor
{
    class FileTypesFlyoutViewModel : ViewModelBase
    {
        ObservableCollection<FileType> _FileTypeCollection;
        public ObservableCollection<FileType> FileTypeCollection
        {
            get
            {
                return this._FileTypeCollection;
            }
            set
            {
                this._FileTypeCollection = value;
                this.OnPropertyChanged();
            }
        }

        public ICommand ShowDetailCommand
        {
            get
            {
                return new DelegateCommand<FileType>((e) =>
                {
                    var flyout = new FileTypeDetailFlyout(e);
                    flyout.Show();
                });
            }
        }
    }
}
