﻿using System;
using System.ComponentModel;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using System.Runtime.CompilerServices;
using FooEditEngine.Metro;

// ユーザー コントロールのアイテム テンプレートについては、http://go.microsoft.com/fwlink/?LinkId=234236 を参照してください

namespace FooEditor
{
    public sealed partial class GoToFlyout : UserControl
    {
        LineJumpViewModel model;
        public GoToFlyout()
        {
            this.InitializeComponent();
            this.DataContext = this;
        }

        public GoToFlyout(FooTextBox textbox)
            :this()
        {
            this.model = new LineJumpViewModel(textbox);
            this.DataContext = this.model;
        }

        private void Button_Click(object sender, Windows.UI.Xaml.RoutedEventArgs e)
        {
            var loader = new Windows.ApplicationModel.Resources.ResourceLoader();
            if (this.model.JumpCaretCommand())
            {
                this.model.Result = string.Format(loader.GetString("LineNumberOutOutOfRange"), this.model.MaxRow);
                return;
            }
            Popup parent = this.Parent as Popup;
            if (parent != null)
                parent.IsOpen = false;
        }
    }
}
