﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.VisualStudio.TestPlatform.UnitTestFramework;
using UITest = Microsoft.VisualStudio.TestPlatform.UnitTestFramework.AppContainer;
using FooEditor;
using FooEditEngine.Metro;

namespace UnitTest
{
    [TestClass]
    public class AppTest
    {
        [UITest.UITestMethod]
        public void LineJumpTest()
        {
            FooTextBox textbox = new FooTextBox();
            textbox.Document.Append("this is a pen\nhello world");
            LineJumpViewModel vm = new LineJumpViewModel(textbox);
            vm.ToRow = 2;
            Assert.IsTrue(!vm.JumpCaretCommand());
            vm.ToRow = 0;
            Assert.IsTrue(vm.JumpCaretCommand());
            vm.ToRow = 3;
            Assert.IsTrue(vm.JumpCaretCommand());
        }
        [UITest.UITestMethod]
        public void FindTest()
        {
            FooTextBox textbox = new FooTextBox();
            textbox.Document.Append("html\nhello\ntxt");
            FindFlyoutViewModel vm = new FindFlyoutViewModel(textbox);
            vm.FindPattern = "html";
            vm.FindNextCommand.Execute(null);
            Assert.IsTrue(textbox.SelectedText == "html");
            vm.FindNextCommand.Execute(null);
            Assert.IsTrue(!string.IsNullOrEmpty(vm.Result));

            vm = new FindFlyoutViewModel(textbox);
            vm.FindPattern = "Html";
            vm.RestrictSearch = true;
            vm.FindNextCommand.Execute(null);
            Assert.IsTrue(!string.IsNullOrEmpty(vm.Result));

            vm = new FindFlyoutViewModel(textbox);
            vm.FindPattern = "h[a-z]+";
            vm.UseRegEx = true;
            vm.FindNextCommand.Execute(null);
            Assert.IsTrue(textbox.SelectedText == "html");
            vm.FindNextCommand.Execute(null);
            Assert.IsTrue(textbox.SelectedText == "hello");
            vm.FindNextCommand.Execute(null);
            Assert.IsTrue(!string.IsNullOrEmpty(vm.Result));

            vm = new FindFlyoutViewModel(textbox);
            vm.FindPattern = "H[a-z]+";
            vm.UseRegEx = true;
            vm.RestrictSearch = true;
            vm.FindNextCommand.Execute(null);
            Assert.IsTrue(!string.IsNullOrEmpty(vm.Result));
        }
        [UITest.UITestMethod]
        public void ReplaceTest()
        {
            FooTextBox textbox = new FooTextBox();
            textbox.Document.Append("html\nhello\ntxt");
            FindFlyoutViewModel vm = new FindFlyoutViewModel(textbox);
            vm.FindPattern = "html";
            vm.ReplacePattern = "test";
            vm.FindNextCommand.Execute(null);
            vm.ReplaceNextCommand.Execute(null);
            textbox.Select(0, 4);
            Assert.IsTrue(textbox.SelectedText == "test");
        }

        [UITest.UITestMethod]
        public void ReplaceAllTest()
        {
            FooTextBox textbox = new FooTextBox();
            textbox.Document.Append("html\nhello\ntxt");
            FindFlyoutViewModel vm = new FindFlyoutViewModel(textbox);
            vm.FindPattern = "html";
            vm.ReplacePattern = "test";
            vm.ReplaceAllCommand.Execute(null);
            textbox.Select(0, 4);
            Assert.IsTrue(textbox.SelectedText == "test");

            textbox.Document.Clear();
            textbox.Document.Append("html\nhello\ntxt");
            vm = new FindFlyoutViewModel(textbox);
            vm.FindPattern = "h[a-z]+";
            vm.ReplacePattern = "test";
            vm.UseRegEx = true;
            vm.ReplaceAllCommand.Execute(null);
            Assert.IsTrue(
                textbox.LayoutLineCollection[0] == "test\n" &&
                textbox.LayoutLineCollection[1] == "test\n" &&
                textbox.LayoutLineCollection[2] == "txt");
        }
    }
}
