﻿using System;
using System.Collections.Generic;
using System.Xml;
using SinnpetPlugin.Properties;

namespace SinnpetPlugin
{
    class SinppetCollection
    {
        Dictionary<string, string> Items;

        /// <summary>
        /// 定型文を収めたファイルへのフルパス
        /// </summary>
        /// <param name="path"></param>
        public SinppetCollection(string path)
        {
            this.Items = new Dictionary<string, string>();
            XmlDocument xml = new XmlDocument();

            xml.Load(path);
            XmlNodeList nodes = xml.GetElementsByTagName("sinppet");

            foreach (XmlNode node in nodes)
            {
                string name = null, data = null;
                foreach (XmlNode child in node.ChildNodes)
                {
                    switch (child.LocalName)
                    {
                        case "name":
                            name = child.InnerText;
                            break;
                        case "data":
                            data = Util.Replace(child.InnerText,new string[]{"\t","\n","\r","\\n"},new string[]{"","","","\r\n"});
                            break;
                    }
                }
                if (name == null || data == null)
                    throw new Exception(string.Format(Resources.IsNotPair,name,data,path));
                this.Items.Add(name, data);
            }
            return;
        }

        /// <summary>
        /// 保持しているキーのリスト
        /// </summary>
        public IEnumerable<string> Keys
        {
            get
            {
                foreach (string s in this.Items.Keys)
                    yield return s;
            }
        }

        /// <summary>
        /// インデクサー
        /// </summary>
        /// <param name="s">キー</param>
        /// <returns>キーと対になる値</returns>
        public string this[string s]
        {
            get
            {
                return this.Items[s];
            }
        }
    }
}
