﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using SharpDX;
using D2D = SharpDX.Direct2D1;
using DW = SharpDX.DirectWrite;

namespace FooEditEngine
{
    interface IMarkerEffecter
    {
        void Apply(D2D.RenderTarget render, MyTextLayout layout, int index, int length, double x, double y);
    }

    class SquilleLineMarker : IMarkerEffecter
    {
        D2D.SolidColorBrush brush;
        D2D.StrokeStyle stroke;
        float thickness;
        public SquilleLineMarker(DrawingEffect effect, float thickness)
        {
            this.brush = effect.ForeBrush;
            this.stroke = effect.Stroke;
            this.thickness = thickness;
        }
        public void Apply(D2D.RenderTarget render, MyTextLayout layout, int start, int length, double x, double y)
        {
            render.AntialiasMode = D2D.AntialiasMode.Aliased;

            DW.HitTestMetrics[] metrics = layout.HitTestTextRange(start, length, (float)x, (float)y);
            foreach (DW.HitTestMetrics metric in metrics)
            {
                this.DrawSquilleLine(render, metric.Left, metric.Top, metric.Width, metric.Height);
            }

            render.AntialiasMode = D2D.AntialiasMode.PerPrimitive;
        }

        void DrawSquilleLine(D2D.RenderTarget render,float x,float y,float width,float height)
        {
            float lineWidthSize = Util.RoundUp(height / 24) + 1;
            float lineLength = lineWidthSize + (lineWidthSize * 4);
            float waveHeight = Util.RoundUp(height / 12) + 1;
            float lineSpacing = lineWidthSize * 8;

            float valleyY = Util.RoundUp(y + height);
            float ridgeY = valleyY - waveHeight;
            float endX = x + width - 1;
            for (; x < endX; x += (waveHeight * 2))
            {
                float ridgeX = x + waveHeight;
                float valleyX = ridgeX + waveHeight;
                if (ridgeX <= endX)
                    render.DrawLine(new DrawingPointF(x, valleyY), new DrawingPointF(ridgeX, ridgeY), this.brush, this.thickness, this.stroke);
                if (valleyX <= endX)
                    render.DrawLine(new DrawingPointF(ridgeX, ridgeY), new DrawingPointF(valleyX, valleyY), this.brush, this.thickness, this.stroke);
            }
        }
    }

    class LineMarker : IMarkerEffecter
    {
        D2D.SolidColorBrush brush;
        D2D.StrokeStyle stroke;
        float thickness;
        public LineMarker(DrawingEffect effect,float thickness)
        {
            this.brush = effect.ForeBrush;
            this.stroke = effect.Stroke;
            this.thickness = thickness;
        }

        public void Apply(D2D.RenderTarget render, MyTextLayout layout, int start, int length, double x, double y)
        {
            render.AntialiasMode = D2D.AntialiasMode.Aliased;

            DW.HitTestMetrics[] metrics = layout.HitTestTextRange(start, length, (float)x, (float)y);
            foreach (DW.HitTestMetrics metric in metrics)
            {
                render.DrawLine(new DrawingPointF(metric.Left, metric.Top + metric.Height),
                    new DrawingPointF(metric.Left + metric.Width - 1, metric.Top + metric.Height),
                    this.brush,
                    this.thickness,
                    this.stroke);
            }

            render.AntialiasMode = D2D.AntialiasMode.PerPrimitive;
        }
    }

    class HilightMarker : IMarkerEffecter
    {
        D2D.SolidColorBrush brush;
        public HilightMarker(D2D.SolidColorBrush brush)
        {
            this.brush = brush;
        }

        public void Apply(D2D.RenderTarget render, MyTextLayout layout, int start, int length, double x, double y)
        {
            render.AntialiasMode = D2D.AntialiasMode.Aliased;

            DW.HitTestMetrics[] metrics = layout.HitTestTextRange(start, length, (float)x, (float)y);
            foreach (DW.HitTestMetrics metric in metrics)
            {
                render.FillRectangle(new RectangleF(metric.Left, metric.Top, metric.Left + metric.Width, metric.Top + metric.Height), brush);
            }

            render.AntialiasMode = D2D.AntialiasMode.PerPrimitive;
        }
    }
}
