﻿using System;
using SharpDX;
using D2D = SharpDX.Direct2D1;
using DW = SharpDX.DirectWrite;

namespace FooEditEngine
{
    class InlineChar : DW.InlineObject
    {
        DW.TextLayout Layout;
        public InlineChar(DW.TextLayout layout)
        {
            this.Layout = layout;
        }

        public virtual void Draw(object clientDrawingContext, DW.TextRenderer renderer, float originX, float originY, bool isSideways, bool isRightToLeft, ComObject clientDrawingEffect)
        {
            D2D.RenderTarget render = clientDrawingContext as D2D.RenderTarget;
            if (render == null)
                return;

            D2D.SolidColorBrush brush = clientDrawingEffect as D2D.SolidColorBrush;
            if (brush == null)
                return;

            render.DrawTextLayout(
                new DrawingPointF(originX, originY),
                this.Layout,
                brush);
        }

        public virtual void GetBreakConditions(out DW.BreakCondition breakConditionBefore, out DW.BreakCondition breakConditionAfter)
        {
            breakConditionAfter = DW.BreakCondition.CanBreak;
            breakConditionBefore = DW.BreakCondition.CanBreak;
        }

        public virtual DW.InlineObjectMetrics Metrics
        {
            get
            {
                DW.InlineObjectMetrics value = new DW.InlineObjectMetrics();
                value.Height = this.Layout.Metrics.Height;
                value.Width = this.Layout.Metrics.Width;
                DW.LineMetrics[] lines = this.Layout.GetLineMetrics();
                value.Baseline = lines[0].Baseline;
                return value;
            }
        }

        public virtual DW.OverhangMetrics OverhangMetrics
        {
            get
            {
                DW.OverhangMetrics value = new DW.OverhangMetrics();
                DW.TextMetrics metrics = this.Layout.Metrics;
                value.Left = metrics.Left;
                value.Right = metrics.Left + metrics.Width;
                value.Top = metrics.Top;
                value.Bottom = metrics.Top + metrics.Height;
                return value;
            }
        }

        public virtual IDisposable Shadow
        {
            get;
            set;
        }

        public virtual void Dispose()
        {
            return;
        }
    }

    class InlineTab : InlineChar
    {
        int TabCount;
        public InlineTab(DW.TextLayout layout,int count)
            : base(layout)
        {
            this.TabCount = count;
        }

        public override DW.InlineObjectMetrics Metrics
        {
            get
            {
                DW.InlineObjectMetrics value = base.Metrics;
                value.Width *= TabCount;
                return value;
            }
        }
    }
}
