﻿using System;
using System.Text;
using System.Text.RegularExpressions;

namespace FooEditEngine
{
    struct TextRange
    {
        public int start;
        public int length;
        public TextRange(int start, int length)
        {
            this.start = start;
            this.length = length;
        }
    }

    class ReplaceCommand : ICommand
    {
        StringBuffer Buffer;
        TextRange ReplacementRange, ReplacedRange;
        StringBuilder replacement, replaced;   //置き換え後の文字列、置き換え前の文字列
        /// <summary>
        /// コンストラクター
        /// </summary>
        /// <param name="doc"></param>
        /// <param name="ctrl"></param>
        /// <param name="start">置き換える範囲の開始位置</param>
        /// <param name="end">置き換える範囲の終了位置</param>
        /// <param name="str">置き換え後の文字列</param>
        public ReplaceCommand(StringBuffer buf, int start, int length, string str)
        {
            this.Buffer = buf;
            this.ReplacementRange = new TextRange(start,str.Length);
            this.replacement = new StringBuilder(str);
            this.ReplacedRange = new TextRange(start,length);
            this.replaced = new StringBuilder(this.Buffer.ToString(start, length));
        }

        #region ICommand メンバー

        public void undo()
        {
            this.Buffer.Replace(this.ReplacementRange.start, this.replacement.Length,this.replaced.ToString());
        }

        public void redo()
        {
            this.Buffer.Replace(this.ReplacedRange.start, this.replaced.Length,this.replacement.ToString());
        }

        public bool marge(ICommand a)
        {
            ReplaceCommand cmd = a as ReplaceCommand;
            if (cmd == null || cmd.ReplacementRange.length > 0 && cmd.replacement[0] == Document.NewLine)
                return false;
            if (this.ReplacedRange.start + this.ReplacementRange.length == cmd.ReplacedRange.start && 
                this.ReplacedRange.start == this.ReplacementRange.start)
            {
                this.replaced.Append(cmd.replaced);
                this.replacement.Append(cmd.replacement);
                this.ReplacedRange.length += cmd.ReplacedRange.length;
                this.ReplacementRange.length += cmd.ReplacementRange.length;
                return true;
            }
            return false;
        }

        #endregion

    }

    class ReplaceAllCommand : ICommand
    {
        StringBuffer buffer;
        Regex regex;
        string oldBuffer;
        string replacePattern;
        public ReplaceAllCommand(StringBuffer buffer, Regex regex, string replacePattern)
        {
            this.buffer = buffer;
            this.regex = regex;
            this.replacePattern = replacePattern;
        }

        public void undo()
        {
            this.buffer.Clear();

            this.buffer.Replace(0, 0, this.oldBuffer);
        }

        public void redo()
        {
            this.oldBuffer = this.buffer.ToString(0,this.buffer.Length).Trim(Document.EndOfFile).Trim(Document.EndOfFile);

            StringBuilder result = new StringBuilder();
            foreach (string line in Util.GetLines(this.buffer, 0, this.buffer.Length - 1))
            {
                string output = this.regex.Replace(line, (m) => { return m.Result(this.replacePattern); });
                result.Append(output);
            }

            this.buffer.Clear();
            
            this.buffer.Replace(0, 0, result.ToString());
        }

        public bool marge(ICommand a)
        {
            return false;
        }
    }
}
