﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using FooEditEngine;

namespace UnitTest
{
    [TestClass]
    public class FoldingCollectionTest
    {
        [TestMethod]
        public void TestMethod1()
        {
            FoldingCollection collection = new FoldingCollection();
            collection.Add(new FoldingItem(0, 10));
            collection.Add(new FoldingItem(1, 5));
            collection.Add(new FoldingItem(11, 12));
            FoldingItem item = collection.Get(2, 1);
            Assert.IsTrue(item.Start == 1 && item.End == 5);
        }

        [TestMethod]
        public void TestMethod2()
        {
            FoldingCollection collection = new FoldingCollection();
            FoldingItem item = new FoldingItem(0, 10);
            item.Expand = false;
            collection.Add(item);
            collection.Add(new FoldingItem(1, 5));
            collection.Add(new FoldingItem(11,12));
            item = collection.GetFarestHiddenFoldingData(2, 1);
            Assert.IsTrue(item.Start == 0 && item.End == 10);
        }

        [TestMethod]
        public void TestMethod3()
        {
            FoldingCollection collection = new FoldingCollection();
            collection.Add(new FoldingItem(0, 10));
            collection.Add(new FoldingItem(1, 5));
            collection.Add(new FoldingItem(11, 12));
            foreach (FoldingItem item in collection.GetRange(0, 10))
                Assert.IsTrue((item.Start != 11 && item.End != 12));
        }

        [TestMethod]
        public void TestMethod4()
        {
            FoldingCollection collection = new FoldingCollection();
            FoldingItem newItem = new FoldingItem(0,10);
            collection.Add(newItem);
            collection.Add(new FoldingItem(1, 5));
            collection.Add(new FoldingItem(11, 12));
            collection.Collapse(newItem);
            foreach (FoldingItem item in collection.GetRange(0, 10))
                Assert.IsFalse(item.Expand);
        }

        [TestMethod]
        public void TestMethod5()
        {
            FoldingCollection collection = new FoldingCollection();
            collection.Add(new FoldingItem(0, 10));
            FoldingItem newItem = new FoldingItem(1, 5);
            collection.Add(newItem);
            collection.Add(new FoldingItem(11, 12));
            collection.Expand(newItem);
            foreach (FoldingItem item in collection.GetRange(0, 10))
                Assert.IsTrue(item.Expand);
        }
    }
}
