#include "DRenderBase.h"

using namespace DWriteWarpper;
using namespace System::ComponentModel;

DRenderBase::DRenderBase(void)
{
}

DRenderBase::DRenderBase(ID2D1RenderTarget* render)
{
	if(render == NULL)
		throw gcnew ArgumentNullException("render is NULL");
	pRT_ = render;
	pTextRender_ = NULL;
	disposed = false;
}

ID2D1RenderTarget* DRenderBase::render::get()
{
	return this->pRT_;
}

DAntialias DRenderBase::AntialiasMode::get()
{
	return (DAntialias)pRT_->GetAntialiasMode();
}

void DRenderBase::AntialiasMode::set(DAntialias value) {
	pRT_->SetAntialiasMode((D2D1_ANTIALIAS_MODE)value);
}

DTextAntialias DRenderBase::TextAntialiasMode::get()
{
	return (DTextAntialias)pRT_->GetTextAntialiasMode();
}

void DRenderBase::TextAntialiasMode::set(DTextAntialias value)
{
	pRT_->SetTextAntialiasMode((D2D1_TEXT_ANTIALIAS_MODE)value);
}

bool DRenderBase::HasTextRender::get()
{
	return this->pTextRender_ != NULL;
}

void DRenderBase::RemoveControlSymbol(System::Char c)
{
	if(pTextRender_ == NULL)
		throw "pTextRender_ is NULL";
	pTextRender_->RemoveControlSymbol(c);
}

void DRenderBase::AddControlSymbol(System::Char c,unsigned int indic)
{
	if(pTextRender_ == NULL)
		throw "pTextRender_ is NULL";
	pTextRender_->AddControlSymbol(c,indic);
}

void DRenderBase::SetDefalutBrush(DColorBrush^ defalutBrush)
{
	if(pTextRender_ == NULL)
		throw "pTextRender_ is NULL";
	pTextRender_->SetDefalutForeBrush(defalutBrush->brush);
}

void DRenderBase::SetControlBrush(DColorBrush^ controlBrush)
{
	if(pTextRender_ == NULL)
		throw "pTextRender_ is NULL";
	pTextRender_->SetDefalutForeBrush(controlBrush->brush);
}

void DRenderBase::InitTextRender(DColorBrush^ defalutBrush,DColorBrush^ controlBrush)
{
	this->_defalutFore = defalutBrush;
	this->_controlFore = controlBrush;
	CustomTextRenderer* pTextRender = new CustomTextRenderer(this->pRT_,defalutBrush->brush,controlBrush->brush);
	pTextRender_ = pTextRender;
	pTextRender_->AddRef();
}

void DRenderBase::PushAxisAlignedClip(RectF rect,DAntialias mode)
{
	pRT_->PushAxisAlignedClip(D2D1::RectF(rect.Left,rect.Top,rect.Right,rect.Bottom),(D2D1_ANTIALIAS_MODE)mode);
}

void DRenderBase::PopAxisAlignedClip()
{
	pRT_->PopAxisAlignedClip();
}

void DRenderBase::BeginDraw()
{
	pRT_->BeginDraw();
}

bool DRenderBase::EndDraw()
{
	HRESULT hr;
	hr = pRT_->EndDraw();

	if(hr == D2DERR_RECREATE_TARGET)
		return true;
	else if(hr != S_OK)
		throw gcnew Win32Exception(hr,"EndDraw Error");
	return false;
}

void DRenderBase::Flush()
{
	HRESULT hr;
	hr = pRT_->Flush();

	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"Flush Error");

	return;
}

DBitmap^ DRenderBase::CreateBitmap(SizeU size)
{
	ID2D1Bitmap* bitmap;
	D2D1_BITMAP_PROPERTIES prop;

	FLOAT dpix,dpiy;
	pRT_->GetDpi(&dpix,&dpiy);

	prop.pixelFormat = pRT_->GetPixelFormat();
	prop.dpiX = dpix;
	prop.dpiY = dpiy;

	HRESULT hr = pRT_->CreateBitmap(
		D2D1::SizeU(size.Width,size.Height),
		prop,
		&bitmap);

	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"CreateBitmap Error");

	return gcnew DBitmap(bitmap);
}

DColorBrush^ DRenderBase::CreateBrush(Color2F color)
{
	ID2D1SolidColorBrush* foreBrush;

	HRESULT hr = pRT_->CreateSolidColorBrush(
		D2D1::ColorF(color.R,color.G,color.B,color.A),
		&foreBrush);

	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"CreateSoildColorBrush Error");

	return gcnew DColorBrush(foreBrush);
}

void DRenderBase::SetTextRenderingParams(DRenderingParams^ param)
{
	pRT_->SetTextRenderingParams(param->Param);
}

void DRenderBase::DrawBitmap(DBitmap^ bmp,RectF dstRect,float opacity,RectF srcRect)
{
	pRT_->DrawBitmap(bmp->bitmap,
		D2D1::RectF(dstRect.Left,dstRect.Top,dstRect.Right,dstRect.Bottom),
		opacity,
		D2D1_BITMAP_INTERPOLATION_MODE_LINEAR,D2D1::RectF(srcRect.Left,srcRect.Top,srcRect.Right,srcRect.Bottom));
}

void DRenderBase::DrawText(String^ str,DTextFormat^ format,RectF rect,DColorBrush^ foreBrush)
{
	pin_ptr<const WCHAR> chars = PtrToStringChars(str);

	pRT_->DrawText(chars,wcslen(chars),format->dwTextFormat,D2D1::RectF(rect.Left,rect.Top,rect.Right,rect.Bottom),foreBrush->brush);
}

void DRenderBase::DrawTextLayout(DTextLayout^ layout,float x,float y)
{
	HRESULT hr;

	hr = layout->dwTextLayout->Draw(
			NULL,
			pTextRender_,  // Custom text renderer.
			x,
			y
			);

	if(hr != S_OK)
		throw gcnew Win32Exception(hr,"DrawTextLayout Error");
}

void DRenderBase::DrawTextLayout(DTextLayout^ layout,float x,float y,DColorBrush^ defaultForeBrush,DDrawTextOptions options)
{
	pRT_->DrawTextLayout(D2D1::Point2F(x,y),layout->dwTextLayout,defaultForeBrush->brush,(D2D1_DRAW_TEXT_OPTIONS)options);
}

void DRenderBase::DrawLine(Point2F from,Point2F to,float width,DColorBrush^ foreBrush,DStrokeStyle^ stroke)
{
	pRT_->DrawLine(D2D1::Point2F(from.X,from.Y),D2D1::Point2F(to.X,to.Y),foreBrush->brush,width,stroke == nullptr ? NULL : stroke->stroke);
}

void DRenderBase::FillRectangle(RectF rect,DColorBrush^ foreBrush)
{
	pRT_->FillRectangle(D2D1::RectF(rect.Left,rect.Top,rect.Right,rect.Bottom),foreBrush->brush);
}

void DRenderBase::Clear(Color2F color)
{
	pRT_->Clear(D2D1::ColorF(color.R,color.G,color.B,color.A));
}

DRenderBase::~DRenderBase(void)
{
	GC::SuppressFinalize(this);
	this->!DRenderBase();
}

DRenderBase::!DRenderBase()
{
	if(disposed)
		return;
	if(DWriteWarpper::SafeRelease(pRT_))
		pRT_ = NULL;			
	if(DWriteWarpper::SafeRelease(pTextRender_))
		pTextRender_ = NULL;			
	disposed = true;
}
