/************************************************************************
 *
 * File: CustomTextRenderer.h
 *
 * Description: 
 * 
 * 
 *  This file is part of the Microsoft Windows SDK Code Samples.
 * 
 *  Copyright (C) Microsoft Corporation.  All rights reserved.
 * 
 * This source code is intended only as a supplement to Microsoft
 * Development Tools and/or on-line documentation.  See these other
 * materials for detailed information regarding Microsoft code samples.
 * 
 * THIS CODE AND INFORMATION ARE PROVIDED AS IS WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
 * PARTICULAR PURPOSE.
 * 
 ************************************************************************/

#pragma once

#include "vector"
#include "hash_map"
#include "Common.h"

/******************************************************************
*                                                                 *
*  CustomTextRenderer                                             *
*                                                                 *
*  The IDWriteTextRenderer interface is an input parameter to     *
*  IDWriteTextLayout::Draw.  This interfaces defines a number of  *
*  callback functions that the client application implements for  *
*  custom text rendering.  This sample renderer implementation    *
*  renders text using text outlines and Direct2D.                 *
*  A more sophisticated client would also support bitmap          *
*  renderings.                                                    *
*                                                                 *
******************************************************************/

struct my_wchar_hasher {
size_t operator() (wchar_t __x) const
	{
		return (size_t)__x;
	}
};
class CustomTextRenderer : public IDWriteTextRenderer
{
public:
	CustomTextRenderer::CustomTextRenderer(
		ID2D1RenderTarget* pRT,
		ID2D1SolidColorBrush* defalutForeBrush,
		ID2D1SolidColorBrush* controlForeBrush
		);

    ~CustomTextRenderer();

	void SetDefalutForeBrush(ID2D1SolidColorBrush* fore);

	void SetControlForeBrush(ID2D1SolidColorBrush* control);

	void RemoveControlSymbol(wchar_t c);

	void AddControlSymbol(wchar_t c,UINT32 indic);

    STDMETHOD(IsPixelSnappingDisabled)(
        __maybenull void* clientDrawingContext,
        __out BOOL* isDisabled
        );

    STDMETHOD(GetCurrentTransform)(
        __maybenull void* clientDrawingContext,
        __out DWRITE_MATRIX* transform
        );

    STDMETHOD(GetPixelsPerDip)(
        __maybenull void* clientDrawingContext,
        __out FLOAT* pixelsPerDip
        );

    STDMETHOD(DrawGlyphRun)(
        __maybenull void* clientDrawingContext,
        FLOAT baselineOriginX,
        FLOAT baselineOriginY,
        DWRITE_MEASURING_MODE measuringMode,
        __in DWRITE_GLYPH_RUN const* glyphRun,
        __in DWRITE_GLYPH_RUN_DESCRIPTION const* glyphRunDescription,
        IUnknown* clientDrawingEffect
        );

    STDMETHOD(DrawUnderline)(
        __maybenull void* clientDrawingContext,
        FLOAT baselineOriginX,
        FLOAT baselineOriginY,
        __in DWRITE_UNDERLINE const* underline,
        IUnknown* clientDrawingEffect
        );

    STDMETHOD(DrawStrikethrough)(
        __maybenull void* clientDrawingContext,
        FLOAT baselineOriginX,
        FLOAT baselineOriginY,
        __in DWRITE_STRIKETHROUGH const* strikethrough,
        IUnknown* clientDrawingEffect
        );

    STDMETHOD(DrawInlineObject)(
        __maybenull void* clientDrawingContext,
        FLOAT originX,
        FLOAT originY,
        IDWriteInlineObject* inlineObject,
        BOOL isSideways,
        BOOL isRightToLeft,
        IUnknown* clientDrawingEffect
        );

public:
    unsigned long STDMETHODCALLTYPE AddRef();
    unsigned long STDMETHODCALLTYPE Release();
    HRESULT STDMETHODCALLTYPE QueryInterface(
        IID const& riid,
        void** ppvObject
    );

private:
	struct GLYPH_RUN_INFO
	{
		DWRITE_GLYPH_RUN run;
		ID2D1SolidColorBrush *ForeBrush;
	};

	unsigned long cRefCount_;
    ID2D1RenderTarget* pRT_;
	ID2D1SolidColorBrush* defaultForeBrush;
	ID2D1SolidColorBrush* controlForeBrush;
	void GetDrawingEffect(IUnknown* clientDrawingEffect,ID2D1SolidColorBrush** fore,ID2D1SolidColorBrush** back,ID2D1StrokeStyle** underline);
	bool GetAdvancesAndIndices(const DWRITE_GLYPH_RUN *myGlyphRun,wchar_t c,UINT16 *indices,FLOAT *advance);
	void SplitGlyphRun(std::vector<GLYPH_RUN_INFO>& runs,const DWRITE_GLYPH_RUN *run,UINT16 *indices,FLOAT *advances,const DWRITE_GLYPH_RUN_DESCRIPTION* glyphRunDescription,ID2D1SolidColorBrush* foreBrush);
	void GetBounds(DWRITE_GLYPH_RUN glyphRun,float orginx,float orginy,int glyphCount,D2D1_RECT_F* bounds);
	std::hash_map<wchar_t,UINT32,my_wchar_hasher> showSymbols;
};

