﻿/*
 * Copyright (C) 2013 FooProject
 * * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using FooEditEngine;

namespace UnitTest
{
    [TestClass]
    public class UnitTest4
    {
        [TestMethod]
        public void SelectTest()
        {
            Document doc = new Document();
            DummyRender render = new DummyRender();
            EditView view = new EditView(doc,render);
            Controller ctrl = new Controller(doc, view);
            doc.Clear();
            doc.Append("a\nb\nc");
            ctrl.Select(0, 5);
            Assert.IsTrue(ctrl.SelectedText == "a\r\nb\r\nc");
        }

        [TestMethod]
        public void ReplaceSelectionTest()
        {
            Document doc = new Document();
            DummyRender render = new DummyRender();
            EditView view = new EditView(doc, render);
            Controller ctrl = new Controller(doc, view);
            doc.Clear();
            doc.Append("a\nb\nc");
            ctrl.Select(0, 5);
            ctrl.SelectedText = "a";
            ctrl.Select(0, 1);
            Assert.IsTrue(ctrl.SelectedText == "a");
        }

        [TestMethod]
        public void SelectByRectTest()
        {
            Document doc = new Document();
            DummyRender render = new DummyRender();
            EditView view = new EditView(doc, render);
            Controller ctrl = new Controller(doc, view);
            doc.Clear();
            string str = "aa\nbb\ncc";
            doc.Append(str);
            ctrl.RectSelection = true;
            ctrl.Select(0,7);
            Assert.IsTrue(ctrl.SelectedText == "a\r\nb\r\nc\r\n");
        }

        [TestMethod]
        public void RectEditTest()
        {
            Document doc = new Document();
            DummyRender render = new DummyRender();
            EditView view = new EditView(doc, render);
            Controller ctrl = new Controller(doc, view);
            doc.Clear();
            doc.Append("a\nb\nc");
            ctrl.RectSelection = true;
            ctrl.Select(0, 5);
            ctrl.DoInputString("x",true);
            Assert.IsTrue(
                view.LayoutLines[0] == "x\n" &&
                view.LayoutLines[1] == "x\n" &&
                view.LayoutLines[2] == "x");
            Assert.IsTrue(
                view.InsertPoint[0].start == 0 &&
                view.InsertPoint[1].start == 2 &&
                view.InsertPoint[2].start == 4);

            ctrl.DoInputString("x", true);
            Assert.IsTrue(
                view.InsertPoint[0].start == 1 &&
                view.InsertPoint[1].start == 4 &&
                view.InsertPoint[2].start == 7);

            doc.Clear();
            doc.Append("a\nb\nc");
            ctrl.Select(0, 4);
            ctrl.DoInputString("x");
            Assert.IsTrue(
                view.LayoutLines[0] == "xa\n" &&
                view.LayoutLines[1] == "xb\n" &&
                view.LayoutLines[2] == "xc");

            ctrl.DoBackSpaceAction();
            Assert.IsTrue(
                view.LayoutLines[0] == "a\n" &&
                view.LayoutLines[1] == "b\n" &&
                view.LayoutLines[2] == "c");
        }
    }
}
