﻿/*
 * Copyright (C) 2013 FooProject
 * * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
using System.Linq;
using DotNetTextStore.UnmanagedAPI.WinDef;
using DotNetTextStore.UnmanagedAPI.TSF;
using DotNetTextStore;

namespace FooEditEngine
{
    static class TextStoreHelper
    {
        public static bool StartCompstion(Document document)
        {
            if (document.State == AsyncState.Loading)
            {
                return false;
            }
            document.UndoManager.BeginUndoGroup();
            return true;
        }

        public static void EndCompostion(Document document)
        {
            document.UndoManager.EndUndoGroup();
        }

        public static bool ScrollToCompstionUpdated(TextStoreBase textStore,EditView view,int start, int end)
        {
            if (textStore.IsLocked() == false)
                return false;
            using (Unlocker locker = textStore.LockDocument(false))
            {
                foreach (TextDisplayAttribute attr in textStore.EnumAttributes(start, end))
                {
                    if (attr.attribute.bAttr == TF_DA_ATTR_INFO.TF_ATTR_TARGET_CONVERTED)
                    {
                        if (view.AdjustSrc(attr.startIndex))
                        {
                            return true;
                        }
                    }
                }
            }
            return false;   
        }

        public static void GetStringExtent(Document document,EditView view,int i_startIndex,int i_endIndex,out Point startPos,out Point endPos)
        {
            if (document.State == AsyncState.Loading)
            {
                startPos = new Point();
                endPos = startPos;
                return;
            }
            var endIndex = i_endIndex < 0 ? document.Length - 1 : i_endIndex;
            TextPoint endTextPoint;

            startPos = view.GetPostionFromTextPoint(view.LayoutLines.GetTextPointFromIndex(i_startIndex));
            endTextPoint = view.GetLayoutLineFromIndex(endIndex);
            endPos = view.GetPostionFromTextPoint(endTextPoint);
            endPos.Y += view.LayoutLines.GetLayout(endTextPoint.row).Height;
        }

        public static void GetSelection(Controller controller, SelectCollection selectons, out int o_startIndex, out int o_endIndex)
        {
            if (controller.RectSelection && selectons.Count > 0)
            {
                o_startIndex = selectons[0].start;
                o_endIndex = o_startIndex + selectons[0].length;
            }
            else
            {
                o_startIndex = controller.SelectionStart;
                o_endIndex = o_startIndex + controller.SelectionLength;
            }
        }

        public static void SetSelectionIndex(Controller controller,EditView view,int i_startIndex, int i_endIndex)
        {
            if (controller.RectSelection && view.InsertPoint != null)
            {
                TextPoint start = view.LayoutLines.GetTextPointFromIndex(i_startIndex);
                TextPoint end = view.LayoutLines.GetTextPointFromIndex(view.InsertPoint.Last().start);
                controller.Select(start, i_endIndex - i_startIndex, end.row - start.row);
            }
            else if (i_startIndex == i_endIndex)
            {
                controller.JumpCaret(i_startIndex);
            }
            else
            {
                controller.Select(i_startIndex, i_endIndex - i_startIndex);
            }
        }

        public static void InsertTextAtSelection(Controller controller,string i_value)
        {
            System.Diagnostics.Debug.WriteLine(i_value);
            controller.DoInputString(i_value, true);
        }
    }
}
