﻿/*
 * Copyright (C) 2013 FooProject
 * * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
using System;
using System.Collections.Generic;
using Windows.Graphics.Display;
using Windows.UI.Text;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Media.Imaging;
using SharpDX;
using DXGI = SharpDX.DXGI;
using D2D = SharpDX.Direct2D1;
using DW = SharpDX.DirectWrite;
using D3D = SharpDX.Direct3D;
using D3D11 = SharpDX.Direct3D11;
using FooEditEngine.Metro;

namespace FooEditEngine
{
    class D2DRenderBase: IDisposable
    {
        public const int MiniumeWidth = 40;    //これ以上ないと誤操作が起こる

        protected DXGI.Device DXGIDevice;
        protected D3D11.Device1 D3DDevice;
        D2DRenderCommon common = new D2DRenderCommon();
        Windows.UI.Color ForegroundColor, BackgroundColor, HilightColor, Keyword1Color, Keyword2Color, LiteralColor, UrlColor, ControlCharColor, CommentColor, InsertCaretColor, OverwriteCaretColor, LineMarkerColor;
        FontFamily fontFamily;
        FontStyle fontStyle = FontStyle.Normal;
        FontWeight fontWeigth;
        double fontSize;

        public D2DRenderBase()
        {
            var creationFlags = SharpDX.Direct3D11.DeviceCreationFlags.VideoSupport | SharpDX.Direct3D11.DeviceCreationFlags.BgraSupport;
            D3D.FeatureLevel[] featureLevels ={D3D.FeatureLevel.Level_11_1,
                                                 D3D.FeatureLevel.Level_11_0,
                                                 D3D.FeatureLevel.Level_10_1,
                                                 D3D.FeatureLevel.Level_10_0,
                                                 D3D.FeatureLevel.Level_9_3,
                                                 D3D.FeatureLevel.Level_9_2,
                                                 D3D.FeatureLevel.Level_9_1};
            using (var device = new D3D11.Device(D3D.DriverType.Hardware, creationFlags, featureLevels))
            {
                this.D3DDevice = device.QueryInterface<D3D11.Device1>();
            }
            this.DXGIDevice = this.D3DDevice.QueryInterface<DXGI.Device>();
        }

        public void ConstructDeviceResource(double width,double height)
        {
            this.common.ConstructDeviceResource(width,height);
        }

        public void ReConstructDeviceResource(double width, double height)
        {
            this.common.ReConstructDeviceResource(width, height);
        }

        public void DrawMarkerEffect(MyTextLayout layout, HilightType type, int start, int length, double x, double y, bool isBold, Windows.UI.Color? effectColor = null)
        {
            Color4? color4 = null;
            if(effectColor != null)
                color4 = this.ToColor4((Windows.UI.Color)effectColor);
            this.common.DrawMarkerEffect(layout, type, start, length, x, y, isBold, color4);
        }

        public void InitTextFormat(string fontName, double size)
        {
            this.common.InitTextFormat(fontName, (float)size);
            this.fontSize = size;
        }

        public void InitTextFormat(FontFamily font, double size)
        {
            this.common.InitTextFormat(font.Source, (float)size);
            this.fontFamily = font;
            this.fontSize = size;
        }

        public System.Func<D2D.Factory1, D2D.RenderTargetProperties, double, double, D2D.RenderTarget> ConstructRender
        {
            get
            {
                return this.common.ConstructRender;
            }
            set
            {
                this.common.ConstructRender = value;
            }
        }

        public System.Action ConstrctedResource
        {
            get
            {
                return this.common.ConstrctedResource;
            }
            set
            {
                this.common.ConstrctedResource = value;
            }
        }

        public GetDpiHandler GetDpi
        {
            get
            {
                return this.common.GetDpi;
            }
            set
            {
                this.common.GetDpi = value;
            }
        }

        public System.Action DestructRender
        {
            get
            {
                return this.common.DestructRender;
            }
            set
            {
                this.common.DestructRender = value;
            }
        }

        public System.Action ReCreateTarget
        {
            get
            {
                return this.common.ReCreateTarget;
            }
            set
            {
                this.common.ReCreateTarget = value;
            }
        }

        public void Dispose()
        {
            if (this.DXGIDevice != null)
                this.DXGIDevice.Dispose();
            if (this.D3DDevice != null)
                this.D3DDevice.Dispose();
            this.common.Dispose();
        }

        public TextAntialiasMode TextAntialiasMode
        {
            get
            {
                return this.common.TextAntialiasMode;
            }
            set
            {
                this.common.TextAntialiasMode = value;
            }
        }

        public bool ShowFullSpace
        {
            get
            {
                return this.common.ShowFullSpace;
            }
            set
            {
                this.common.ShowFullSpace = value;
            }
        }

        public bool ShowHalfSpace
        {
            get
            {
                return this.common.ShowHalfSpace;
            }
            set
            {
                this.common.ShowHalfSpace = value;
            }
        }

        public bool ShowTab
        {
            get
            {
                return this.common.ShowTab;
            }
            set
            {
                this.common.ShowTab = value;
            }
        }

        public bool ShowLineBreak
        {
            get
            {
                return this.common.ShowLineBreak;
            }
            set
            {
                this.common.ShowLineBreak = value;
            }
        }

        public FontFamily FontFamily
        {
            get { return this.fontFamily; }
            set
            {
                this.fontFamily = value;
                this.common.InitTextFormat(this.fontFamily.Source, (float)this.fontSize, this.GetDWFontWeigth(this.fontWeigth), this.GetDWFontStyle(this.fontStyle));
                this.TabWidthChar = this.TabWidthChar;
            }
        }

        public double FontSize
        {
            get { return this.fontSize; }
            set
            {
                this.fontSize = value;
                this.common.InitTextFormat(this.fontFamily.Source, (float)this.fontSize, this.GetDWFontWeigth(this.fontWeigth), this.GetDWFontStyle(this.fontStyle));
                this.TabWidthChar = this.TabWidthChar;
            }
        }

        public FontWeight FontWeigth
        {
            get
            {
                return this.fontWeigth;
            }
            set
            {
                this.fontWeigth = value;
                this.common.InitTextFormat(this.fontFamily.Source, (float)this.fontSize, this.GetDWFontWeigth(value), this.GetDWFontStyle(this.fontStyle));
            }
        }

        public FontStyle FontStyle
        {
            get
            {
                return this.fontStyle;
            }
            set
            {
                this.fontStyle = value;
                this.common.InitTextFormat(this.fontFamily.Source, (float)this.fontSize, this.GetDWFontWeigth(this.fontWeigth), this.GetDWFontStyle(this.fontStyle));
            }
        }

        DW.FontStyle GetDWFontStyle(FontStyle style)
        {
            return (DW.FontStyle)Enum.Parse(typeof(DW.FontStyle), style.ToString());
        }

        DW.FontWeight GetDWFontWeigth(FontWeight weigth)
        {
            if (weigth.Weight == 0)
                return (DW.FontWeight)400;
            else
                return (DW.FontWeight)weigth.Weight;
        }

        public bool RightToLeft
        {
            get
            {
                return this.common.RightToLeft;
            }
            set
            {
                this.common.RightToLeft = value;
            }
        }

        Color4 ToColor4(Windows.UI.Color color)
        {
            return new Color4(color.R / 255.0f, color.G / 255.0f, color.B / 255.0f, color.A / 255.0f);
        }

        public Windows.UI.Color Foreground
        {
            get
            {
                return this.ForegroundColor;
            }
            set
            {
                this.ForegroundColor = value;
                this.common.Foreground = this.ToColor4(value);
            }
        }

        public Windows.UI.Color Background
        {
            get
            {
                return this.BackgroundColor;
            }
            set
            {
                this.BackgroundColor = value;
                this.common.Background = this.ToColor4(value);
            }
        }

        public Windows.UI.Color InsertCaret
        {
            get
            {
                return this.InsertCaretColor;
            }
            set
            {
                this.InsertCaretColor = value;
                this.common.InsertCaret = this.ToColor4(value);
            }
        }

        public Windows.UI.Color OverwriteCaret
        {
            get
            {
                return this.OverwriteCaretColor;
            }
            set
            {
                this.OverwriteCaretColor = value;
                this.common.OverwriteCaret = this.ToColor4(value);
            }
        }

        public Windows.UI.Color LineMarker
        {
            get
            {
                return this.LineMarkerColor;
            }
            set
            {
                this.LineMarkerColor = value;
                this.common.LineMarker = this.ToColor4(value);
            }
        }

        public Windows.UI.Color ControlChar
        {
            get
            {
                return this.ControlCharColor;
            }
            set
            {
                this.ControlCharColor = value;
                this.common.ControlChar = this.ToColor4(value);
            }
        }

        public Windows.UI.Color Url
        {
            get
            {
                return this.UrlColor;
            }
            set
            {
                this.UrlColor = value;
                this.common.Url = this.ToColor4(value);
            }
        }

        public Windows.UI.Color Hilight
        {
            get
            {
                return this.HilightColor;
            }
            set
            {
                this.HilightColor = value;
                this.HilightColor.A = 50;
                this.common.Hilight = this.ToColor4(this.HilightColor);
            }
        }

        public Windows.UI.Color Comment
        {
            get
            {
                return this.CommentColor;
            }
            set
            {
                this.CommentColor = value;
                this.common.Comment = this.ToColor4(value);
            }
        }

        public Windows.UI.Color Literal
        {
            get
            {
                return this.LiteralColor;
            }
            set
            {
                this.LiteralColor = value;
                this.common.Literal = this.ToColor4(value);
            }
        }

        public Windows.UI.Color Keyword1
        {
            get
            {
                return this.Keyword1Color;
            }
            set
            {
                this.Keyword1Color = value;
                this.common.Keyword1 = this.ToColor4(value);
            }
        }

        public Windows.UI.Color Keyword2
        {
            get
            {
                return this.Keyword2Color;
            }
            set
            {
                this.Keyword2Color = value;
                this.common.Keyword2 = this.ToColor4(value);
            }
        }

        public Rectangle TextArea
        {
            get { return this.common.ClipRect; }
            set { this.common.ClipRect = value; }
        }

        public double LineNemberWidth
        {
            get
            {
                return this.common.LineNemberWidth;
            }
        }
        public double FoldingWidth
        {
            get
            {
                return Math.Max(D2DRender.MiniumeWidth, this.common.FoldingWidth);
            }
        }

        public Size emSize
        {
            get
            {
                return this.common.emSize;
            }
        }

        public int TabWidthChar
        {
            get { return this.common.TabWidthChar; }
            set
            {
                if (value == 0)
                    return;
                this.common.TabWidthChar = value;
            }
        }

        public event ChangedRenderResourceEventHandler ChangedRenderResource
        {
            add
            {
                this.common.ChangedRenderResource += value;
            }
            remove
            {
                this.common.ChangedRenderResource -= value;
            }
        }

        public event EventHandler ChangedRightToLeft
        {
            add
            {
                this.common.ChangedRightToLeft += value;
            }
            remove
            {
                this.common.ChangedRightToLeft -= value;
            }
        }

        public virtual void BeginDraw()
        {
            this.common.BegineDraw();
        }

        public virtual void EndDraw()
        {
            this.common.EndDraw();
        }

        public void DrawCachedBitmap(Rectangle rect)
        {
            //this.Common.DrawCachedBitmap(rect);
        }

        public void DrawLine(Point from, Point to)
        {
            this.common.DrawLine(from, to);
        }

        public void CacheContent()
        {
            //this.Common.CacheContent();
        }

        public bool IsVaildCache()
        {
            //return this.Common.IsVaildCache();
            return false;
        }

        public void DrawString(string str, double x, double y, StringAlignment align, Size layoutRect)
        {
            this.common.DrawString(str, x, y, align, layoutRect);
        }

        public void FillRectangle(Rectangle rect, FillRectType type)
        {
            this.common.FillRectangle(rect, type);
        }

        public void DrawGripper(Point p, double radius)
        {
            this.common.DrawGripper(p, radius);
        }

        public void DrawFoldingMark(bool expand, double x, double y)
        {
            string mark = expand ? "-" : "+";
            this.DrawString(mark, x, y, StringAlignment.Center, new Size(this.FoldingWidth, this.emSize.Height));
        }

        public void FillBackground(Rectangle rect)
        {
            this.common.FillBackground(rect);
        }

        protected delegate void PreDrawOneLineHandler(MyTextLayout layout, LineToIndexTable lti, int row, double x, double y);
        protected PreDrawOneLineHandler PreDrawOneLine;

        public void DrawOneLine(LineToIndexTable lti, int row, double x, double y, IEnumerable<Selection> SelectRanges)
        {
            this.common.DrawOneLine(lti,
                row,
                x,
                y,
                SelectRanges,
                (layout) =>{
                    if(this.PreDrawOneLine !=null)
                        this.PreDrawOneLine(layout, lti, row, x, y);
                });
        }

        public List<LineToIndexTableData> BreakLine(Document doc,LineToIndexTable layoutLineCollection, int startIndex, int endIndex, double wrapwidth)
        {
            return this.common.BreakLine(doc,layoutLineCollection, startIndex, endIndex, wrapwidth);
        }

        public ITextLayout CreateLaytout(string str, SyntaxInfo[] syntaxCollection, IEnumerable<Marker> MarkerRanges)
        {
            return this.common.CreateLaytout(str, syntaxCollection, MarkerRanges);
        }
    }
}
