/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.util.datatype;

import com.siemens.ct.exi.exceptions.XMLParsingException;
import com.siemens.ct.exi.util.datatype.DatetimeType;
import java.util.Calendar;

public class XSDDatetime {
    public static final int NUMBER_BITS_MONTHDAY = 9;
    public static final int NUMBER_BITS_TIME = 17;
    public static final int NUMBER_BITS_TIMEZONE = 11;
    public static final int YEAR_OFFSET = 2000;
    public static final int TIMEZONE_OFFSET_IN_MINUTES = 840;
    public static final int MONTH_MULTIPLICATOR = 32;
    private DatetimeType type;
    private StringBuilder sbCal = new StringBuilder();
    public int iYear;
    public int iMonthDay;
    public int iTime;
    public int iTZMinutes;
    public int iFractionalSecs;

    private XSDDatetime() {
    }

    public static XSDDatetime newInstance() {
        return new XSDDatetime();
    }

    public DatetimeType getDatetimeType() {
        return this.type;
    }

    public boolean parse(String cal, DatetimeType type) {
        this.type = type;
        this.sbCal.setLength(0);
        this.sbCal.append(cal);
        try {
            switch (type) {
                case gYear: {
                    this.iYear = XSDDatetime.parseYear(this.sbCal) - 2000;
                    this.iTZMinutes = XSDDatetime.parseTimezoneInMinutesOffset(this.sbCal);
                    break;
                }
                case gYearMonth: {
                    this.iYear = XSDDatetime.parseYear(this.sbCal) - 2000;
                    XSDDatetime.checkCharacter(this.sbCal, '-');
                    this.iMonthDay = XSDDatetime.parseMonth(this.sbCal) * 32;
                    this.iTZMinutes = XSDDatetime.parseTimezoneInMinutesOffset(this.sbCal);
                    break;
                }
                case date: {
                    this.iYear = XSDDatetime.parseYear(this.sbCal) - 2000;
                    XSDDatetime.checkCharacter(this.sbCal, '-');
                    this.iMonthDay = XSDDatetime.parseMonthDay(this.sbCal);
                    this.iTZMinutes = XSDDatetime.parseTimezoneInMinutesOffset(this.sbCal);
                    break;
                }
                case dateTime: {
                    this.iYear = XSDDatetime.parseYear(this.sbCal) - 2000;
                    XSDDatetime.checkCharacter(this.sbCal, '-');
                    this.iMonthDay = XSDDatetime.parseMonthDay(this.sbCal);
                    XSDDatetime.checkCharacter(this.sbCal, 'T');
                    this.iTime = XSDDatetime.parseTime(this.sbCal);
                    this.iFractionalSecs = XSDDatetime.parseFractionalSecondsReverse(this.sbCal);
                    this.iTZMinutes = XSDDatetime.parseTimezoneInMinutesOffset(this.sbCal);
                    break;
                }
                case gMonth: {
                    XSDDatetime.checkCharacter(this.sbCal, '-');
                    XSDDatetime.checkCharacter(this.sbCal, '-');
                    this.iMonthDay = XSDDatetime.parseMonth(this.sbCal) * 32;
                    this.iTZMinutes = XSDDatetime.parseTimezoneInMinutesOffset(this.sbCal);
                    break;
                }
                case gMonthDay: {
                    XSDDatetime.checkCharacter(this.sbCal, '-');
                    XSDDatetime.checkCharacter(this.sbCal, '-');
                    this.iMonthDay = XSDDatetime.parseMonthDay(this.sbCal);
                    this.iTZMinutes = XSDDatetime.parseTimezoneInMinutesOffset(this.sbCal);
                    break;
                }
                case gDay: {
                    XSDDatetime.checkCharacter(this.sbCal, '-');
                    XSDDatetime.checkCharacter(this.sbCal, '-');
                    XSDDatetime.checkCharacter(this.sbCal, '-');
                    this.iMonthDay = XSDDatetime.parseDay(this.sbCal);
                    this.iTZMinutes = XSDDatetime.parseTimezoneInMinutesOffset(this.sbCal);
                    break;
                }
                case time: {
                    this.iTime = XSDDatetime.parseTime(this.sbCal);
                    this.iFractionalSecs = XSDDatetime.parseFractionalSecondsReverse(this.sbCal);
                    this.iTZMinutes = XSDDatetime.parseTimezoneInMinutesOffset(this.sbCal);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
        catch (XMLParsingException e) {
            return false;
        }
    }

    public static void checkCharacter(StringBuilder sb, char c) throws XMLParsingException {
        if (sb.length() <= 0 || sb.charAt(0) != c) {
            throw new XMLParsingException("Unexpected character while parsing");
        }
        sb.delete(0, 1);
    }

    public static int parseYear(StringBuilder sb) {
        int len;
        String sYear;
        if (sb.charAt(0) == '-') {
            sYear = sb.substring(0, 5);
            len = 5;
        } else {
            sYear = sb.substring(0, 4);
            len = 4;
        }
        int year = Integer.parseInt(sYear);
        sb.delete(0, len);
        return year;
    }

    public static int parseMonth(StringBuilder sb) {
        int month = Integer.parseInt(sb.substring(0, 2));
        sb.delete(0, 2);
        return month;
    }

    public static int parseDay(StringBuilder sb) {
        String sDay = sb.substring(0, 2);
        int day = Integer.parseInt(sDay);
        sb.delete(0, 2);
        return day;
    }

    public static int parseMonthDay(StringBuilder sb) throws XMLParsingException {
        int month = XSDDatetime.parseMonth(sb);
        XSDDatetime.checkCharacter(sb, '-');
        int day = XSDDatetime.parseDay(sb);
        return month * 32 + day;
    }

    public static int parseTime(StringBuilder sb) throws XMLParsingException {
        int hour = Integer.parseInt(sb.substring(0, 2));
        sb.delete(0, 2);
        XSDDatetime.checkCharacter(sb, ':');
        int minutes = Integer.parseInt(sb.substring(0, 2));
        sb.delete(0, 2);
        XSDDatetime.checkCharacter(sb, ':');
        int seconds = Integer.parseInt(sb.substring(0, 2));
        sb.delete(0, 2);
        return (hour * 60 + minutes) * 60 + seconds;
    }

    public static int parseTimezoneInMinutesOffset(StringBuilder sb) throws XMLParsingException {
        int multiplicator;
        if (sb.length() == 0) {
            return 0;
        }
        if (sb.charAt(0) == 'Z') {
            sb.delete(0, 1);
            return 0;
        }
        if (sb.charAt(0) == '+') {
            multiplicator = 1;
        } else if (sb.charAt(0) == '-') {
            multiplicator = -1;
        } else {
            throw new XMLParsingException("Unexpected character while parsing");
        }
        int hours = Integer.parseInt(sb.substring(1, 3));
        assert (sb.charAt(3) == ':');
        int minutes = Integer.parseInt(sb.substring(4, 6));
        return multiplicator * (hours * 60 + minutes) + 840;
    }

    public static int parseFractionalSecondsReverse(StringBuilder sb) throws StringIndexOutOfBoundsException {
        if (sb.length() > 0 && sb.charAt(0) == '.') {
            sb.deleteCharAt(0);
            int digits = XSDDatetime.countDigits(sb);
            int revFracSecs = Integer.parseInt(new StringBuilder(sb.substring(0, digits)).reverse().toString());
            sb.delete(0, digits);
            return revFracSecs;
        }
        return 0;
    }

    private static int countDigits(StringBuilder sb) {
        int length = sb.length();
        int index = 0;
        while (index < length && XSDDatetime.isDigit(sb.charAt(index))) {
            ++index;
        }
        return index;
    }

    private static boolean isDigit(char c) {
        boolean isDigit = false;
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        int i = 0;
        while (!isDigit && i < digits.length) {
            if (c == digits[i]) {
                isDigit = true;
            }
            ++i;
        }
        return isDigit;
    }

    public static int getMonthDay(Calendar cal) {
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int monthDay = month * 32 + day;
        return monthDay;
    }

    public static void setMonthDay(int monthDay, Calendar cal) {
        int month = monthDay / 32;
        cal.set(2, month - 1);
        int day = monthDay - month * 32;
        cal.set(5, day);
    }

    public static int getTime(Calendar cal) {
        int time = cal.get(11);
        time *= 64;
        time += cal.get(12);
        time *= 64;
        return time += cal.get(13);
    }

    public static void setTime(int time, Calendar cal) {
        int hour = time / 4096;
        int minute = (time -= hour * 4096) / 64;
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, time -= minute * 64);
    }

    public static int getTimeZoneInMinutesOffset(Calendar cal) {
        return cal.getTimeZone().getRawOffset() / 60000 + 840;
    }

    public static int getTimeZoneInMillisecs(int minutes) {
        return minutes * 60000;
    }

    public static int getFractionalSecondsReverse(int millisec) {
        int revFracSecs = 0;
        if (millisec != 0) {
            revFracSecs = millisec < 10 ? Integer.parseInt(new StringBuilder("00" + millisec).reverse().toString()) : (millisec < 100 ? Integer.parseInt(new StringBuilder("0" + millisec).reverse().toString()) : Integer.parseInt(new StringBuilder(millisec).reverse().toString()));
        }
        return revFracSecs;
    }
}

