/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.io.channel;

import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.util.datatype.DatetimeType;
import com.siemens.ct.exi.values.BooleanValue;
import com.siemens.ct.exi.values.DateTimeValue;
import com.siemens.ct.exi.values.DecimalValue;
import com.siemens.ct.exi.values.DoubleValue;
import com.siemens.ct.exi.values.FloatValue;
import com.siemens.ct.exi.values.HugeIntegerValue;
import com.siemens.ct.exi.values.IntegerValue;
import com.siemens.ct.exi.values.LongValue;
import java.io.IOException;
import java.math.BigInteger;

public abstract class AbstractDecoderChannel
implements DecoderChannel {
    public BooleanValue decodeBooleanValue() throws IOException {
        return new BooleanValue(this.decodeBoolean());
    }

    public char[] decodeString() throws IOException {
        return this.decodeStringOnly(this.decodeUnsignedInteger());
    }

    public char[] decodeStringOnly(int length) throws IOException {
        char[] ca = new char[length];
        int i = 0;
        while (i < length) {
            int codePoint = this.decodeUnsignedInteger();
            if (Character.isSupplementaryCodePoint(codePoint)) {
                Character.toChars(codePoint, ca, i++);
            } else {
                ca[i] = (char)codePoint;
            }
            ++i;
        }
        return ca;
    }

    protected int decodeInteger() throws IOException {
        if (this.decodeBoolean()) {
            return -(this.decodeUnsignedInteger() + 1);
        }
        return this.decodeUnsignedInteger();
    }

    public IntegerValue decodeIntegerValue() throws IOException {
        return new IntegerValue(this.decodeInteger());
    }

    protected long decodeLong() throws IOException {
        if (this.decodeBoolean()) {
            return -(this.decodeUnsignedLong() + 1L);
        }
        return this.decodeUnsignedLong();
    }

    public LongValue decodeLongValue() throws IOException {
        return new LongValue(this.decodeLong());
    }

    public HugeIntegerValue decodeHugeIntegerValue() throws IOException {
        HugeIntegerValue bi;
        if (this.decodeBoolean()) {
            bi = this.decodeUnsignedHugeIntegerValue();
            bi = bi.isLongValue ? new HugeIntegerValue(-(bi.longValue + 1L)) : new HugeIntegerValue(bi.bigIntegerValue.add(BigInteger.ONE).negate());
        } else {
            bi = this.decodeUnsignedHugeIntegerValue();
        }
        return bi;
    }

    public HugeIntegerValue decodeUnsignedHugeIntegerValue() throws IOException {
        int b;
        long lResult = 0L;
        int mShift = 0;
        int cntBytes = 0;
        boolean isLongValue = true;
        do {
            if (cntBytes >= 9) {
                isLongValue = false;
                break;
            }
            b = this.decode();
            ++cntBytes;
            lResult += (long)(b & 0x7F) << mShift;
            mShift += 7;
        } while (b >>> 7 == 1);
        if (isLongValue) {
            return new HugeIntegerValue(lResult);
        }
        BigInteger bResult = BigInteger.valueOf(lResult);
        BigInteger multiplier = BigInteger.ONE;
        multiplier = multiplier.shiftLeft(7 * cntBytes);
        do {
            b = this.decode();
            bResult = bResult.add(multiplier.multiply(BigInteger.valueOf(b & 0x7F)));
            multiplier = multiplier.shiftLeft(7);
        } while (b >>> 7 == 1);
        return new HugeIntegerValue(bResult);
    }

    public int decodeUnsignedInteger() throws IOException {
        int b;
        int result = 0;
        int mShift = 0;
        do {
            b = this.decode();
            result += (b & 0x7F) << mShift;
            mShift += 7;
        } while (b >>> 7 == 1);
        return result;
    }

    public IntegerValue decodeUnsignedIntegerValue() throws IOException {
        return new IntegerValue(this.decodeUnsignedInteger());
    }

    protected long decodeUnsignedLong() throws IOException {
        int b;
        long lResult = 0L;
        int mShift = 0;
        do {
            b = this.decode();
            lResult += (long)(b & 0x7F) << mShift;
            mShift += 7;
        } while (b >>> 7 == 1);
        return lResult;
    }

    public LongValue decodeUnsignedLongValue() throws IOException {
        return new LongValue(this.decodeUnsignedLong());
    }

    public IntegerValue decodeNBitUnsignedIntegerValue(int n) throws IOException {
        return new IntegerValue(this.decodeNBitUnsignedInteger(n));
    }

    public DecimalValue decodeDecimalValue() throws IOException {
        boolean negative = this.decodeBoolean();
        HugeIntegerValue integral = this.decodeUnsignedHugeIntegerValue();
        HugeIntegerValue revFractional = this.decodeUnsignedHugeIntegerValue();
        return new DecimalValue(negative, integral, revFractional);
    }

    public FloatValue decodeFloatValue() throws IOException {
        int iMantissa = this.decodeInteger();
        int iExponent = this.decodeInteger();
        return new FloatValue(iMantissa, iExponent);
    }

    public DoubleValue decodeDoubleValue() throws IOException {
        long lMantissa = this.decodeLong();
        long lExponent = this.decodeLong();
        return new DoubleValue(lMantissa, lExponent);
    }

    public DateTimeValue decodeDateTimeValue(DatetimeType type) throws IOException {
        int timeZone;
        int year = 0;
        int monthDay = 0;
        int time = 0;
        int fractionalSecs = 0;
        switch (type) {
            case gYear: {
                year = this.decodeInteger() + 2000;
                timeZone = this.decodeDateTimeTimezone();
                break;
            }
            case gYearMonth: {
                year = this.decodeInteger() + 2000;
                monthDay = this.decodeNBitUnsignedInteger(9);
                timeZone = this.decodeDateTimeTimezone();
                break;
            }
            case date: {
                year = this.decodeInteger() + 2000;
                monthDay = this.decodeNBitUnsignedInteger(9);
                timeZone = this.decodeDateTimeTimezone();
                break;
            }
            case dateTime: {
                year = this.decodeInteger() + 2000;
                monthDay = this.decodeNBitUnsignedInteger(9);
                time = this.decodeNBitUnsignedInteger(17);
                fractionalSecs = this.decodeDateTimeFractionalSecs();
                timeZone = this.decodeDateTimeTimezone();
                break;
            }
            case gMonth: {
                monthDay = this.decodeNBitUnsignedInteger(9);
                timeZone = this.decodeDateTimeTimezone();
                break;
            }
            case gMonthDay: {
                monthDay = this.decodeNBitUnsignedInteger(9);
                timeZone = this.decodeDateTimeTimezone();
                break;
            }
            case gDay: {
                monthDay = this.decodeNBitUnsignedInteger(9);
                timeZone = this.decodeDateTimeTimezone();
                break;
            }
            case time: {
                time = this.decodeNBitUnsignedInteger(17);
                fractionalSecs = this.decodeDateTimeFractionalSecs();
                timeZone = this.decodeDateTimeTimezone();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return new DateTimeValue(type, year, monthDay, time, fractionalSecs, timeZone);
    }

    private int decodeDateTimeTimezone() throws IOException {
        return this.decodeBoolean() ? this.decodeNBitUnsignedInteger(11) - 840 : 0;
    }

    private int decodeDateTimeFractionalSecs() throws IOException {
        return this.decodeBoolean() ? this.decodeUnsignedInteger() : 0;
    }
}

