/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammar.rule;

import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.grammar.EventInformation;
import com.siemens.ct.exi.grammar.SchemaInformedEventInformation;
import com.siemens.ct.exi.grammar.event.Attribute;
import com.siemens.ct.exi.grammar.event.AttributeNS;
import com.siemens.ct.exi.grammar.event.Event;
import com.siemens.ct.exi.grammar.event.EventType;
import com.siemens.ct.exi.grammar.event.StartElement;
import com.siemens.ct.exi.grammar.event.StartElementNS;
import com.siemens.ct.exi.grammar.rule.AbstractRule;
import com.siemens.ct.exi.grammar.rule.Rule;
import com.siemens.ct.exi.grammar.rule.SchemaInformedRule;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.util.sort.EventCodeAssignment;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractSchemaInformedRule
extends AbstractRule
implements SchemaInformedRule {
    EventInformation[] containers = new EventInformation[0];
    protected int codeLengthA;
    protected int codeLengthB;
    protected boolean isTypeCastable = false;
    protected boolean isNillable = false;
    protected boolean hasEndElement = false;
    protected SchemaInformedRule typeEmpty;
    protected int leastAttributeEventCode = -1;
    protected int numberDeviatedAttributes = 0;
    static EventCodeAssignment eventCodeAss = new EventCodeAssignment();

    public AbstractSchemaInformedRule() {
        this.init();
    }

    public AbstractSchemaInformedRule(String label) {
        super(label);
        this.init();
    }

    protected final boolean isTerminalRule() {
        return this == END_RULE;
    }

    private void init() {
        this.containers = new EventInformation[0];
    }

    public final boolean isSchemaInformed() {
        return true;
    }

    public boolean hasSecondOrThirdLevel(FidelityOptions fidelityOptions) {
        return !fidelityOptions.isStrict();
    }

    public int get1stLevelEventCodeLength(FidelityOptions fidelityOptions) {
        return this.hasSecondOrThirdLevel(fidelityOptions) ? this.codeLengthB : this.codeLengthA;
    }

    public void setTypeCastable(boolean isTypeCastable) {
        this.isTypeCastable = isTypeCastable;
    }

    public void setNillable(boolean nil, SchemaInformedRule typeEmpty) {
        this.isNillable = nil;
        this.typeEmpty = typeEmpty;
    }

    public Rule getTypeEmpty() {
        return this.typeEmpty;
    }

    public int getNumberOfSchemaDeviatedAttributes() {
        return this.numberDeviatedAttributes;
    }

    public int getLeastAttributeEventCode() {
        return this.leastAttributeEventCode;
    }

    public int getNumberOfEvents() {
        return this.containers.length;
    }

    public void addRule(Event event, Rule rule) {
        if (this.isTerminalRule()) {
            throw new IllegalArgumentException("EndRule can not have events attached");
        }
        if (!event.isEventType(EventType.END_ELEMENT) && !event.isEventType(EventType.ATTRIBUTE_GENERIC) && !event.isEventType(EventType.START_ELEMENT_GENERIC) || this.lookForEvent(event.getEventType()) == null) {
            if (event.isEventType(EventType.END_ELEMENT)) {
                this.hasEndElement = true;
            }
            int i = 0;
            while (i < this.containers.length) {
                EventInformation ei = this.containers[i];
                if (ei.event.equals(event) && ei.next != rule) {
                    throw new IllegalArgumentException("Same event " + event + " with indistinguishable 'next' rule");
                }
                ++i;
            }
            this.updateSortedEventRules(event, rule);
        }
    }

    protected void updateSortedEventRules(Event newEvent, Rule newRule) {
        ArrayList<Event> sortedEvents = new ArrayList<Event>();
        EventInformation[] eventInformationArray = this.containers;
        int n = this.containers.length;
        int n2 = 0;
        while (n2 < n) {
            EventInformation ei = eventInformationArray[n2];
            sortedEvents.add(ei.event);
            ++n2;
        }
        sortedEvents.add(newEvent);
        Collections.sort(sortedEvents, eventCodeAss);
        EventInformation[] newContainers = new EventInformation[sortedEvents.size()];
        int eventCode = 0;
        boolean newOneAdded = false;
        for (Event ev : sortedEvents) {
            if (ev == newEvent) {
                newContainers[eventCode] = new SchemaInformedEventInformation(newRule, newEvent, eventCode);
                newOneAdded = true;
            } else {
                EventInformation oldEI = this.containers[newOneAdded ? eventCode - 1 : eventCode];
                newContainers[eventCode] = new SchemaInformedEventInformation(oldEI.next, oldEI.event, eventCode);
            }
            ++eventCode;
        }
        this.containers = newContainers;
        this.codeLengthA = MethodsBag.getCodingLength(this.getNumberOfEvents());
        this.codeLengthB = MethodsBag.getCodingLength(this.getNumberOfEvents() + 1);
        this.leastAttributeEventCode = -1;
        this.numberDeviatedAttributes = 0;
        int i = 0;
        while (i < this.containers.length) {
            EventInformation er = this.containers[i];
            if (er.event.isEventType(EventType.ATTRIBUTE)) {
                if (this.leastAttributeEventCode == -1) {
                    this.leastAttributeEventCode = i;
                }
                ++this.numberDeviatedAttributes;
            }
            ++i;
        }
        ++this.numberDeviatedAttributes;
    }

    public void joinRules(Rule rule) {
        int i = 0;
        while (i < rule.getNumberOfEvents()) {
            EventInformation ei = rule.lookFor(i);
            this.addRule(ei.event, ei.next);
            ++i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        while (i < this.getNumberOfEvents()) {
            sb.append(this.lookFor((int)i).event.toString());
            if (i < this.getNumberOfEvents() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    public SchemaInformedRule duplicate() {
        return this;
    }

    public EventInformation lookForEvent(EventType eventType) {
        EventInformation[] eventInformationArray = this.containers;
        int n = this.containers.length;
        int n2 = 0;
        while (n2 < n) {
            EventInformation ei = eventInformationArray[n2];
            if (ei.event.isEventType(eventType)) {
                return ei;
            }
            ++n2;
        }
        return null;
    }

    public EventInformation lookForStartElement(String namespaceURI, String localName) {
        EventInformation[] eventInformationArray = this.containers;
        int n = this.containers.length;
        int n2 = 0;
        while (n2 < n) {
            EventInformation ei = eventInformationArray[n2];
            if (ei.event.isEventType(EventType.START_ELEMENT) && AbstractSchemaInformedRule.checkQualifiedName(((StartElement)ei.event).getQName(), namespaceURI, localName)) {
                return ei;
            }
            ++n2;
        }
        return null;
    }

    public EventInformation lookForStartElementNS(String namespaceURI) {
        EventInformation[] eventInformationArray = this.containers;
        int n = this.containers.length;
        int n2 = 0;
        while (n2 < n) {
            EventInformation ei = eventInformationArray[n2];
            if (ei.event.isEventType(EventType.START_ELEMENT_NS) && ((StartElementNS)ei.event).getNamespaceURI().equals(namespaceURI)) {
                return ei;
            }
            ++n2;
        }
        return null;
    }

    public EventInformation lookForAttribute(String namespaceURI, String localName) {
        EventInformation[] eventInformationArray = this.containers;
        int n = this.containers.length;
        int n2 = 0;
        while (n2 < n) {
            EventInformation ei = eventInformationArray[n2];
            if (ei.event.isEventType(EventType.ATTRIBUTE) && AbstractSchemaInformedRule.checkQualifiedName(((Attribute)ei.event).getQName(), namespaceURI, localName)) {
                return ei;
            }
            ++n2;
        }
        return null;
    }

    public EventInformation lookForAttributeNS(String namespaceURI) {
        EventInformation[] eventInformationArray = this.containers;
        int n = this.containers.length;
        int n2 = 0;
        while (n2 < n) {
            EventInformation ei = eventInformationArray[n2];
            if (ei.event.isEventType(EventType.ATTRIBUTE_NS) && ((AttributeNS)ei.event).getNamespaceURI().equals(namespaceURI)) {
                return ei;
            }
            ++n2;
        }
        return null;
    }

    public EventInformation lookFor(int eventCode) {
        assert (eventCode >= 0 && eventCode < this.containers.length);
        return this.containers[eventCode];
    }

    public void setFirstElementRule() {
        throw new RuntimeException("Not allowed to set first element, only in StartTag");
    }
}

