/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class UnsignedLongDatatype
extends AbstractDatatype {
    private long lastUnsignedInteger;

    public UnsignedLongDatatype(QName datatypeIdentifier) {
        super(BuiltInType.UNSIGNED_LONG, datatypeIdentifier);
        this.rcs = new XSDIntegerCharacterSet();
    }

    public boolean isValid(String value) {
        try {
            this.lastUnsignedInteger = Long.parseLong(value);
            return this.lastUnsignedInteger >= 0L;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeUnsignedLong(this.lastUnsignedInteger);
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        return valueChannel.decodeUnsignedLongValue();
    }
}

