/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDIntegerCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import java.math.BigInteger;
import javax.xml.namespace.QName;

public class UnsignedBigIntegerDatatype
extends AbstractDatatype {
    private BigInteger lastUnsignedInteger;

    public UnsignedBigIntegerDatatype(QName datatypeIdentifier) {
        super(BuiltInType.UNSIGNED_BIG_INTEGER, datatypeIdentifier);
        this.rcs = new XSDIntegerCharacterSet();
    }

    public boolean isValid(String value) {
        try {
            this.lastUnsignedInteger = new BigInteger(value);
            return this.lastUnsignedInteger.signum() != -1;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeUnsignedBigInteger(this.lastUnsignedInteger);
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        return valueChannel.decodeUnsignedHugeIntegerValue();
    }
}

