/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.datatype.RestrictedCharacterSetDatatype;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.values.ListValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;

public class ListDatatype
extends AbstractDatatype {
    private Datatype listDatatype;
    protected int numberOfEnumeratedTypes;
    protected String lastValidValue;

    public ListDatatype(Datatype listDatatype) {
        super(BuiltInType.LIST, null);
        this.rcs = listDatatype.getRestrictedCharacterSet();
        if (listDatatype.getDefaultBuiltInType() == BuiltInType.LIST) {
            throw new IllegalArgumentException();
        }
        this.listDatatype = listDatatype;
    }

    public Datatype getListDatatype() {
        return this.listDatatype;
    }

    public boolean isValid(String value) {
        StringTokenizer st = new StringTokenizer(value, " ");
        this.numberOfEnumeratedTypes = 0;
        while (st.hasMoreTokens()) {
            if (!this.listDatatype.isValid(st.nextToken())) {
                return false;
            }
            ++this.numberOfEnumeratedTypes;
        }
        this.lastValidValue = value;
        return true;
    }

    public boolean isValidRCS(String value) {
        StringTokenizer st = new StringTokenizer(value, " ");
        this.numberOfEnumeratedTypes = st.countTokens();
        return super.isValidRCS(value);
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeUnsignedInteger(this.numberOfEnumeratedTypes);
        StringTokenizer st = new StringTokenizer(this.lastValidValue, " ");
        while (st.hasMoreTokens()) {
            this.listDatatype.isValid(st.nextToken());
            this.listDatatype.writeValue(valueChannel, stringEncoder, context);
        }
    }

    public void writeValueRCS(RestrictedCharacterSetDatatype rcsEncoder, EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeUnsignedInteger(this.numberOfEnumeratedTypes);
        StringTokenizer st = new StringTokenizer(this.lastRCSValue, " ");
        rcsEncoder.setRestrictedCharacterSet(this.rcs);
        while (st.hasMoreTokens()) {
            rcsEncoder.isValid(st.nextToken());
            rcsEncoder.writeValue(valueChannel, stringEncoder, context);
        }
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        int len = valueChannel.decodeUnsignedInteger();
        Value[] values = new Value[len];
        int i = 0;
        while (i < len) {
            values[i] = this.listDatatype.readValue(valueChannel, stringDecoder, context);
            ++i;
        }
        return new ListValue(values);
    }

    public Value readValueRCS(RestrictedCharacterSetDatatype rcsDecoder, DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        int len = valueChannel.decodeUnsignedInteger();
        Value[] values = new Value[len];
        rcsDecoder.setRestrictedCharacterSet(this.rcs);
        int i = 0;
        while (i < len) {
            values[i] = rcsDecoder.readValue(valueChannel, stringDecoder, context);
            ++i;
        }
        return new ListValue(values);
    }
}

