/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDDoubleCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.datatype.XSDDouble;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class DoubleDatatype
extends AbstractDatatype {
    protected XSDDouble lastValidDouble = XSDDouble.newInstance();

    public DoubleDatatype(QName datatypeIdentifier) {
        super(BuiltInType.DOUBLE, datatypeIdentifier);
        this.rcs = new XSDDoubleCharacterSet();
    }

    public boolean isValid(String value) {
        return this.lastValidDouble.parse(value);
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeDouble(this.lastValidDouble.mantissa, this.lastValidDouble.exponent);
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        return valueChannel.decodeDoubleValue();
    }
}

