/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDDecimalCharacterSet;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.datatype.strings.StringEncoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.util.datatype.XSDDecimal;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class DecimalDatatype
extends AbstractDatatype {
    private XSDDecimal lastValidDecimal = XSDDecimal.newInstance();

    public DecimalDatatype(QName datatypeIdentifier) {
        super(BuiltInType.DECIMAL, datatypeIdentifier);
        this.rcs = new XSDDecimalCharacterSet();
    }

    public boolean isValid(String value) {
        return this.lastValidDecimal.parse(value);
    }

    public void writeValue(EncoderChannel valueChannel, StringEncoder stringEncoder, QName context) throws IOException {
        valueChannel.encodeDecimal(this.lastValidDecimal.isNegative(), this.lastValidDecimal.getIntegral(), this.lastValidDecimal.getReverseFractional());
    }

    public Value readValue(DecoderChannel valueChannel, StringDecoder stringDecoder, QName context) throws IOException {
        return valueChannel.decodeDecimalValue();
    }
}

